/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.parts.handles;

import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import com.jaspersoft.studio.editor.gef.util.GEFUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;

public class CellResizeHandleLocator2
extends RelativeLocator {
    private double relativeY;
    private double relativeX;
    private int direction;
    private GraphicalEditPart editPart;

    public CellResizeHandleLocator2(GraphicalEditPart editPart, int location) {
        this.setReferenceFigure(editPart.getFigure());
        this.editPart = editPart;
        switch (location & 5) {
            case 1: {
                this.relativeY = 0.0;
                break;
            }
            case 4: {
                this.relativeY = 1.0;
                break;
            }
            default: {
                this.relativeY = 0.5;
            }
        }
        switch (location & 0x18) {
            case 8: {
                this.relativeX = 0.0;
                break;
            }
            case 16: {
                this.relativeX = 1.0;
                break;
            }
            default: {
                this.relativeX = 0.5;
            }
        }
        this.direction = location;
    }

    public void relocate(IFigure target) {
        Dimension targetSize;
        IFigure reference = this.getReferenceFigure();
        Rectangle referenceBox = null;
        referenceBox = reference instanceof HandleBounds ? ((HandleBounds)reference).getHandleBounds() : reference.getBounds();
        PrecisionRectangle targetBounds = new PrecisionRectangle(referenceBox.getResized(-1, -1));
        reference.translateToAbsolute((Translatable)targetBounds);
        target.translateToRelative((Translatable)targetBounds);
        targetBounds.resize(1, 1);
        double xzoom = GEFUtil.getZoom(this.editPart);
        Dimension d = targetSize = target.getPreferredSize();
        if (this.editPart instanceof IContainerPart) {
            d = ((IContainerPart)this.editPart).getContaierSize();
            Dimension dcopy = d.getCopy();
            dcopy.height = d.height + 18;
            d = dcopy.scale(xzoom);
        }
        int w = 4;
        int h = 4;
        switch (this.direction & 5) {
            case 1: {
                w = d.width + 1;
                targetBounds.y += (int)((double)targetBounds.height * this.relativeY - (double)targetSize.height);
                targetBounds.x = (int)Math.floor(10.0 * xzoom);
                break;
            }
            case 4: {
                w = d.width + 1;
                targetBounds.y += (int)((double)targetBounds.height * this.relativeY - (double)targetSize.height) - 1;
                targetBounds.x = (int)Math.floor(10.0 * xzoom);
            }
        }
        switch (this.direction & 0x18) {
            case 8: {
                h = d.height - (int)Math.floor(10.0 * xzoom);
                targetBounds.y = (int)Math.floor(7.0 * xzoom);
                targetBounds.x += (int)((double)targetBounds.width * this.relativeX - (double)targetSize.width);
                break;
            }
            case 16: {
                h = d.height - (int)Math.floor(10.0 * xzoom);
                targetBounds.y = (int)Math.floor(7.0 * xzoom);
                targetBounds.x += (int)((double)targetBounds.width * this.relativeX - (double)targetSize.width) - 1;
            }
        }
        targetBounds.setSize(w + 1, h + 1);
        target.setBounds((Rectangle)targetBounds);
    }
}

