/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers;

import com.jaspersoft.studio.model.IGuidebleElement;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class ReportRulerGuide
implements Serializable {
    public static final String PROPERTY_CHILDREN = "subparts changed";
    public static final String PROPERTY_POSITION = "position changed";
    static final long serialVersionUID = 1L;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Map<IGuidebleElement, Integer> map;
    private int position;
    private boolean horizontal;

    public ReportRulerGuide() {
    }

    public ReportRulerGuide(boolean isHorizontal) {
        this.setHorizontal(isHorizontal);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public Map<IGuidebleElement, Integer> getMap() {
        if (this.map == null) {
            this.map = new Hashtable<IGuidebleElement, Integer>();
        }
        return this.map;
    }

    public Set<IGuidebleElement> getParts() {
        return this.getMap().keySet();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal = isHorizontal;
    }

    public void setPosition(int offset) {
        if (this.position != offset) {
            int oldValue = this.position;
            this.position = offset;
            this.listeners.firePropertyChange(PROPERTY_POSITION, new Integer(oldValue), new Integer(this.position));
        }
    }

    public void attachPart(IGuidebleElement part, int alignment) {
        ReportRulerGuide parent;
        if (this.getMap().containsKey(part) && this.getAlignment(part) == alignment) {
            return;
        }
        this.getMap().put(part, new Integer(alignment));
        ReportRulerGuide reportRulerGuide = parent = this.isHorizontal() ? part.getHorizontalGuide() : part.getVerticalGuide();
        if (parent != null && parent != this) {
            parent.detachPart(part);
        }
        if (this.isHorizontal()) {
            part.setHorizontalGuide(this);
        } else {
            part.setVerticalGuide(this);
        }
        this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, part);
    }

    public void detachPart(IGuidebleElement part) {
        if (this.getMap().containsKey(part)) {
            this.getMap().remove(part);
            if (this.isHorizontal()) {
                part.setHorizontalGuide(null);
            } else {
                part.setVerticalGuide(null);
            }
            this.listeners.firePropertyChange(PROPERTY_CHILDREN, null, part);
        }
    }

    public int getAlignment(IGuidebleElement part) {
        if (this.getMap().get(part) != null) {
            return this.getMap().get(part);
        }
        return -2;
    }
}

