/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.actions;

import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.actions.PositionDialog;
import com.jaspersoft.studio.editor.gef.rulers.component.JDGuideEditPart;
import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerEditPart;
import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerFigure;
import com.jaspersoft.studio.messages.Messages;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.jface.action.Action;

public class EditGuideAction
extends Action {
    private EditPartViewer viewer;
    public static final String ID = "com.jaspersoft.studio.rulers.EditGuideAction";

    public EditGuideAction(EditPartViewer ruler) {
        super(Messages.EditGuideAction_editText);
        this.viewer = ruler;
        this.setToolTipText(Messages.EditGuideAction_editTooltip);
        this.setId(ID);
    }

    public void run() {
        JDRulerEditPart rulerEditPart = (JDRulerEditPart)((Object)this.viewer.getRootEditPart().getChildren().get(0));
        RulerProvider provider = rulerEditPart.getRulerProvider();
        ReportRuler ruler = (ReportRuler)provider.getRuler();
        List parts = this.viewer.getSelectedEditParts();
        if (!parts.isEmpty() && parts.get(0) instanceof JDGuideEditPart) {
            JDGuideEditPart editedPart = (JDGuideEditPart)((Object)parts.get(0));
            int oldPosition = provider.getGuidePosition(editedPart.getModel());
            JDRulerFigure rf = rulerEditPart.getRulerFigure();
            int offest = rf.isHorizontal() ? rf.getHoffset() : rf.getVoffset();
            PositionDialog dlg = new PositionDialog(UIUtils.getShell(), oldPosition - offest, provider.getUnit(), ruler.isHorizontal());
            if (dlg.open() == 0) {
                int newPosition = dlg.getPixelPosition() + offest;
                this.viewer.getEditDomain().getCommandStack().execute(provider.getMoveGuideCommand(editedPart.getModel(), newPosition - oldPosition));
                this.viewer.reveal((EditPart)editedPart);
            }
        }
    }
}

