/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.command;

import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerGuide;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.IGuidebleElement;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;

public class DeleteGuideCommand
extends Command {
    private ReportRuler parent;
    private ReportRulerGuide guide;
    private Map<IGuidebleElement, Integer> oldParts;

    public DeleteGuideCommand(ReportRulerGuide guide, ReportRuler parent) {
        super(Messages.DeleteGuideCommand_delete_guide);
        this.guide = guide;
        this.parent = parent;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.oldParts = new HashMap<IGuidebleElement, Integer>(this.guide.getMap());
        for (IGuidebleElement part : this.guide.getParts()) {
            this.guide.detachPart(part);
        }
        this.parent.removeGuide(this.guide);
    }

    public void undo() {
        this.parent.addGuide(this.guide);
        for (IGuidebleElement part : this.guide.getParts()) {
            this.guide.attachPart(part, this.oldParts.get(part));
        }
    }
}

