/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.command;

import com.jaspersoft.studio.editor.gef.commands.SetConstraintCommand;
import com.jaspersoft.studio.editor.gef.rulers.ReportRulerGuide;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGuidebleElement;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class MoveGuideCommand
extends Command {
    private List<SetConstraintCommand> constraintCommands;
    private int pDelta;
    private ReportRulerGuide guide;

    public MoveGuideCommand(ReportRulerGuide guide, int positionDelta) {
        super(Messages.MoveGuideCommand_move_guide);
        this.guide = guide;
        this.pDelta = positionDelta;
    }

    public void execute() {
        if (this.constraintCommands == null) {
            this.constraintCommands = new ArrayList<SetConstraintCommand>();
            for (IGuidebleElement part : this.guide.getParts()) {
                ANode node = (ANode)((Object)part);
                if (node.getParent() == null || !(node instanceof MGraphicElement)) continue;
                JRDesignElement jrE = (JRDesignElement)node.getValue();
                Point location = ModelUtils.getY4Element((MGraphicElement)node);
                if (this.guide.isHorizontal()) {
                    location.y += this.pDelta;
                } else {
                    location.x += this.pDelta;
                }
                SetConstraintCommand cc = new SetConstraintCommand();
                cc.setContext(null, node, new Rectangle(location.x, location.y, jrE.getWidth(), jrE.getHeight()));
                this.constraintCommands.add(cc);
            }
        }
        this.guide.setPosition(this.guide.getPosition() + this.pDelta);
        for (SetConstraintCommand c : this.constraintCommands) {
            c.execute();
        }
    }

    public void undo() {
        this.guide.setPosition(this.guide.getPosition() - this.pDelta);
        for (SetConstraintCommand c : this.constraintCommands) {
            c.undo();
        }
    }
}

