/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.component;

import com.jaspersoft.studio.editor.gef.rulers.ReportRuler;
import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerDragTracker;
import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerFigure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.rulers.RulerChangeListener;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Point;

public class JDRulerEditPart
extends AbstractGraphicalEditPart {
    protected GraphicalViewer diagramViewer;
    private AccessibleEditPart accPart;
    private RulerProvider rulerProvider;
    private boolean horizontal;
    private Point lastMousePosition = new Point(-1, -1);
    private MouseMotionListener mouseListener = new MouseMotionListener(){

        public void mouseMoved(MouseEvent me) {
            JDRulerEditPart.this.lastMousePosition.x = me.x;
            JDRulerEditPart.this.lastMousePosition.y = me.y;
        }

        public void mouseHover(MouseEvent me) {
            JDRulerEditPart.this.lastMousePosition.x = me.x;
            JDRulerEditPart.this.lastMousePosition.y = me.y;
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseEntered(MouseEvent me) {
            JDRulerEditPart.this.lastMousePosition.x = me.x;
            JDRulerEditPart.this.lastMousePosition.y = me.y;
        }

        public void mouseDragged(MouseEvent me) {
        }
    };
    private RulerChangeListener listener = new RulerChangeListener.Stub(){

        public void notifyGuideReparented(Object guide) {
            JDRulerEditPart.this.handleGuideReparented(guide);
        }

        public void notifyUnitsChanged(int newUnit) {
            JDRulerEditPart.this.handleUnitsChanged(newUnit);
        }
    };
    private RulerListener rulerLister;

    public JDRulerEditPart(Object model) {
        this.setModel(model);
    }

    public void activate() {
        this.rulerLister = new RulerListener();
        ((ReportRuler)this.getRulerProvider().getRuler()).addPropertyChangeListener(this.rulerLister);
        this.getRulerProvider().addRulerChangeListener(this.listener);
        this.getRulerFigure().setZoomManager(this.getZoomManager());
        super.activate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new RulerSelectionPolicy());
    }

    protected IFigure createFigure() {
        JDRulerFigure ruler = new JDRulerFigure(this.isHorizontal(), this.getRulerProvider().getUnit());
        if (ruler.getUnit() == 2) {
            ruler.setInterval(100, 10);
        }
        ruler.setHend(((ReportRuler)this.getRulerProvider().getRuler()).getHend());
        ruler.setHoffset(((ReportRuler)this.getRulerProvider().getRuler()).getHoffset());
        ruler.setVend(((ReportRuler)this.getRulerProvider().getRuler()).getVend());
        ruler.setVoffset(((ReportRuler)this.getRulerProvider().getRuler()).getVoffset());
        ruler.addMouseMotionListener(this.mouseListener);
        return ruler;
    }

    public void deactivate() {
        super.deactivate();
        ((ReportRuler)this.getRulerProvider().getRuler()).removePropertyChangeListener(this.rulerLister);
        this.getRulerProvider().removeRulerChangeListener(this.listener);
        this.rulerProvider = null;
        this.getRulerFigure().setZoomManager(null);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    e.result = JDRulerEditPart.this.isHorizontal() ? "Horizontal" : "Vertical";
                }

                public void getDescription(AccessibleEvent e) {
                    e.result = "Ruler";
                }
            };
        }
        return this.accPart;
    }

    protected GraphicalViewer getDiagramViewer() {
        return this.diagramViewer;
    }

    public DragTracker getDragTracker(Request request) {
        if (request.getType().equals("selection") && ((SelectionRequest)request).getLastButtonPressed() != 1) {
            return null;
        }
        return new JDRulerDragTracker(this);
    }

    public IFigure getGuideLayer() {
        LayerManager lm = (LayerManager)this.diagramViewer.getEditPartRegistry().get(LayerManager.ID);
        if (lm != null) {
            return lm.getLayer((Object)"Guide Layer");
        }
        return null;
    }

    protected List<?> getModelChildren() {
        return this.getRulerProvider().getGuides();
    }

    public JDRulerFigure getRulerFigure() {
        return (JDRulerFigure)this.getFigure();
    }

    public RulerProvider getRulerProvider() {
        return this.rulerProvider;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("move")) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.diagramViewer.getProperty(ZoomManager.class.toString());
    }

    public void handleGuideReparented(Object guide) {
        this.refreshChildren();
        EditPart guidePart = (EditPart)this.getViewer().getEditPartRegistry().get(guide);
        if (guidePart != null) {
            this.getViewer().select(guidePart);
        }
    }

    public void handleUnitsChanged(final int newUnit) {
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                JDRulerEditPart.this.getRulerFigure().setUnit(newUnit);
                if (newUnit == 2) {
                    JDRulerEditPart.this.getRulerFigure().setInterval(100, 10);
                } else {
                    JDRulerEditPart.this.getRulerFigure().setInterval(1, 10);
                }
            }
        });
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setParent(EditPart parent) {
        super.setParent(parent);
        if (this.getParent() != null && this.diagramViewer == null) {
            this.diagramViewer = (GraphicalViewer)this.getViewer().getProperty(GraphicalViewer.class.toString());
            RulerProvider hProvider = (RulerProvider)this.diagramViewer.getProperty("horizontal ruler");
            if (hProvider != null && hProvider.getRuler() == this.getModel()) {
                this.rulerProvider = hProvider;
                this.horizontal = true;
            } else {
                this.rulerProvider = (RulerProvider)this.diagramViewer.getProperty("vertical ruler");
            }
        }
    }

    public int getMousePosition() {
        int position;
        if (this.lastMousePosition.x == -1 && this.lastMousePosition.y == -1) {
            return -1;
        }
        JDRulerFigure figure = (JDRulerFigure)this.getFigure();
        PrecisionRectangle t = new PrecisionRectangle((double)this.lastMousePosition.x, (double)this.lastMousePosition.y, 0.0, 0.0);
        ZoomManager zoomManager = this.getZoomManager();
        Rectangle result = t.getTranslated(-((double)figure.getHoffset() * zoomManager.getZoom()), -((double)figure.getVoffset() * zoomManager.getZoom()));
        int n = position = this.isHorizontal() ? result.x : result.y;
        if (zoomManager != null) {
            position = (int)Math.round((double)position / zoomManager.getZoom());
        }
        return position;
    }

    private final class RulerListener
    implements PropertyChangeListener {
        private RulerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("HOFFSET")) {
                ((JDRulerFigure)JDRulerEditPart.this.getFigure()).setHoffset((Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("VOFFSET")) {
                ((JDRulerFigure)JDRulerEditPart.this.getFigure()).setVoffset((Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("HEND")) {
                ((JDRulerFigure)JDRulerEditPart.this.getFigure()).setHend((Integer)evt.getNewValue());
            } else if (evt.getPropertyName().equals("VEND")) {
                ((JDRulerFigure)JDRulerEditPart.this.getFigure()).setVend((Integer)evt.getNewValue());
            }
        }
    }

    public static class RulerSelectionPolicy
    extends SelectionEditPolicy {
        protected void hideFocus() {
            ((JDRulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void hideSelection() {
            ((JDRulerFigure)this.getHostFigure()).setDrawFocus(false);
        }

        protected void showFocus() {
            ((JDRulerFigure)this.getHostFigure()).setDrawFocus(true);
        }

        protected void showSelection() {
            ((JDRulerFigure)this.getHostFigure()).setDrawFocus(true);
        }
    }
}

