/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.rulers.component;

import com.jaspersoft.studio.editor.gef.rulers.component.JDRulerLayout;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ImageUtilities;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class JDRulerFigure
extends Figure {
    public int smallMarkWidth = 1;
    public int mediumMarkWidth = 5;
    public int textMargin = 3;
    public int minPixelsBetweenMarks = 7;
    public int minPixelsBetweenMajorMarks = 47;
    protected Transposer transposer = new Transposer();
    protected ZoomManager zoomManager;
    private boolean drawFocus = false;
    private static final int BORDER_WIDTH = 1;
    private boolean horizontal;
    private int unit;
    private int interval;
    private int divisions;
    private double dpu = -1.0;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoomValue) {
            JDRulerFigure.this.handleZoomChanged();
        }
    };
    int hoffset = 0;
    int voffset = 0;
    int hend = Integer.MAX_VALUE;
    int vend = Integer.MAX_VALUE;

    public JDRulerFigure(boolean isHorizontal, int measurementUnit) {
        this.setHorizontal(isHorizontal);
        this.setUnit(measurementUnit);
        this.setBackgroundColor(ColorConstants.listBackground);
        this.setForegroundColor(ColorConstants.listForeground);
        this.setOpaque(true);
        this.setLayoutManager((LayoutManager)new JDRulerLayout());
    }

    public static org.eclipse.swt.graphics.Point getDpi() {
        int dpi = (Integer)Misc.nvl((Object)JasperReportsConfiguration.getDefaultInstance().getPropertyInteger("net.sf.jasperreports.image.dpi"), (Object)72);
        return new org.eclipse.swt.graphics.Point(dpi, dpi);
    }

    protected double getDPU() {
        if (this.dpu <= 0.0) {
            if (this.getUnit() == 2) {
                this.dpu = 1.0;
            } else {
                this.dpu = this.transposer.t((Dimension)new Dimension((org.eclipse.swt.graphics.Point)JDRulerFigure.getDpi())).height;
                if (this.getUnit() == 1) {
                    this.dpu /= 2.54;
                }
            }
            if (this.zoomManager != null) {
                this.dpu *= this.zoomManager.getZoom();
            }
        }
        return this.dpu;
    }

    public boolean getDrawFocus() {
        return this.drawFocus;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension prefSize = new Dimension();
        if (this.isHorizontal()) {
            prefSize.height = this.textMargin * 2 + 1 + FigureUtilities.getFontMetrics((Font)this.getFont()).getAscent();
        } else {
            prefSize.width = this.textMargin * 2 + 1 + FigureUtilities.getFontMetrics((Font)this.getFont()).getAscent();
        }
        return prefSize;
    }

    public int getUnit() {
        return this.unit;
    }

    protected void handleZoomChanged() {
        this.dpu = -1.0;
        this.repaint();
        this.layout();
    }

    public void invalidate() {
        super.invalidate();
        this.dpu = -1.0;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    protected void paintFigure(Graphics graphics) {
        int divsPerMajorMark;
        double dotsPerUnit = this.getDPU();
        Rectangle clip = this.transposer.t(graphics.getClip(Rectangle.SINGLETON));
        Rectangle figClientArea = this.transposer.t(this.getClientArea());
        Rectangle clippedBounds = clip;
        clippedBounds.x = figClientArea.x;
        clippedBounds.width = figClientArea.width - 1;
        if (this.isOpaque()) {
            graphics.fillRectangle(this.transposer.t(clippedBounds));
        }
        int unitsPerMajorMark = (int)((double)this.minPixelsBetweenMajorMarks / dotsPerUnit);
        if (Float.compare((float)((double)this.minPixelsBetweenMajorMarks % dotsPerUnit), 0.0f) != 0) {
            ++unitsPerMajorMark;
        }
        if (this.interval > 0) {
            int intervalMultiple = this.interval;
            while (intervalMultiple < unitsPerMajorMark) {
                intervalMultiple += this.interval;
            }
            unitsPerMajorMark = intervalMultiple;
        } else if (unitsPerMajorMark != 1 && unitsPerMajorMark % 2 != 0) {
            ++unitsPerMajorMark;
        }
        if (this.divisions > 0 && dotsPerUnit * (double)unitsPerMajorMark / (double)this.divisions >= (double)this.minPixelsBetweenMarks) {
            divsPerMajorMark = this.divisions;
        } else {
            divsPerMajorMark = 2;
            if (this.getUnit() == 1) {
                divsPerMajorMark = 10;
            } else if (this.getUnit() == 0) {
                divsPerMajorMark = 8;
            }
            while (dotsPerUnit * (double)unitsPerMajorMark / (double)divsPerMajorMark < (double)this.minPixelsBetweenMarks) {
                if ((divsPerMajorMark /= 2) == 0) break;
            }
            if (divsPerMajorMark == 0) {
                divsPerMajorMark = 1;
            }
        }
        int mediumMarkerDivNum = 1;
        switch (divsPerMajorMark) {
            case 5: 
            case 10: 
            case 20: {
                mediumMarkerDivNum = 5;
                break;
            }
            case 8: 
            case 16: {
                mediumMarkerDivNum = 4;
                break;
            }
            case 4: {
                mediumMarkerDivNum = 2;
                break;
            }
            case 2: {
                mediumMarkerDivNum = 1;
            }
        }
        double dotsPerDivision = dotsPerUnit * (double)unitsPerMajorMark / (double)divsPerMajorMark;
        int startMark = (int)((double)clippedBounds.y / (dotsPerUnit * (double)unitsPerMajorMark)) * divsPerMajorMark;
        if (startMark > 0) {
            startMark = 0;
        }
        if (clippedBounds.y < 0) {
            startMark -= divsPerMajorMark;
        }
        int endMark = (int)((double)(clippedBounds.y + clippedBounds.height) / dotsPerDivision) + 1;
        int leading = FigureUtilities.getFontMetrics((Font)this.getFont()).getLeading();
        Rectangle forbiddenZone = new Rectangle();
        int div = startMark;
        while (div <= endMark) {
            Point end;
            Point start;
            int y = (int)((double)((int)((double)div * dotsPerDivision)) + (double)(this.isHorizontal() ? this.hoffset : this.voffset) * this.zoomManager.getZoom());
            if (div % divsPerMajorMark == 0) {
                Point textLocation;
                String num = "" + div / divsPerMajorMark * unitsPerMajorMark;
                if (this.isHorizontal()) {
                    Dimension numSize = FigureUtilities.getStringExtents((String)num, (Font)this.getFont());
                    if (numSize.width % 2 == 0) {
                        ++numSize.width;
                    }
                    textLocation = new Point(y - numSize.width / 2, clippedBounds.x + this.textMargin - leading - 1);
                    forbiddenZone.setLocation(textLocation);
                    forbiddenZone.setSize(numSize);
                    forbiddenZone.expand(1, 1);
                    graphics.fillRectangle(forbiddenZone);
                    graphics.drawText(num, textLocation);
                } else {
                    Image numImage = ImageUtilities.createRotatedImageOfString((String)num, (Font)this.getFont(), (Color)this.getForegroundColor(), (Color)this.getBackgroundColor());
                    textLocation = new Point(clippedBounds.x + this.textMargin, y - numImage.getBounds().height / 2);
                    forbiddenZone.setLocation(textLocation);
                    forbiddenZone.setSize(numImage.getBounds().width, numImage.getBounds().height);
                    forbiddenZone.expand(1, 1 + (numImage.getBounds().height % 2 == 0 ? 1 : 0));
                    graphics.fillRectangle(forbiddenZone);
                    graphics.drawImage(numImage, textLocation);
                    numImage.dispose();
                }
            } else if (div % divsPerMajorMark % mediumMarkerDivNum == 0) {
                start = this.transposer.t(new Point((clippedBounds.getRight().x - this.mediumMarkWidth) / 2, y));
                end = this.transposer.t(new Point((clippedBounds.getRight().x - this.mediumMarkWidth) / 2 + this.mediumMarkWidth, y));
                if (!forbiddenZone.contains(start)) {
                    graphics.drawLine(start, end);
                }
            } else {
                start = this.transposer.t(new Point((clippedBounds.getRight().x - this.smallMarkWidth) / 2, y));
                end = this.transposer.t(new Point((clippedBounds.getRight().x - this.smallMarkWidth) / 2 + this.smallMarkWidth, y));
                if (!forbiddenZone.contains(start)) {
                    graphics.drawLine(start, end);
                }
            }
            ++div;
        }
        this.drawMargins(graphics, clippedBounds);
        clippedBounds.expand(1, 0);
        graphics.setForegroundColor(ColorConstants.buttonDarker);
        graphics.drawLine(this.transposer.t(clippedBounds.getTopRight().translate(-1, -1)), this.transposer.t(clippedBounds.getBottomRight().translate(-1, -1)));
    }

    private void drawMargins(Graphics graphics, Rectangle clippedBounds) {
        if (this.isOpaque()) {
            Rectangle t = this.transposer.t(clippedBounds);
            graphics.setAlpha(128);
            graphics.setBackgroundColor(ColorConstants.gray);
            if (this.isHorizontal()) {
                int swidth = this.getSize().width;
                graphics.fillRectangle(0 - swidth, 0, (int)((double)this.hoffset * this.zoomManager.getZoom()) + swidth, t.height);
                graphics.fillRectangle((int)((double)(this.hoffset + this.hend) * this.zoomManager.getZoom()), 0, swidth, t.height);
            } else {
                int sheight = this.getSize().height;
                graphics.fillRectangle(0, 0 - sheight, t.width, (int)(this.zoomManager.getZoom() * (double)this.voffset) + sheight);
                graphics.fillRectangle(0, (int)((double)(this.vend + this.voffset) * this.zoomManager.getZoom()), t.width, sheight);
            }
            graphics.setAlpha(0);
            graphics.setBackgroundColor(ColorConstants.white);
        }
    }

    public int getHoffset() {
        return this.hoffset;
    }

    public void setHoffset(int hoffset) {
        this.hoffset = hoffset;
    }

    public int getVoffset() {
        return this.voffset;
    }

    public void setVoffset(int voffset) {
        this.voffset = voffset;
    }

    public int getHend() {
        return this.hend;
    }

    public void setHend(int hend) {
        this.hend = hend;
    }

    public int getVend() {
        return this.vend;
    }

    public void setVend(int vend) {
        this.vend = vend;
    }

    public void setDrawFocus(boolean drawFocus) {
        if (this.drawFocus != drawFocus) {
            this.drawFocus = drawFocus;
            this.repaint();
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        this.horizontal = isHorizontal;
        this.transposer.setEnabled(isHorizontal);
    }

    public void setInterval(int unitsPerMajorMark, int divisionsPerMajorMark) {
        this.interval = unitsPerMajorMark;
        this.divisions = divisionsPerMajorMark;
        this.repaint();
    }

    public void setUnit(int newUnit) {
        if (this.unit != newUnit) {
            this.unit = newUnit;
            this.dpu = -1.0;
            this.repaint();
        }
    }

    public void setZoomManager(ZoomManager manager) {
        if (this.zoomManager != manager) {
            if (this.zoomManager != null) {
                this.zoomManager.removeZoomListener(this.zoomListener);
            }
            this.zoomManager = manager;
            if (this.zoomManager != null) {
                this.zoomManager.addZoomListener(this.zoomListener);
            }
        }
    }
}

