/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.selection;

import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.ResizeHandle;

public class ColoredSquareHandles
extends ResizeHandle {
    protected static int JSS_HANDLE_SIZE = 8;
    protected static Color[] JSS_OVERLAP_COLOR = null;
    protected static Color[] JSS_COVER_COLOR = null;
    protected static Color[] JSS_FOCUSED_COLOR = null;
    protected static Color[] JSS_NOT_FOCUSED_COLOR = null;
    private List<Object> oldSelection = null;
    private Rectangle ownerOldBounds = null;
    private Color[] oldColor = null;

    public ColoredSquareHandles(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected Color[] CreateColor(float baseColor) {
        Color[] result = new Color[]{Color.getHSBColor(baseColor, 0.9f, 0.4f), Color.getHSBColor(baseColor, 0.8f, 0.2f), Color.getHSBColor(baseColor, 0.5f, 0.9f)};
        return result;
    }

    protected void init() {
        super.init();
        this.setPreferredSize(new Dimension(JSS_HANDLE_SIZE, JSS_HANDLE_SIZE));
        if (JSS_OVERLAP_COLOR == null) {
            float baseColor = new Float(Math.tan(Math.toRadians(120.0))).floatValue();
            JSS_OVERLAP_COLOR = this.CreateColor(baseColor);
            baseColor = new Float(Math.tan(Math.toRadians(0.0))).floatValue();
            JSS_COVER_COLOR = this.CreateColor(baseColor);
            baseColor = new Float(Math.tan(Math.toRadians(30.0))).floatValue();
            JSS_FOCUSED_COLOR = this.CreateColor(baseColor);
            baseColor = new Float(Math.tan(Math.toRadians(0.0))).floatValue();
            Color[] result = new Color[]{Color.getHSBColor(baseColor, 0.2f, 0.3f), Color.getHSBColor(baseColor, 0.05f, 0.3f), Color.getHSBColor(baseColor, 0.05f, 0.6f)};
            JSS_NOT_FOCUSED_COLOR = result;
        }
    }

    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            Graphics2D gr = ComponentFigure.getG2D(g);
            if (g != null) {
                Color[] newColor = this.getFillColorAwt();
                gr.setColor(newColor[0]);
                gr.setStroke(new BasicStroke(1.0f));
                gr.drawRect(r.x - 1, r.y - 1, r.width + 1, r.height + 1);
                GradientPaint gp = new GradientPaint(r.x + r.width, r.y + r.height, newColor[1], r.x, r.y, newColor[2]);
                gr.setPaint(gp);
                gr.fillRect(r.x, r.y, r.width, r.height);
            }
        }
        finally {
            r.expand(1, 1);
        }
    }

    protected Color[] getFillColorAwt() {
        ANode element = (ANode)this.getOwner().getModel();
        if (element.getParent() == null) {
            return JSS_FOCUSED_COLOR;
        }
        Rectangle bound1 = ((IGraphicElement)((Object)element)).getBounds();
        if (this.oldSelection != null && this.oldColor != null && this.ownerOldBounds != null && this.oldSelection.equals(this.getOwner().getViewer().getSelectedEditParts()) && this.ownerOldBounds.equals((Object)bound1)) {
            return this.oldColor;
        }
        this.oldSelection = new ArrayList<Object>(this.getOwner().getViewer().getSelectedEditParts());
        this.ownerOldBounds = bound1;
        int index1 = element.getParent().getChildren().indexOf(element);
        List<INode> brothers = element.getParent().getChildren();
        Iterator<INode> it = brothers.iterator();
        boolean overlap = false;
        boolean cover = false;
        while (it.hasNext() && !cover) {
            INode actualElement = it.next();
            if (actualElement.equals(element) || !(actualElement instanceof MGraphicElement)) continue;
            MGraphicElement element2 = (MGraphicElement)actualElement;
            int index2 = element.getParent().getChildren().indexOf(element2);
            Rectangle bound2 = element2.getBounds();
            if (bound1.intersects(bound2)) {
                overlap = true;
            }
            if (!bound1.contains(bound2) || index1 <= index2) continue;
            cover = true;
        }
        this.oldColor = cover ? JSS_COVER_COLOR : (overlap ? JSS_OVERLAP_COLOR : (this.isPrimary() ? JSS_FOCUSED_COLOR : JSS_NOT_FOCUSED_COLOR));
        return this.oldColor;
    }

    public void setOverlapColor(float newColor) {
        float baseColor = new Float(Math.tan(Math.toRadians(newColor))).floatValue();
        JSS_OVERLAP_COLOR = this.CreateColor(baseColor);
    }

    public void setCoverColor(float newColor) {
        float baseColor = new Float(Math.tan(Math.toRadians(newColor))).floatValue();
        JSS_COVER_COLOR = this.CreateColor(baseColor);
    }

    public void setFocusedColor(float newColor) {
        float baseColor = new Float(Math.tan(Math.toRadians(newColor))).floatValue();
        JSS_FOCUSED_COLOR = this.CreateColor(baseColor);
    }

    public void setNotFocusedColor(float newColor) {
        float baseColor = new Float(Math.tan(Math.toRadians(newColor))).floatValue();
        Color[] result = new Color[]{Color.getHSBColor(baseColor, 0.2f, 0.3f), Color.getHSBColor(baseColor, 0.05f, 0.3f), Color.getHSBColor(baseColor, 0.05f, 0.6f)};
        JSS_NOT_FOCUSED_COLOR = result;
    }

    public void setSize(int newSize) {
        JSS_HANDLE_SIZE = newSize;
    }
}

