/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.selection;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.JSSScalableFreeformRootEditPart;
import com.jaspersoft.studio.editor.gef.selection.GroupSelectionEditPart;
import com.jaspersoft.studio.editor.gef.selection.JSelectionManager;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IDesignDragable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;

public class GroupResizeTracker
extends ResizeTracker {
    private ZoomManager zoomManager;

    public GroupResizeTracker(GroupSelectionEditPart owner, int direction) {
        super((GraphicalEditPart)owner, direction);
    }

    private ANode getLockableNode() {
        for (Object part : this.getOperationSet()) {
            ANode mainNode;
            EditPart ePart;
            if (!(part instanceof EditPart) || !((ePart = (EditPart)part).getModel() instanceof ANode) || (mainNode = JSSCompoundCommand.getMainNode((ANode)ePart.getModel())) == null) continue;
            return mainNode;
        }
        return null;
    }

    protected Command getCurrentCommand() {
        Object command = super.getCurrentCommand();
        if (!(command instanceof JSSCompoundCommand)) {
            if (command instanceof CompoundCommand) {
                CompoundCommand cc = (CompoundCommand)command;
                JSSCompoundCommand jsscc = new JSSCompoundCommand(cc, this.getLockableNode());
                command = jsscc;
            } else {
                JSSCompoundCommand jsscc = new JSSCompoundCommand(this.getLockableNode());
                jsscc.add((Command)command);
                command = jsscc;
            }
        }
        return command;
    }

    protected void showTargetFeedback() {
        Command command = this.getCurrentCommand();
        if (command != null && command.canExecute()) {
            super.showTargetFeedback();
        }
    }

    protected double getZoom() {
        if (this.zoomManager == null) {
            EditPartViewer viewer = this.getCurrentViewer();
            this.zoomManager = (ZoomManager)viewer.getProperty(ZoomManager.class.toString());
            if (this.zoomManager == null) {
                this.zoomManager = ((JSSScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
            }
        }
        return this.zoomManager != null ? this.zoomManager.getZoom() : 1.0;
    }

    protected GraphicalEditPart getTargetEditPart() {
        return null;
    }

    protected List<?> createOperationSet() {
        JSelectionManager selectionManager = ((GroupSelectionEditPart)this.getOwner()).getSelectionManager();
        ArrayList<GraphicalEditPart> operationSet = new ArrayList<GraphicalEditPart>(((StructuredSelection)selectionManager.getSelection()).toList());
        operationSet.add(this.getOwner());
        return operationSet;
    }

    protected Cursor getDefaultCursor() {
        return SharedCursors.getDirectionalCursor((int)this.getResizeDirection(), (boolean)this.getOwner().getFigure().isMirrored());
    }

    protected Command getCommand() {
        List editparts = this.getOperationSet();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Resize Group Handle Tracker");
        Pair<Double, Double> scaleFator = this.calculateScaleFactor();
        Integer originX = null;
        Integer originY = null;
        int i = 0;
        while (i < editparts.size()) {
            EditPart editPart = (EditPart)editparts.get(i);
            if (!(editPart instanceof GroupSelectionEditPart)) {
                Rectangle bounds = ((FigureEditPart)editPart).getFigure().getBounds();
                if (originX == null || originX > bounds.x) {
                    originX = bounds.x;
                }
                if (originY == null || originY > bounds.y) {
                    originY = bounds.y;
                }
            }
            ++i;
        }
        i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part instanceof GroupSelectionEditPart) {
                command.add(part.getCommand(this.getSourceRequest()));
            } else {
                command.add(part.getCommand(this.getSourceRequest((Double)scaleFator.getKey(), (Double)scaleFator.getValue(), part, originX, originY)));
            }
            ++i;
        }
        return command.unwrap();
    }

    protected void showSourceFeedback() {
        Command command = this.getCurrentCommand();
        if (command != null && command.canExecute()) {
            EditPart editPart;
            Pair<Double, Double> scaleFator = this.calculateScaleFactor();
            List editParts = this.getOperationSet();
            Integer originX = null;
            Integer originY = null;
            int i = 0;
            while (i < editParts.size()) {
                editPart = (EditPart)editParts.get(i);
                if (!(editPart instanceof GroupSelectionEditPart)) {
                    Rectangle bounds = ((FigureEditPart)editPart).getFigure().getBounds();
                    if (originX == null || originX > bounds.x) {
                        originX = bounds.x;
                    }
                    if (originY == null || originY > bounds.y) {
                        originY = bounds.y;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < editParts.size()) {
                editPart = (EditPart)editParts.get(i);
                if (editPart instanceof GroupSelectionEditPart) {
                    editPart.showSourceFeedback(this.getSourceRequest());
                } else {
                    editPart.showSourceFeedback(this.getSourceRequest((Double)scaleFator.getKey(), (Double)scaleFator.getValue(), editPart, originX, originY));
                }
                ++i;
            }
            this.setFlag(16, true);
        }
    }

    private Pair<Double, Double> calculateScaleFactor() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)super.getSourceRequest();
        double percentageResizeWidth = 1.0;
        double percentageResizeHeight = 1.0;
        double sizeDelta_width = request.getSizeDelta().width;
        double sizeDelta_height = request.getSizeDelta().height;
        if (sizeDelta_width != 0.0 || sizeDelta_height != 0.0) {
            for (Object part : request.getEditParts()) {
                EditPart editPart = (EditPart)part;
                if (!(editPart instanceof GroupSelectionEditPart)) continue;
                Rectangle bounds = this.getBounds();
                double newWidth = (double)bounds.width + sizeDelta_width;
                double newHeight = (double)bounds.height + sizeDelta_height;
                percentageResizeWidth = newWidth / (double)bounds.width;
                percentageResizeHeight = newHeight / (double)bounds.height;
                break;
            }
        }
        return new Pair((Object)percentageResizeWidth, (Object)percentageResizeHeight);
    }

    protected Rectangle getBounds() {
        return this.getOwner().getFigure().getBounds();
    }

    protected Request getSourceRequest(double scaleFactorWidth, double scaleFactorHeight, EditPart resizedPart, int originX, int originY) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.createSourceRequest();
        request.setEditParts(resizedPart);
        ANode model = (ANode)resizedPart.getModel();
        if (model instanceof IDesignDragable) {
            int relativeY;
            int relativeX;
            IDesignDragable element = (IDesignDragable)((Object)model);
            double zoom = this.getZoom();
            Rectangle bounds = element.getJRBounds();
            double newWidth = (double)bounds.width * scaleFactorWidth;
            request.getSizeDelta().setWidth((int)Math.round((newWidth - (double)bounds.width) * zoom));
            double newHeight = (double)bounds.height * scaleFactorHeight;
            request.getSizeDelta().setHeight((int)Math.round((newHeight - (double)bounds.height) * zoom));
            Rectangle figureBounds = ((FigureEditPart)resizedPart).getFigure().getBounds();
            if (this.getResizeDirection() == 16 || this.getResizeDirection() == 17 || this.getResizeDirection() == 20) {
                if (figureBounds.x != originX) {
                    relativeX = figureBounds.x - originX;
                    request.getMoveDelta().setX((int)Math.round(((double)relativeX * scaleFactorWidth - (double)relativeX) * zoom));
                }
            } else if (this.getResizeDirection() == 8 || this.getResizeDirection() == 9 || this.getResizeDirection() == 12) {
                if (figureBounds.x != originX) {
                    relativeX = figureBounds.x - originX;
                    int leftMovement = ((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta().x;
                    request.getMoveDelta().setX((int)Math.round((double)leftMovement + ((double)relativeX * scaleFactorWidth - (double)relativeX) * zoom));
                } else {
                    int leftMovement = ((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta().x;
                    request.getMoveDelta().setX(leftMovement);
                }
            }
            if (this.getResizeDirection() == 4 || this.getResizeDirection() == 20 || this.getResizeDirection() == 12) {
                if (figureBounds.y != originY) {
                    relativeY = figureBounds.y - originY;
                    request.getMoveDelta().setY((int)Math.round(((double)relativeY * scaleFactorHeight - (double)relativeY) * zoom));
                }
            } else if (this.getResizeDirection() == 1 || this.getResizeDirection() == 9 || this.getResizeDirection() == 9) {
                if (figureBounds.y != originY) {
                    relativeY = figureBounds.y - originY;
                    int upMovement = ((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta().y;
                    request.getMoveDelta().setY((int)Math.round((double)upMovement + ((double)relativeY * scaleFactorHeight - (double)relativeY) * zoom));
                } else {
                    int upMovement = ((ChangeBoundsRequest)this.getSourceRequest()).getMoveDelta().y;
                    request.getMoveDelta().setY(upMovement);
                }
            }
        }
        return request;
    }
}

