/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.selection;

import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectElementsByValueCommand
extends Command {
    private List<Object> elementsToSelect;
    private EditPartViewer viewer;
    private ISelection oldSelection = null;

    public SelectElementsByValueCommand(List<Object> elementsToSelect, EditPartViewer viewer) {
        this.elementsToSelect = elementsToSelect;
        this.viewer = viewer;
    }

    public SelectElementsByValueCommand(Object elementToSelect, EditPartViewer viewer) {
        this.elementsToSelect = new ArrayList<Object>();
        this.elementsToSelect.add(elementToSelect);
        this.viewer = viewer;
    }

    public void execute() {
        if (!this.elementsToSelect.isEmpty()) {
            this.oldSelection = this.viewer.getSelection();
            ArrayList<EditPart> editParstToSelect = new ArrayList<EditPart>();
            for (Object element : this.elementsToSelect) {
                EditPart elementPart = SelectionHelper.getEditPartByValue(element, this.viewer);
                if (elementPart == null) continue;
                editParstToSelect.add(elementPart);
            }
            if (!editParstToSelect.isEmpty()) {
                this.viewer.setSelection((ISelection)new StructuredSelection(editParstToSelect));
                this.viewer.reveal((EditPart)editParstToSelect.get(0));
            }
        }
    }

    public boolean canExecute() {
        return this.elementsToSelect != null && this.viewer != null;
    }

    public void undo() {
        if (this.oldSelection != null) {
            this.viewer.setSelection(this.oldSelection);
        }
    }
}

