/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.selection;

import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Pair;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;

public class SelectNodesCommand
extends Command {
    private List<ANode> elementsToSelect;
    private Pair<ISelection, EditPartViewer> oldSelection = null;

    public SelectNodesCommand(List<ANode> elementsToSelect) {
        this.elementsToSelect = elementsToSelect;
    }

    public SelectNodesCommand(ANode elementToSelect) {
        this.elementsToSelect = new ArrayList<ANode>();
        this.elementsToSelect.add(elementToSelect);
    }

    public void execute() {
        if (!this.elementsToSelect.isEmpty()) {
            this.oldSelection = SelectionHelper.setNodeSelection(this.elementsToSelect, false);
        }
    }

    public boolean canExecute() {
        return this.elementsToSelect != null;
    }

    public void undo() {
        if (this.oldSelection != null) {
            ((EditPartViewer)this.oldSelection.getValue()).setSelection((ISelection)this.oldSelection.getKey());
        }
    }
}

