/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.ui.actions;

import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class RZoomComboContributionItem
extends ContributionItem
implements ZoomListener {
    private Combo combo;
    private boolean forceSetText;
    private String[] initStrings;
    private ToolItem toolitem;
    private ZoomManager zoomManager;

    public RZoomComboContributionItem() {
        this(new String[]{"8888%"}, null);
    }

    public RZoomComboContributionItem(ZoomManager manager) {
        this(new String[]{"8888%"}, manager);
    }

    public RZoomComboContributionItem(String[] initStrings, ZoomManager manager) {
        super("org.eclipse.gef.zoom_widget");
        this.initStrings = initStrings;
        this.setZoomManager(manager);
    }

    private void refresh(boolean repopulateCombo) {
        block8: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (this.zoomManager == null) {
                    this.combo.setEnabled(false);
                    this.combo.setText("");
                } else {
                    String zoom;
                    int index;
                    if (repopulateCombo) {
                        this.combo.setItems(this.zoomManager.getZoomLevelsAsText());
                    }
                    if ((index = this.combo.indexOf(zoom = this.zoomManager.getZoomAsText())) == -1 || this.forceSetText) {
                        this.combo.setText(zoom);
                    } else {
                        this.combo.select(index);
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block8;
                throw exception;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setEnabled(enabled);
        }
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    protected Control createControl(Composite parent) {
        Composite comboComp = new Composite(parent, 0);
        GridLayout comboCompL = new GridLayout();
        comboCompL.horizontalSpacing = 0;
        comboCompL.verticalSpacing = 0;
        comboCompL.marginHeight = 0;
        comboCompL.marginWidth = 0;
        comboComp.setLayout((Layout)comboCompL);
        this.combo = new Combo(comboComp, 4);
        GridData comboGD = new GridData(4, 0x1000000, true, true);
        this.combo.setLayoutData((Object)comboGD);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RZoomComboContributionItem.this.handleWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RZoomComboContributionItem.this.handleWidgetDefaultSelected(e);
            }
        });
        this.combo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                RZoomComboContributionItem.this.refresh(false);
                RZoomComboContributionItem.this.combo.setSelection(new Point(0, 0));
            }
        });
        this.combo.setItems(this.initStrings);
        this.toolitem.setWidth(this.computeWidth((Control)comboComp));
        this.refresh(true);
        return comboComp;
    }

    public void dispose() {
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
            this.zoomManager = null;
        }
        if (this.combo != null) {
            this.combo.dispose();
        }
        this.combo = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    public void setZoomManager(ZoomManager zm) {
        if (this.zoomManager == zm) {
            return;
        }
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
        }
        this.zoomManager = zm;
        this.refresh(true);
        if (this.zoomManager != null) {
            this.zoomManager.addZoomListener((ZoomListener)this);
        }
    }

    private void handleWidgetDefaultSelected(SelectionEvent event) {
        if (this.zoomManager != null) {
            if (this.combo.getSelectionIndex() >= 0) {
                this.zoomManager.setZoomAsText(this.combo.getItem(this.combo.getSelectionIndex()));
            } else {
                this.zoomManager.setZoomAsText(this.combo.getText());
            }
        }
        this.refresh(false);
    }

    private void handleWidgetSelected(SelectionEvent event) {
        this.forceSetText = true;
        this.handleWidgetDefaultSelected(event);
        this.forceSetText = false;
    }

    public void zoomChanged(double zoom) {
        this.refresh(false);
    }
}

