/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.gef.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class FigureTextWriter {
    private String text;
    private boolean showName;
    private Point namePosition;
    private Dimension nameSize;
    private Rectangle oldca;

    public void setShowName(boolean showName) {
        this.showName = showName;
    }

    public void setText(String bandText) {
        this.text = bandText;
        this.namePosition = null;
        this.nameSize = null;
    }

    private void computeNamePositionAndSize(Graphics2D g, Rectangle clientArea) {
        if (this.namePosition == null || !this.oldca.equals((Object)clientArea)) {
            FontRenderContext frc = g.getFontRenderContext();
            Font currfont = g.getFont();
            float sw = (float)currfont.getStringBounds(this.text, frc).getWidth();
            LineMetrics lm = currfont.getLineMetrics(this.text, frc);
            float sh = lm.getHeight();
            Rectangle tmpRect = clientArea;
            float sx = (float)tmpRect.x + ((float)tmpRect.width - sw) / 2.0f;
            float sy = (float)tmpRect.y + ((float)tmpRect.height + sh) / 2.0f - lm.getDescent();
            this.namePosition = new Point((int)sx, (int)sy);
            this.nameSize = new Dimension((int)sw, (int)sh);
        }
        this.oldca = clientArea;
    }

    public void painText(Graphics2D g, IFigure figure) {
        if (!Misc.nvl((String)this.text).isEmpty() && this.showName) {
            Font currfont = g.getFont();
            if ((float)currfont.getSize() != 16.0f) {
                g.setFont(currfont.deriveFont(16.0f));
            }
            this.computeNamePositionAndSize(g, figure.getClientArea());
            if (this.nameSize.height < figure.getBounds().height) {
                Color currColor = g.getColor();
                g.setColor(Color.GRAY);
                g.drawString(this.text, this.namePosition.x, this.namePosition.y);
                g.setColor(currColor);
            }
            g.setFont(currfont);
        }
    }
}

