/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d;

import com.jaspersoft.studio.editor.java2d.ISelectionOverrider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;

public class JSSScrollingGraphicalViewer
extends ScrollingGraphicalViewer {
    protected List<ISelectionOverrider> selectionOverriders = new ArrayList<ISelectionOverrider>();
    private boolean paintOnlyVisibleElements = true;

    public boolean isPaintOnlyVisibleElements() {
        return this.paintOnlyVisibleElements;
    }

    public void setPaintOnlyVisibleElements(boolean value) {
        this.paintOnlyVisibleElements = value;
    }

    public void appendSelection(EditPart editpart) {
        boolean wasOverride = false;
        for (ISelectionOverrider selectionOverrider : this.selectionOverriders) {
            wasOverride = selectionOverrider.overriddenSelection(editpart, this.getSelectedEditParts(), (GraphicalViewer)this);
            if (wasOverride) break;
        }
        if (!wasOverride) {
            super.appendSelection(editpart);
        }
    }

    public void select(EditPart editpart) {
        List<?> previousSelection = this.primDeselectAll();
        boolean wasOverride = false;
        for (ISelectionOverrider selectionOverrider : this.selectionOverriders) {
            wasOverride = selectionOverrider.overriddenSelection(editpart, previousSelection, (GraphicalViewer)this);
            if (wasOverride) break;
        }
        if (!wasOverride) {
            if (this.getSelectedEditParts().size() == 1 && this.getSelectedEditParts().get(0) == editpart) {
                return;
            }
            this.primDeselectAll();
            super.appendSelection(editpart);
        }
    }

    protected List<?> primDeselectAll() {
        List list = this.primGetSelectedEditParts();
        int i = 0;
        while (i < list.size()) {
            EditPart part = (EditPart)list.get(i);
            part.setSelected(0);
            ++i;
        }
        ArrayList result = new ArrayList(list);
        list.clear();
        return result;
    }

    public void forceSelect(EditPart editpart) {
        if (this.getSelectedEditParts().size() == 1 && this.getSelectedEditParts().get(0) == editpart) {
            return;
        }
        this.primDeselectAll();
        super.appendSelection(editpart);
    }

    public void addSelectionOverrider(ISelectionOverrider overrider) {
        if (overrider != null && !this.selectionOverriders.contains(overrider)) {
            this.selectionOverriders.add(overrider);
        }
    }

    public FigureCanvas getFigureCanvas() {
        return super.getFigureCanvas();
    }
}

