/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.java2d.figure;

import com.jaspersoft.studio.editor.java2d.J2DGraphics;
import com.jaspersoft.studio.editor.java2d.J2DGraphicsSource;
import com.jaspersoft.studio.model.MRoot;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.soutils.EnvironmentUtils;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class JSSScrollableThumbnail
extends Figure {
    private ScrollSynchronizer syncher;
    private SelectorFigure selector;
    private Viewport viewport;
    private IFigure sourceFigure;
    protected Dimension targetSize = new Dimension(0, 0);
    private ImageData cachedImage = null;
    private boolean deactivated = false;
    private boolean needRefresh = false;
    private MRoot rootNode = null;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JSSScrollableThumbnail.this.setNeedRefresh(true);
        }
    };
    private KeyListener keyListener = new KeyListener.Stub(){

        public void keyPressed(KeyEvent ke) {
            int moveX = JSSScrollableThumbnail.this.viewport.getClientArea().width / 4;
            int moveY = JSSScrollableThumbnail.this.viewport.getClientArea().height / 4;
            if (ke.keycode == 0x1000007 || (JSSScrollableThumbnail.this.isMirrored() ? ke.keycode == 0x1000004 : ke.keycode == 0x1000003)) {
                JSSScrollableThumbnail.this.viewport.setViewLocation(JSSScrollableThumbnail.this.viewport.getViewLocation().translate(-moveX, 0));
            } else if (ke.keycode == 0x1000008 || (JSSScrollableThumbnail.this.isMirrored() ? ke.keycode == 0x1000003 : ke.keycode == 0x1000004)) {
                JSSScrollableThumbnail.this.viewport.setViewLocation(JSSScrollableThumbnail.this.viewport.getViewLocation().translate(moveX, 0));
            } else if (ke.keycode == 0x1000001 || ke.keycode == 0x1000005) {
                JSSScrollableThumbnail.this.viewport.setViewLocation(JSSScrollableThumbnail.this.viewport.getViewLocation().translate(0, -moveY));
            } else if (ke.keycode == 0x1000002 || ke.keycode == 0x1000006) {
                JSSScrollableThumbnail.this.viewport.setViewLocation(JSSScrollableThumbnail.this.viewport.getViewLocation().translate(0, moveY));
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JSSScrollableThumbnail.this.reconfigureSelectorBounds();
        }
    };
    public Runnable refreshScheduler = new Runnable(){

        @Override
        public void run() {
            while (!JSSScrollableThumbnail.this.deactivated) {
                if (!JSSScrollableThumbnail.this.isNeedRefresh() || !JSSScrollableThumbnail.this.isVisible()) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).JSSScrollableThumbnail.this.cachedImage = JSSScrollableThumbnail.this.getThumbnailImage();
                        JSSScrollableThumbnail.this.repaint();
                    }
                });
                JSSScrollableThumbnail.this.setNeedRefresh(false);
            }
        }
    };
    private FigureListener figureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            JSSScrollableThumbnail.this.reconfigureSelectorBounds();
            JSSScrollableThumbnail.this.needRefresh = true;
        }
    };

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.selector.paint(graphics);
    }

    protected ImageData getThumbnailImage() {
        ImageData fixedImage;
        Rectangle e = this.getSourceRectangle();
        this.targetSize = this.getPreferredSize();
        Rectangle fullSize = new Rectangle(0, 0, e.width + Math.abs(e.x), e.height + Math.abs(e.y));
        PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
        ImageData data = new ImageData(fullSize.width, fullSize.height, 24, palette);
        Image fullImage = new Image((Device)Display.getCurrent(), data);
        GC fullImageGC = new GC((Drawable)fullImage);
        J2DGraphicsSource gs = new J2DGraphicsSource(fullImageGC);
        Graphics graphics = gs.getGraphics(fullSize);
        RGB backgroundColor = this.getBackgroundColor().getRGB();
        ((J2DGraphics)graphics).getGraphics2D().translate(-e.x, -e.y);
        ((J2DGraphics)graphics).getGraphics2D().setColor(new Color(backgroundColor.red, backgroundColor.green, backgroundColor.blue));
        ((J2DGraphics)graphics).getGraphics2D().fillRect(e.x, e.y, data.width, data.height);
        this.sourceFigure.paint(graphics);
        gs.flushGraphics(fullSize);
        Point thumbNailSize = this.calculateMaximumSize(fullSize.width, fullSize.height);
        int height = thumbNailSize.y;
        int width = thumbNailSize.x;
        int offset_x = e.x * width / fullSize.width;
        int offset_y = e.y * height / fullSize.height;
        this.targetSize.setSize(new Dimension(width + offset_x, height + offset_y));
        palette = new PaletteData(255, 65280, 0xFF0000);
        ImageData resizedImageData = new ImageData(width, height, 24, palette);
        Image resizedImage = new Image((Device)Display.getCurrent(), resizedImageData);
        GC resizedImageGC = new GC((Drawable)resizedImage);
        try {
            resizedImageGC.setAntialias(1);
            resizedImageGC.setInterpolation(2);
            resizedImageGC.drawImage(fullImage, 0, 0, fullImage.getBounds().width, fullImage.getBounds().height, 0, 0, width, height);
            resizedImageData = resizedImage.getImageData();
            fixedImage = this.fixColor(resizedImage.getImageData());
        }
        finally {
            resizedImageGC.dispose();
            resizedImage.dispose();
            fullImageGC.dispose();
            fullImage.dispose();
        }
        return fixedImage;
    }

    private Point calculateMaximumSize(int fullWidth, int fullHeight) {
        int height1 = this.targetSize.width * fullHeight / fullWidth;
        int width1 = this.targetSize.width;
        int height2 = this.targetSize.height;
        int width2 = this.targetSize.height * fullWidth / fullHeight;
        if (height1 > this.targetSize.height) {
            return new Point(width2, height2);
        }
        if (width2 > this.targetSize.width) {
            return new Point(width1, height1);
        }
        int area1 = height1 * width1;
        int area2 = height2 * width2;
        if (area1 > area2) {
            return new Point(width1, height1);
        }
        return new Point(width2, height2);
    }

    private ImageData fixColor(ImageData data) {
        if (EnvironmentUtils.IS_WINDOWS) {
            int i = 0;
            while (i < data.width) {
                int j = 0;
                while (j < data.height) {
                    int pixel = data.getPixel(i, j);
                    int newPixel = (pixel >> 16) + (pixel << 16) + (pixel & 0xFF00);
                    data.setPixel(i, j, newPixel);
                    ++j;
                }
                ++i;
            }
        }
        return data;
    }

    public JSSScrollableThumbnail(Viewport port, MRoot rootNode) {
        this.setViewport(port);
        this.initialize();
        this.addLayoutListener(new LayoutListener(){

            public void setConstraint(IFigure child, Object constraint) {
            }

            public void remove(IFigure child) {
            }

            public void postLayout(IFigure container) {
                JSSScrollableThumbnail.this.setNeedRefresh(true);
            }

            public boolean layout(IFigure container) {
                return false;
            }

            public void invalidate(IFigure container) {
            }
        });
        this.rootNode = rootNode;
        new Thread(this.refreshScheduler).start();
    }

    public void deactivate() {
        this.unhookViewport();
        this.unhookSelector();
        this.deactivated = true;
    }

    private double getViewportScaleX() {
        return (double)this.targetSize.width / (double)this.viewport.getContents().getBounds().width;
    }

    private double getViewportScaleY() {
        return (double)this.targetSize.height / (double)this.viewport.getContents().getBounds().height;
    }

    private void hookSelector() {
        this.syncher = new ScrollSynchronizer();
        this.selector.addMouseListener(this.syncher);
        this.selector.addMouseMotionListener((MouseMotionListener)this.syncher);
        this.selector.addKeyListener(this.keyListener);
        this.add((IFigure)this.selector);
    }

    private void hookViewport() {
        this.viewport.addPropertyChangeListener("viewLocation", this.propListener);
        this.viewport.addFigureListener(this.figureListener);
    }

    private void initialize() {
        this.selector = new SelectorFigure();
        this.selector.setFocusTraversable(true);
        this.add((IFigure)this.selector);
        this.hookSelector();
        ClickScrollerAndDragTransferrer transferrer = new ClickScrollerAndDragTransferrer();
        this.addMouseListener(transferrer);
        this.addMouseMotionListener((MouseMotionListener)transferrer);
    }

    private void reconfigureSelectorBounds() {
        Rectangle rect = new Rectangle();
        Point offset = this.viewport.getViewLocation();
        offset.x -= this.viewport.getHorizontalRangeModel().getMinimum();
        offset.y -= this.viewport.getVerticalRangeModel().getMinimum();
        rect.setLocation(offset);
        rect.setSize(this.viewport.getClientArea().getSize());
        rect.scale(this.getViewportScaleX(), this.getViewportScaleY());
        rect.translate(this.getClientArea().getLocation());
        this.selector.setViewportBounds(rect);
        this.selector.repaint();
    }

    public void setViewport(Viewport port) {
        this.viewport = port;
        this.hookViewport();
    }

    private void unhookSelector() {
        this.selector.removeKeyListener(this.keyListener);
        this.selector.removeMouseMotionListener((MouseMotionListener)this.syncher);
        this.selector.removeMouseListener(this.syncher);
        this.remove((IFigure)this.selector);
    }

    private void unhookViewport() {
        this.viewport.removePropertyChangeListener("viewLocation", this.propListener);
        this.viewport.removeFigureListener(this.figureListener);
    }

    protected Rectangle getSourceRectangle() {
        return this.sourceFigure.getBounds();
    }

    public void setSource(IFigure fig) {
        if (this.sourceFigure == fig) {
            return;
        }
        this.sourceFigure = fig;
        if (this.rootNode != null && this.rootNode.getChildren() != null && this.rootNode.getChildren().size() > 0) {
            this.rootNode.getChildren().get(0).getPropertyChangeSupport().removePropertyChangeListener(this.listener);
            this.rootNode.getChildren().get(0).getPropertyChangeSupport().addPropertyChangeListener(this.listener);
        }
        if (this.sourceFigure != null) {
            this.reconfigureSelectorBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNeedRefresh() {
        JSSScrollableThumbnail jSSScrollableThumbnail = this;
        synchronized (jSSScrollableThumbnail) {
            return this.needRefresh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNeedRefresh(boolean value) {
        JSSScrollableThumbnail jSSScrollableThumbnail = this;
        synchronized (jSSScrollableThumbnail) {
            this.needRefresh = value;
        }
    }

    private class ClickScrollerAndDragTransferrer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private boolean dragTransfer;

        private ClickScrollerAndDragTransferrer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.dragTransfer) {
                JSSScrollableThumbnail.this.syncher.mouseDragged(me);
            }
        }

        public void mousePressed(MouseEvent me) {
            if (!JSSScrollableThumbnail.this.getClientArea().contains(me.getLocation())) {
                return;
            }
            Dimension selectorCenter = JSSScrollableThumbnail.this.selector.getViewportBounds().getSize().scale(0.5);
            Point scrollPoint = me.getLocation().getTranslated(JSSScrollableThumbnail.this.getLocation().getNegated()).translate(selectorCenter.negate()).scale(1.0 / JSSScrollableThumbnail.this.getViewportScaleX(), 1.0 / JSSScrollableThumbnail.this.getViewportScaleY()).translate(JSSScrollableThumbnail.this.viewport.getHorizontalRangeModel().getMinimum(), JSSScrollableThumbnail.this.viewport.getVerticalRangeModel().getMinimum());
            JSSScrollableThumbnail.this.viewport.setViewLocation(scrollPoint);
            JSSScrollableThumbnail.this.syncher.mousePressed(me);
            this.dragTransfer = true;
        }

        public void mouseReleased(MouseEvent me) {
            JSSScrollableThumbnail.this.syncher.mouseReleased(me);
            this.dragTransfer = false;
        }
    }

    private class ScrollSynchronizer
    extends MouseMotionListener.Stub
    implements MouseListener {
        private Point startLocation;
        private Point viewLocation;

        private ScrollSynchronizer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.startLocation != null) {
                Dimension d = me.getLocation().getDifference(this.startLocation);
                d.scale(1.0 / JSSScrollableThumbnail.this.getViewportScaleX(), 1.0 / JSSScrollableThumbnail.this.getViewportScaleY());
                JSSScrollableThumbnail.this.viewport.setViewLocation(this.viewLocation.getTranslated(d));
                me.consume();
            }
        }

        public void mousePressed(MouseEvent me) {
            this.startLocation = me.getLocation();
            this.viewLocation = JSSScrollableThumbnail.this.viewport.getViewLocation();
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
        }
    }

    private class SelectorFigure
    extends Figure {
        private Rectangle viewPortBounds;

        private SelectorFigure() {
        }

        public void setViewportBounds(Rectangle rect) {
            this.viewPortBounds = rect;
        }

        public Rectangle getViewportBounds() {
            return this.viewPortBounds;
        }

        public void paintFigure(Graphics g) {
            if (JSSScrollableThumbnail.this.cachedImage == null) {
                JSSScrollableThumbnail.this.cachedImage = JSSScrollableThumbnail.this.getThumbnailImage();
            }
            Image imageToDraw = new Image((Device)Display.getCurrent(), JSSScrollableThumbnail.this.cachedImage);
            g.drawImage(imageToDraw, 0, 0);
            imageToDraw.dispose();
        }
    }
}

