/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout;

import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;

public class ChangeLayoutCommand
extends Command {
    private APropertyNode targetNode;
    private String newLayout;
    private String oldLayout;
    private List<Command> exectueAdditionalCommands;

    public ChangeLayoutCommand(APropertyNode targetNode, ILayout newLayout) {
        this.targetNode = targetNode;
        this.newLayout = newLayout.getClass().getName();
    }

    public void execute() {
        this.exectueAdditionalCommands = new ArrayList<Command>();
        JRPropertiesHolder nodePropertiesHolder = LayoutManager.getPropertyHolder(this.targetNode);
        if (nodePropertiesHolder != null && !ModelUtils.safeEquals(this.newLayout, this.oldLayout)) {
            Command deactivationCmd;
            Command activationCmd;
            JRPropertiesMap pmap = (JRPropertiesMap)this.targetNode.getPropertyValue("PROPERTY_MAP");
            pmap = (JRPropertiesMap)pmap.clone();
            this.oldLayout = pmap.getProperty("com.jaspersoft.studio.layout");
            pmap.setProperty("com.jaspersoft.studio.layout", this.newLayout);
            this.targetNode.setPropertyValue("PROPERTY_MAP", pmap);
            if (this.newLayout != null && (activationCmd = LayoutManager.getLayout(this.newLayout).activate(this.targetNode)) != null) {
                this.exectueAdditionalCommands.add(activationCmd);
            }
            if (this.oldLayout != null && (deactivationCmd = LayoutManager.getLayout(this.oldLayout).deactivate(this.targetNode)) != null) {
                this.exectueAdditionalCommands.add(deactivationCmd);
            }
            for (Command cmd : this.exectueAdditionalCommands) {
                cmd.execute();
            }
        }
    }

    public void undo() {
        JRPropertiesHolder nodePropertiesHolder = LayoutManager.getPropertyHolder(this.targetNode);
        if (nodePropertiesHolder != null && !ModelUtils.safeEquals(this.newLayout, this.oldLayout)) {
            JRPropertiesMap pmap = nodePropertiesHolder.getPropertiesMap();
            pmap.setProperty("com.jaspersoft.studio.layout", this.oldLayout);
            for (Command cmd : this.exectueAdditionalCommands) {
                cmd.undo();
            }
            this.targetNode.setPropertyValue("PROPERTY_MAP", pmap.clone());
        }
    }
}

