/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout.grid;

import com.jaspersoft.studio.editor.layout.AbstractLayout;
import com.jaspersoft.studio.editor.layout.ILayoutUIProvider;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.grid.GridBagLayoutUtil;
import com.jaspersoft.studio.editor.layout.grid.JSSGridBagUIProvider;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class JSSGridBagLayout
extends AbstractLayout {
    public static final String PROPERTY_X = "com.jaspersoft.layout.grid.x";
    public static final String PROPERTY_Y = "com.jaspersoft.layout.grid.y";
    public static final String PROPERTY_COLSPAN = "com.jaspersoft.layout.grid.colspan";
    public static final String PROPERTY_ROWSPAN = "com.jaspersoft.layout.grid.rowspan";
    public static final String PROPERTY_WEIGHT_COLUMN = "com.jaspersoft.layout.grid.weight.x";
    public static final String PROPERTY_WEIGHT_ROW = "com.jaspersoft.layout.grid.weight.y";
    public static final String PROPERTY_IS_FIXED = "com.jaspersoft.layout.grid.weight.fixed";

    @Override
    public boolean showAdditionalControlsOnChild(JRPropertiesMap elementProperties, JRPropertiesMap parentProperties) {
        return true;
    }

    @Override
    public ILayoutUIProvider getControlsProvider() {
        return new JSSGridBagUIProvider();
    }

    @Override
    public boolean allowChildBoundChange(ANode resizedNode, Rectangle oldBounds, Rectangle newBounds) {
        if (ModelUtils.safeEquals(oldBounds, newBounds)) {
            return true;
        }
        JRPropertiesHolder currentElement = LayoutManager.getPropertyHolder(resizedNode);
        if (currentElement != null) {
            String value = currentElement.getPropertiesMap().getProperty(PROPERTY_IS_FIXED);
            boolean isFixed = value != null ? Boolean.parseBoolean(value.toString()) : false;
            return isFixed;
        }
        return false;
    }

    @Override
    public Map<JRElement, Rectangle> layout(JasperDesign jd, JRElementGroup container, JRElement[] elements, Dimension c) {
        GridBagLayoutUtil layout = new GridBagLayoutUtil();
        Map<JRElement, Rectangle> result = layout.layoutContainer(c, elements);
        HashMap<JRElement, Rectangle> oldValues = new HashMap<JRElement, Rectangle>();
        for (Map.Entry<JRElement, Rectangle> entry : result.entrySet()) {
            JRDesignElement del = (JRDesignElement)entry.getKey();
            oldValues.put((JRElement)del, new Rectangle(del.getX(), del.getY(), del.getWidth(), del.getHeight()));
            Rectangle placement = entry.getValue();
            boolean relayoutChildren = del.getWidth() != placement.width || del.getHeight() != placement.height;
            del.setX(placement.x);
            del.setY(placement.y);
            del.setWidth(placement.width);
            del.setHeight(placement.height);
            if (!relayoutChildren) continue;
            LayoutManager.layout(jd, result, (JRElement)del);
        }
        return oldValues;
    }

    @Override
    public String getName() {
        return Messages.JSSGridBagLayout_layoutName;
    }

    @Override
    public String getToolTip() {
        return Messages.FreeLayout_tooltip;
    }

    @Override
    public String getIcon() {
        return "icons/layout-6.png";
    }

    @Override
    public Map<Object, Rectangle> getLayoutPosition(Object[] elements, int insertPosition, Dimension parentSize) {
        GridBagLayoutUtil layout = new GridBagLayoutUtil();
        ArrayList<JRElement> elementsToLayout = new ArrayList<JRElement>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof JRElement) {
                elementsToLayout.add((JRElement)obj);
            }
            ++n2;
        }
        Map<JRElement, Rectangle> result = layout.layoutContainer(parentSize, elementsToLayout.toArray(new JRElement[elementsToLayout.size()]));
        HashMap<Object, Rectangle> rawResult = new HashMap<Object, Rectangle>();
        rawResult.putAll(result);
        return rawResult;
    }
}

