/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.layout.grid;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.ILayoutUIProvider;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.SetLayoutProperty;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.property.section.AbstractSection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.jasperreports.engine.JRCommonElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class JSSGridBagUIProvider
implements ILayoutUIProvider {
    protected static final int MAX_ROW_NUMBER = 1000;
    protected static final int MAX_COL_NUMBER = 250;
    private SelectionListener comboSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            JSSGridBagUIProvider.this.updateElement();
        }
    };
    private VerifyListener weightVerify = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (e.text.isEmpty()) {
                return;
            }
            if (!e.text.matches("[0-9\\.]+")) {
                e.doit = false;
                return;
            }
            String currentText = ((Text)e.widget).getText();
            if (e.text.contains(".") && currentText.contains(".")) {
                e.doit = false;
                return;
            }
            try {
                String firstPart = currentText.substring(0, e.start);
                String secondPart = currentText.substring(e.end, currentText.length());
                double value = Double.parseDouble(String.valueOf(firstPart) + e.text + secondPart);
                if (value < 0.0) {
                    e.doit = false;
                    return;
                }
            }
            catch (Exception exception) {
                e.doit = false;
                return;
            }
        }
    };
    private VerifyListener positionVerify = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            if (e.text.isEmpty() && e.keyCode == 8) {
                return;
            }
            try {
                String currentText = ((Combo)e.widget).getText();
                String firstPart = currentText.substring(0, e.start);
                String secondPart = currentText.substring(e.end, currentText.length());
                String newText = String.valueOf(firstPart) + e.text + secondPart;
                if (!newText.trim().equals(Messages.JSSGridBagLayout_relativeString)) {
                    int maxNumber;
                    int value = Integer.parseInt(newText);
                    int n = maxNumber = e.widget == JSSGridBagUIProvider.this.columnPosition ? 250 : 1000;
                    if (value < 0 || value > maxNumber) {
                        e.doit = false;
                        return;
                    }
                }
            }
            catch (Exception exception) {
                e.doit = false;
                return;
            }
        }
    };
    private Listener spanVerify = new Listener(){

        public void handleEvent(Event e) {
            if (e.text.isEmpty()) {
                return;
            }
            try {
                Spinner spinner = (Spinner)e.widget;
                String currentText = spinner.getText();
                String firstPart = currentText.substring(0, e.start);
                String secondPart = currentText.substring(e.end, currentText.length());
                String newText = String.valueOf(firstPart) + e.text + secondPart;
                int value = Integer.parseInt(newText);
                if (value < 1 || value > spinner.getMaximum()) {
                    e.doit = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                e.doit = false;
            }
        }
    };
    Comparator<String> hintsComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int hint2;
            if (Messages.JSSGridBagLayout_relativeString.equals(o1)) {
                if (Messages.JSSGridBagLayout_relativeString.equals(o2)) {
                    return 0;
                }
                return -1;
            }
            if (Messages.JSSGridBagLayout_relativeString.equals(o2)) {
                if (Messages.JSSGridBagLayout_relativeString.equals(o1)) {
                    return 0;
                }
                return 1;
            }
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int hint1 = Integer.parseInt(o1);
            return hint1 < (hint2 = Integer.parseInt(o2)) ? -1 : (hint1 == hint2 ? 0 : 1);
        }
    };
    private Combo columnPosition;
    private Combo rowPosition;
    private Text columnWeight;
    private Text rowWeight;
    private Spinner rowSpan;
    private Spinner columnSpan;
    private ANode selectedElement;
    private AbstractSection section;
    private Combo fixedSizeCombo;
    private boolean modifyGuard = false;
    private ValidationModifyListener listener = new ValidationModifyListener();
    private List<String> rowHint = new ArrayList<String>(Arrays.asList(Messages.JSSGridBagLayout_relativeString, "0", "1", "2", "3", "4"));
    private List<String> colHint = new ArrayList<String>(Arrays.asList(Messages.JSSGridBagLayout_relativeString, "0", "1", "2", "3", "4"));

    protected void updateElement() {
        if (!this.modifyGuard) {
            this.modifyGuard = true;
            JSSCompoundCommand cmd = new JSSCompoundCommand(this.selectedElement);
            CommandStack cs = this.section.getEditDomain().getCommandStack();
            SetLayoutProperty setCommand = new SetLayoutProperty();
            for (APropertyNode node : this.section.getElements()) {
                JRPropertiesHolder currentElement = LayoutManager.getPropertyHolder(node);
                if (currentElement == null || !this.hasValueChanged(node)) continue;
                JRPropertiesMap clone = (JRPropertiesMap)currentElement.getPropertiesMap().clone();
                clone.setProperty("com.jaspersoft.layout.grid.x", String.valueOf(this.getComboValue(this.columnPosition)));
                clone.setProperty("com.jaspersoft.layout.grid.y", String.valueOf(this.getComboValue(this.rowPosition)));
                clone.setProperty("com.jaspersoft.layout.grid.weight.x", this.columnWeight.getText());
                clone.setProperty("com.jaspersoft.layout.grid.weight.y", this.rowWeight.getText());
                clone.setProperty("com.jaspersoft.layout.grid.rowspan", this.rowSpan.getText());
                clone.setProperty("com.jaspersoft.layout.grid.colspan", this.columnSpan.getText());
                clone.setProperty("com.jaspersoft.layout.grid.weight.fixed", String.valueOf(this.isFixedSize()));
                SetValueCommand setMapCommand = new SetValueCommand("Layout Settings");
                setMapCommand.setTarget(node);
                setMapCommand.setPropertyId("PROPERTY_MAP");
                setMapCommand.setPropertyValue(clone);
                setCommand.addSetValueCommand(setMapCommand);
            }
            if (!setCommand.isEmpty()) {
                setCommand.setLayoutCommand(this.creteRelayoutCommand());
                cmd.add(setCommand);
                cs.execute((Command)cmd);
            }
            this.modifyGuard = false;
        }
    }

    private void updateComboHints(Combo widget) {
        int index;
        List<String> hints = null;
        String text = this.getComboTextValue(widget);
        if (!text.trim().isEmpty() && (hints = widget == this.rowPosition ? this.rowHint : this.colHint) != null && (index = hints.indexOf(text)) == -1) {
            hints.add(text);
            Collections.sort(hints, this.hintsComparator);
            widget.removeSelectionListener(this.comboSelectionListener);
            widget.setItems(hints.toArray(new String[hints.size()]));
            int elementIndex = hints.indexOf(text);
            Point caretLocation = widget.getCaretLocation();
            widget.select(elementIndex);
            widget.setSelection(caretLocation);
            widget.addSelectionListener(this.comboSelectionListener);
        }
    }

    private boolean hasValueChanged(ANode element) {
        JRPropertiesHolder currentElement = LayoutManager.getPropertyHolder(element);
        if (currentElement != null) {
            int selectionIndex;
            String prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.x");
            String string = prop = prop != null ? prop.toString() : String.valueOf(-1);
            if (this.columnPosition.getText().trim().isEmpty()) {
                if (prop.equals(String.valueOf(-1))) {
                    this.columnPosition.select(0);
                    this.columnPosition.setText(this.columnPosition.getItem(0));
                } else {
                    this.columnPosition.setText(this.parsePosition(prop));
                }
            }
            if (!prop.equals(String.valueOf(this.getComboValue(this.columnPosition)))) {
                return true;
            }
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.y");
            String string2 = prop = prop != null ? prop.toString() : String.valueOf(-1);
            if (this.rowPosition.getText().trim().isEmpty()) {
                if (prop.equals(String.valueOf(-1))) {
                    this.rowPosition.select(0);
                    this.rowPosition.setText(this.columnPosition.getItem(0));
                } else {
                    this.rowPosition.setText(this.parsePosition(prop));
                }
            }
            if (!prop.equals(String.valueOf(this.getComboValue(this.rowPosition)))) {
                return true;
            }
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.x");
            prop = prop != null ? prop.toString() : String.valueOf(1.0);
            this.columnWeight.removeVerifyListener(this.weightVerify);
            if (this.columnWeight.getText().trim().isEmpty()) {
                this.columnWeight.setText(this.parseWeight(prop));
            } else {
                this.columnWeight.setText(this.parseWeight(this.columnWeight.getText()));
            }
            this.columnWeight.addVerifyListener(this.weightVerify);
            if (!prop.equals(this.columnWeight.getText())) {
                return true;
            }
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.y");
            prop = prop != null ? prop.toString() : String.valueOf(1.0);
            this.rowWeight.removeVerifyListener(this.weightVerify);
            if (this.rowWeight.getText().trim().isEmpty()) {
                this.rowWeight.setText(this.parseWeight(prop));
            } else {
                this.rowWeight.setText(this.parseWeight(this.rowWeight.getText()));
            }
            this.rowWeight.addVerifyListener(this.weightVerify);
            if (!prop.equals(this.rowWeight.getText())) {
                return true;
            }
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.rowspan");
            String string3 = prop = prop != null ? prop.toString() : String.valueOf(1);
            if (!prop.equals(this.rowSpan.getText())) {
                return true;
            }
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.colspan");
            String string4 = prop = prop != null ? prop.toString() : String.valueOf(1);
            if (!prop.equals(this.columnSpan.getText())) {
                return true;
            }
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.fixed");
            boolean value = prop != null ? Boolean.parseBoolean(prop.toString()) : false;
            int n = selectionIndex = value ? 1 : 0;
            if (this.fixedSizeCombo.getSelectionIndex() != selectionIndex) {
                return true;
            }
        }
        return false;
    }

    protected LayoutCommand creteRelayoutCommand() {
        ANode parent = this.selectedElement.getParent();
        Object jrElement = parent.getValue();
        JRElementGroup jrGroup = null;
        if (parent instanceof IGroupElement) {
            jrGroup = ((IGroupElement)((Object)parent)).getJRElementGroup();
        } else if (parent.getValue() instanceof JRElementGroup) {
            jrGroup = (JRElementGroup)parent.getValue();
        }
        Dimension d = new Dimension();
        if (parent instanceof IGraphicElementContainer) {
            d = LayoutManager.getPaddedSize((IGraphicElementContainer)((Object)parent));
        }
        if (jrElement instanceof JRCommonElement) {
            d = LayoutManager.getPaddedSize((JRCommonElement)jrElement);
        } else if (jrElement instanceof JRDesignBand) {
            JasperDesign jDesign = parent.getJasperDesign();
            int w = jDesign.getPageWidth() - jDesign.getLeftMargin() - jDesign.getRightMargin();
            d.setSize(new Dimension(w, ((JRDesignBand)jrElement).getHeight()));
        }
        JRPropertiesMap pholder = LayoutManager.getPropertyMap(parent);
        if (pholder != null && jrGroup != null) {
            String str = pholder.getProperty("com.jaspersoft.studio.layout");
            if (str == null) {
                str = FreeLayout.class.getName();
            }
            ILayout parentLayout = LayoutManager.getLayout(str);
            return new LayoutCommand(parent.getJasperDesign(), jrGroup, parentLayout, d);
        }
        return null;
    }

    private int getComboValue(Combo widget) {
        if (widget.getText().trim().equalsIgnoreCase(Messages.JSSGridBagLayout_relativeString)) {
            return -1;
        }
        try {
            int value = Integer.parseInt(widget.getText());
            return value;
        }
        catch (Exception exception) {
            widget.setText(Messages.JSSGridBagLayout_relativeString);
            return -1;
        }
    }

    private String getComboTextValue(Combo widget) {
        if (widget.getText().trim().equalsIgnoreCase(Messages.JSSGridBagLayout_relativeString)) {
            return Messages.JSSGridBagLayout_relativeString;
        }
        try {
            int value = Integer.parseInt(widget.getText());
            return String.valueOf(value);
        }
        catch (Exception exception) {
            widget.setText(Messages.JSSGridBagLayout_relativeString);
            return Messages.JSSGridBagLayout_relativeString;
        }
    }

    protected void refreshWeightWidgets() {
        this.columnWeight.setEnabled(!this.isFixedSize());
        this.rowWeight.setEnabled(!this.isFixedSize());
    }

    protected boolean isFixedSize() {
        return this.fixedSizeCombo.getSelectionIndex() == 1;
    }

    @Override
    public void createControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        container.setLayoutData((Object)new GridData(768));
        Label rowPositionLabel = new Label(container, 0);
        rowPositionLabel.setText(Messages.JSSGridBagLayout_rowLabel);
        String rowTooltip = MessageFormat.format(Messages.JSSGridBagUIProvider_rowPositionTooltip, String.valueOf(1000));
        rowPositionLabel.setToolTipText(rowTooltip);
        this.rowPosition = new Combo(container, 2048);
        this.rowPosition.setItems(this.rowHint.toArray(new String[this.rowHint.size()]));
        this.rowPosition.setLayoutData((Object)new GridData(768));
        this.rowPosition.addSelectionListener(this.comboSelectionListener);
        this.rowPosition.addKeyListener((KeyListener)this.listener);
        this.rowPosition.addVerifyListener(this.positionVerify);
        this.rowPosition.addFocusListener((FocusListener)this.listener);
        this.rowPosition.setToolTipText(rowTooltip);
        Label columnPositionLabel = new Label(container, 0);
        columnPositionLabel.setText(Messages.JSSGridBagLayout_columnLabel);
        String columnTooltip = MessageFormat.format(Messages.JSSGridBagUIProvider_columnPositionToolTip, String.valueOf(250));
        columnPositionLabel.setToolTipText(columnTooltip);
        this.columnPosition = new Combo(container, 2048);
        this.columnPosition.setItems(this.colHint.toArray(new String[this.colHint.size()]));
        this.columnPosition.setLayoutData((Object)new GridData(768));
        this.columnPosition.addSelectionListener(this.comboSelectionListener);
        this.columnPosition.addKeyListener((KeyListener)this.listener);
        this.columnPosition.addVerifyListener(this.positionVerify);
        this.columnPosition.addFocusListener((FocusListener)this.listener);
        this.columnPosition.setToolTipText(columnTooltip);
        Label rowSpanLabel = new Label(container, 0);
        rowSpanLabel.setText(Messages.JSSGridBagLayout_rowSpanLabel);
        rowSpanLabel.setToolTipText(Messages.JSSGridBagUIProvider_rowSpanToolTip);
        this.rowSpan = new Spinner(container, 2048);
        this.rowSpan.setMinimum(1);
        this.rowSpan.setMaximum(1000);
        this.rowSpan.setLayoutData((Object)new GridData(768));
        this.rowSpan.addKeyListener((KeyListener)this.listener);
        this.rowSpan.addListener(25, this.spanVerify);
        this.rowSpan.addFocusListener((FocusListener)this.listener);
        this.rowSpan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSSGridBagUIProvider.this.updateElement();
            }
        });
        this.rowSpan.setToolTipText(Messages.JSSGridBagUIProvider_rowSpanToolTip);
        Label columnSpanLabel = new Label(container, 0);
        columnSpanLabel.setText(Messages.JSSGridBagLayout_columnSpanLabel);
        columnSpanLabel.setToolTipText(Messages.JSSGridBagUIProvider_columnSpanToolTip);
        this.columnSpan = new Spinner(container, 2048);
        this.columnSpan.setMinimum(1);
        this.columnSpan.setMaximum(250);
        this.columnSpan.setLayoutData((Object)new GridData(768));
        this.columnSpan.addKeyListener((KeyListener)this.listener);
        this.columnSpan.addListener(25, this.spanVerify);
        this.columnSpan.addFocusListener((FocusListener)this.listener);
        this.columnSpan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSSGridBagUIProvider.this.updateElement();
            }
        });
        this.columnSpan.setToolTipText(Messages.JSSGridBagUIProvider_columnSpanToolTip);
        Label fixedSizeLabel = new Label(container, 0);
        fixedSizeLabel.setText(Messages.JSSGridBagLayout_labelFixedSize);
        fixedSizeLabel.setToolTipText(Messages.JSSGridBagUIProvider_fixedSizeTooltip);
        this.fixedSizeCombo = new Combo(container, 8);
        this.fixedSizeCombo.setItems(new String[]{Messages.SP3Boolean_False_Value, Messages.SP3Boolean_True_Value});
        GridData fixedComboData = new GridData();
        fixedComboData.horizontalSpan = 3;
        this.fixedSizeCombo.setLayoutData((Object)fixedComboData);
        this.fixedSizeCombo.select(0);
        this.fixedSizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSSGridBagUIProvider.this.refreshWeightWidgets();
                JSSGridBagUIProvider.this.updateElement();
            }
        });
        this.fixedSizeCombo.setToolTipText(Messages.JSSGridBagUIProvider_fixedSizeTooltip);
        Label rowWeightLabel = new Label(container, 0);
        rowWeightLabel.setText(Messages.JSSGridBagLayout_rowWeightLabel);
        rowWeightLabel.setToolTipText(Messages.JSSGridBagUIProvider_rowWeightTooltip);
        this.rowWeight = new Text(container, 2048);
        this.rowWeight.setLayoutData((Object)new GridData(768));
        this.rowWeight.addKeyListener((KeyListener)this.listener);
        this.rowWeight.addFocusListener((FocusListener)this.listener);
        this.rowWeight.addVerifyListener(this.weightVerify);
        this.rowWeight.setToolTipText(Messages.JSSGridBagUIProvider_rowWeightTooltip);
        Label columnWeightLabel = new Label(container, 0);
        columnWeightLabel.setText(Messages.JSSGridBagLayout_columnWeightLabel);
        columnWeightLabel.setToolTipText(Messages.JSSGridBagUIProvider_columnWeightTooltip);
        this.columnWeight = new Text(container, 2048);
        this.columnWeight.setLayoutData((Object)new GridData(768));
        this.columnWeight.addKeyListener((KeyListener)this.listener);
        this.columnWeight.addFocusListener((FocusListener)this.listener);
        this.columnWeight.addVerifyListener(this.weightVerify);
        this.columnWeight.setToolTipText(Messages.JSSGridBagUIProvider_columnWeightTooltip);
    }

    private String parseWeight(Object prop) {
        if (prop != null) {
            String value = prop.toString().trim();
            try {
                double result = Double.parseDouble(value);
                if (result >= 0.0) {
                    if (value.endsWith(".")) {
                        value = String.valueOf(value) + "0";
                    } else if (!value.contains(".")) {
                        value = String.valueOf(value) + ".0";
                    }
                    return value;
                }
            }
            catch (Exception exception) {}
        }
        return "1.0";
    }

    private Integer parseSpan(Object prop) {
        if (prop != null) {
            String value = prop.toString().trim();
            try {
                int result = Integer.parseInt(value);
                if (result >= 1) {
                    return result;
                }
            }
            catch (Exception exception) {}
        }
        return 1;
    }

    private String parsePosition(Object prop) {
        String value;
        if (prop != null && !(value = prop.toString().trim()).equals(Messages.JSSGridBagLayout_relativeString)) {
            try {
                int result = Integer.parseInt(value);
                if (result >= 0) {
                    return String.valueOf(result);
                }
            }
            catch (Exception exception) {}
        }
        return Messages.JSSGridBagLayout_relativeString;
    }

    @Override
    public void setData(ANode selectedElement, AbstractSection section) {
        this.selectedElement = selectedElement;
        this.section = section;
        JRPropertiesHolder currentElement = LayoutManager.getPropertyHolder(selectedElement);
        if (currentElement != null) {
            this.modifyGuard = true;
            this.columnPosition.removeVerifyListener(this.positionVerify);
            String prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.x");
            String string = prop = prop != null ? prop.toString() : String.valueOf(-1);
            if (prop.equals(String.valueOf(-1))) {
                this.columnPosition.select(0);
                this.columnPosition.setText(this.columnPosition.getItem(0));
            } else {
                this.columnPosition.setText(this.parsePosition(prop));
            }
            this.columnPosition.addVerifyListener(this.positionVerify);
            this.rowPosition.removeVerifyListener(this.positionVerify);
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.y");
            String string2 = prop = prop != null ? prop.toString() : String.valueOf(-1);
            if (prop.equals(String.valueOf(-1))) {
                this.rowPosition.select(0);
                this.rowPosition.setText(this.rowPosition.getItem(0));
            } else {
                this.rowPosition.setText(this.parsePosition(prop));
            }
            this.rowPosition.addVerifyListener(this.positionVerify);
            this.columnWeight.removeVerifyListener(this.weightVerify);
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.x");
            this.columnWeight.setText(this.parseWeight(prop));
            this.columnWeight.addVerifyListener(this.weightVerify);
            this.rowWeight.removeVerifyListener(this.weightVerify);
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.y");
            this.rowWeight.setText(this.parseWeight(prop));
            this.rowWeight.addVerifyListener(this.weightVerify);
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.rowspan");
            this.rowSpan.setSelection(this.parseSpan(prop).intValue());
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.colspan");
            this.columnSpan.setSelection(this.parseSpan(prop).intValue());
            prop = currentElement.getPropertiesMap().getProperty("com.jaspersoft.layout.grid.weight.fixed");
            boolean value = prop != null ? Boolean.parseBoolean(prop.toString()) : false;
            this.fixedSizeCombo.select(value ? 1 : 0);
            this.refreshWeightWidgets();
            this.modifyGuard = false;
        }
    }

    @Override
    public void createLayoutControls(Composite parent) {
    }

    private class ValidationModifyListener
    extends KeyAdapter
    implements FocusListener {
        private ValidationModifyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 13) {
                if (e.widget == JSSGridBagUIProvider.this.columnPosition || e.widget == JSSGridBagUIProvider.this.rowPosition) {
                    JSSGridBagUIProvider.this.updateComboHints((Combo)e.widget);
                }
                JSSGridBagUIProvider.this.updateElement();
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (e.widget == JSSGridBagUIProvider.this.columnPosition || e.widget == JSSGridBagUIProvider.this.rowPosition) {
                JSSGridBagUIProvider.this.updateComboHints((Combo)e.widget);
            }
            JSSGridBagUIProvider.this.updateElement();
        }
    }
}

