/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.callout.MCallout;
import com.jaspersoft.studio.callout.command.CreateCalloutCommand;
import com.jaspersoft.studio.callout.command.DeleteCalloutCommand;
import com.jaspersoft.studio.callout.pin.MPin;
import com.jaspersoft.studio.callout.pin.command.DeletePinCommand;
import com.jaspersoft.studio.editor.expression.EditElementExpressionCommand;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.outline.actions.field.ShowFieldsTreeAction;
import com.jaspersoft.studio.editor.outline.actions.field.SortFieldsAction;
import com.jaspersoft.studio.editor.outline.part.ContainerTreeEditPart;
import com.jaspersoft.studio.editor.outline.part.DatasetElementsTreeEditPart;
import com.jaspersoft.studio.editor.outline.part.NotDragableContainerTreeEditPart;
import com.jaspersoft.studio.editor.outline.part.NotDragableTreeEditPart;
import com.jaspersoft.studio.editor.outline.part.OpenableContainerTreeEditPart;
import com.jaspersoft.studio.editor.outline.part.OpenableNotDraggableContainerTreeEditPart;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.editor.style.command.CreateStyleCommand;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.IDragable;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MElementGroup;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import com.jaspersoft.studio.model.band.command.CreateBandCommand;
import com.jaspersoft.studio.model.band.command.CreateBandGroupFooterCommand;
import com.jaspersoft.studio.model.band.command.CreateBandGroupHeaderCommand;
import com.jaspersoft.studio.model.band.command.DeleteBandCommand;
import com.jaspersoft.studio.model.band.command.DeleteBandDetailCommand;
import com.jaspersoft.studio.model.band.command.DeleteBandGroupFooterCommand;
import com.jaspersoft.studio.model.band.command.DeleteBandGroupHeaderCommand;
import com.jaspersoft.studio.model.band.command.ReorderBandCommandByIndex;
import com.jaspersoft.studio.model.command.CreateE4ObjectCommand;
import com.jaspersoft.studio.model.command.CreateElementCommand;
import com.jaspersoft.studio.model.command.CreateElementGroupCommand;
import com.jaspersoft.studio.model.command.CreateFieldInEditorCommand;
import com.jaspersoft.studio.model.command.DeleteElementCommand;
import com.jaspersoft.studio.model.command.DeleteElementGroupCommand;
import com.jaspersoft.studio.model.command.NoActionCommand;
import com.jaspersoft.studio.model.command.OrphanElementCommand;
import com.jaspersoft.studio.model.command.OrphanElementGroupCommand;
import com.jaspersoft.studio.model.command.ReorderElementCommand;
import com.jaspersoft.studio.model.command.ReorderElementGroupCommand;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.dataset.command.CreateDatasetCommand;
import com.jaspersoft.studio.model.dataset.command.DeleteDatasetCommand;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.field.MFieldsContainer;
import com.jaspersoft.studio.model.field.command.CreateFieldCommand;
import com.jaspersoft.studio.model.field.command.CreateFieldsContainerCommand;
import com.jaspersoft.studio.model.field.command.DeleteFieldCommand;
import com.jaspersoft.studio.model.field.command.DeleteFieldsContainerCommand;
import com.jaspersoft.studio.model.field.command.DoNothingCommand;
import com.jaspersoft.studio.model.field.command.ReorderFieldCommand;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.group.MGroup;
import com.jaspersoft.studio.model.group.MGroups;
import com.jaspersoft.studio.model.group.command.CreateGroupCommand;
import com.jaspersoft.studio.model.group.command.CreateMainGroupCommand;
import com.jaspersoft.studio.model.group.command.DeleteGroupCommand;
import com.jaspersoft.studio.model.group.command.ReorderGroupCommand;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.image.command.CreateImageCommand;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.parameter.command.CreateParameterCommand;
import com.jaspersoft.studio.model.parameter.command.DeleteParameterCommand;
import com.jaspersoft.studio.model.parameter.command.ReorderParameterCommand;
import com.jaspersoft.studio.model.scriptlet.MScriptlet;
import com.jaspersoft.studio.model.scriptlet.MScriptlets;
import com.jaspersoft.studio.model.scriptlet.MSystemScriptlet;
import com.jaspersoft.studio.model.scriptlet.command.CreateScriptletCommand;
import com.jaspersoft.studio.model.scriptlet.command.DeleteScriptletCommand;
import com.jaspersoft.studio.model.scriptlet.command.ReorderScriptletCommand;
import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.sortfield.MSortFields;
import com.jaspersoft.studio.model.sortfield.command.CreateSortFieldCommand;
import com.jaspersoft.studio.model.sortfield.command.DeleteSortFieldCommand;
import com.jaspersoft.studio.model.sortfield.command.ReorderSortFieldCommand;
import com.jaspersoft.studio.model.style.MConditionalStyle;
import com.jaspersoft.studio.model.style.MStyle;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.style.MStylesTemplate;
import com.jaspersoft.studio.model.style.command.CreateConditionalStyleCommand;
import com.jaspersoft.studio.model.style.command.CreateStyleTemplateCommand;
import com.jaspersoft.studio.model.style.command.DeleteConditionalStyleCommand;
import com.jaspersoft.studio.model.style.command.DeleteStyleCommand;
import com.jaspersoft.studio.model.style.command.DeleteStyleTemplateCommand;
import com.jaspersoft.studio.model.style.command.OrphanConditionalStyleCommand;
import com.jaspersoft.studio.model.style.command.ReorderConditionalStyleCommand;
import com.jaspersoft.studio.model.style.command.ReorderStyleCommand;
import com.jaspersoft.studio.model.style.command.ReorderStyleTemplateCommand;
import com.jaspersoft.studio.model.subreport.MSubreport;
import com.jaspersoft.studio.model.subreport.command.CreateSubreportCommand;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.model.textfield.MPageXofY;
import com.jaspersoft.studio.model.textfield.MPercentage;
import com.jaspersoft.studio.model.textfield.command.CreatePageXofYCommand;
import com.jaspersoft.studio.model.textfield.command.CreatePercentageCommand;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.model.variable.MVariableSystem;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.model.variable.command.CreateVariableCommand;
import com.jaspersoft.studio.model.variable.command.DeleteVariableCommand;
import com.jaspersoft.studio.model.variable.command.ReorderVariableCommand;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.views.properties.IPropertySource;

public class OutlineTreeEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart context, Object model) {
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        Object editPart = m.createTreeEditPart(context, model);
        if (editPart == null) {
            if (model instanceof MCallout || model instanceof MPin) {
                return null;
            }
            editPart = model instanceof IDragable ? (model instanceof IContainerEditPart ? new ContainerTreeEditPart() : (model instanceof MTextField ? this.createTextFieldTreeEditPart() : (model instanceof MSubreport ? new OpenableContainerTreeEditPart() : (model instanceof MImage ? new OpenableContainerTreeEditPart() : (model instanceof MGraphicElement ? new ContainerTreeEditPart() : (model instanceof MField || model instanceof MParameter || model instanceof MVariable ? new DatasetElementsTreeEditPart() : new TreeEditPart())))))) : (model instanceof MStyleTemplate ? new OpenableNotDraggableContainerTreeEditPart() : (model instanceof IContainerEditPart ? new NotDragableContainerTreeEditPart() : (model instanceof MGraphicElement ? new NotDragableContainerTreeEditPart() : new NotDragableTreeEditPart())));
        }
        if (editPart != null) {
            editPart.setModel(model);
        }
        return editPart;
    }

    protected EditPart createTextFieldTreeEditPart() {
        return new OpenableContainerTreeEditPart(){

            @Override
            public void performRequest(Request req) {
                if ("open".equals(req.getType())) {
                    EditElementExpressionCommand cmd = null;
                    MTextField textfield = (MTextField)this.getModel();
                    cmd = new EditElementExpressionCommand(textfield, "expression"){

                        @Override
                        public boolean canExecute() {
                            return super.canExecute() && this.showDialog() == 0;
                        }
                    };
                    this.getViewer().getEditDomain().getCommandStack().execute((Command)cmd);
                }
            }

            @Override
            public boolean understandsRequest(Request req) {
                return "open".equals(req.getType());
            }
        };
    }

    public static Command getDeleteCommand(ANode parent, ANode child) {
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        Command c = m.getDeleteCommand(parent, child);
        if (c != null) {
            return c;
        }
        if (child instanceof MCallout) {
            return new DeleteCalloutCommand(parent, (MCallout)child);
        }
        if (child instanceof MPin) {
            return new DeletePinCommand((MCallout)child.getParent(), (MPin)child);
        }
        if (child instanceof MGraphicElement && !(parent instanceof MPage)) {
            if (child.getValue() != null) {
                return new DeleteElementCommand((MGraphicElement)child);
            }
        } else {
            if (child instanceof MElementGroup) {
                return new DeleteElementGroupCommand(parent, (MElementGroup)child);
            }
            if (child instanceof MConditionalStyle) {
                if (parent instanceof MStyle && !(parent.getParent() instanceof MStyleTemplate)) {
                    return new DeleteConditionalStyleCommand((MStyle)parent, (MConditionalStyle)child);
                }
            } else if (child instanceof MStyleTemplate) {
                if (parent instanceof MStyles) {
                    return new DeleteStyleTemplateCommand((MStyles)parent, (MStyleTemplate)child);
                }
            } else if (child instanceof MStyle) {
                if (parent instanceof MStyles) {
                    return new DeleteStyleCommand((MStyles)parent, (JRDesignStyle)child.getValue());
                }
            } else if (child instanceof MParameter) {
                JRDesignParameter p = (JRDesignParameter)child.getValue();
                if (!p.isSystemDefined()) {
                    MParameter srcNode = (MParameter)child;
                    JasperReportsConfiguration jConfig = srcNode.getJasperConfiguration();
                    return new DeleteParameterCommand(jConfig, (JRDesignDataset)parent.getValue(), (JRParameter)srcNode.getValue(), false);
                }
            } else {
                if (child instanceof MField) {
                    MField srcNode = (MField)child;
                    JasperReportsConfiguration jConfig = srcNode.getJasperConfiguration();
                    return new DeleteFieldCommand(jConfig, (JRDesignDataset)parent.getValue(), srcNode.getValue(), false);
                }
                if (child instanceof MFieldsContainer) {
                    MFieldsContainer srcNode = (MFieldsContainer)child;
                    JasperReportsConfiguration jConfig = srcNode.getJasperConfiguration();
                    return new DeleteFieldsContainerCommand(jConfig, (JRDesignDataset)parent.getValue(), srcNode.getKey(), parent, 0);
                }
                if (child instanceof MSortField) {
                    return new DeleteSortFieldCommand((MSortFields)parent, (MSortField)child);
                }
                if (child instanceof MGroup) {
                    return new DeleteGroupCommand((MGroups)parent, (MGroup)child);
                }
                if (child instanceof MVariable) {
                    JRDesignVariable p = (JRDesignVariable)child.getValue();
                    if (!p.isSystemDefined()) {
                        MVariable srcNode = (MVariable)child;
                        JasperReportsConfiguration jConfig = srcNode.getJasperConfiguration();
                        return new DeleteVariableCommand(jConfig, (JRDesignDataset)parent.getValue(), srcNode.getValue(), false);
                    }
                } else {
                    if (child instanceof MScriptlet) {
                        return new DeleteScriptletCommand((MScriptlets)parent, (MScriptlet)child);
                    }
                    if (child instanceof MDataset && parent instanceof MReport) {
                        return new DeleteDatasetCommand((MReport)parent, (MDataset)child);
                    }
                    if (child instanceof MBand && child.getValue() != null) {
                        if (child instanceof MBandGroupHeader) {
                            return new DeleteBandGroupHeaderCommand((MReport)parent, (MBandGroupHeader)child);
                        }
                        if (child instanceof MBandGroupFooter) {
                            return new DeleteBandGroupFooterCommand((MReport)parent, (MBandGroupFooter)child);
                        }
                        if (((MBand)child).getBandType().equals((Object)BandTypeEnum.DETAIL)) {
                            return new DeleteBandDetailCommand(parent, (MBand)child);
                        }
                        return new DeleteBandCommand(parent, (MBand)child);
                    }
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Command getReorderCommand(ANode child, ANode parent, int newIndex) {
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        Command c = m.getReorderCommand(child, parent, newIndex);
        if (c != null) {
            return c;
        }
        if (child instanceof MBand) {
            ANode n;
            int i;
            JRDesignGroup g;
            int minIndex = 0;
            int maxIndex = 0;
            List<INode> p = child.getParent().getChildren();
            if (child instanceof MBandGroupFooter) {
                g = ((MBandGroupFooter)child).getJrGroup();
                i = 0;
                while (i < p.size()) {
                    n = (ANode)p.get(i);
                    if (n instanceof MBandGroupFooter && ((MBandGroupFooter)n).getJrGroup().equals(g)) {
                        if (minIndex == 0) {
                            minIndex = i;
                        }
                        maxIndex = i;
                    }
                    ++i;
                }
                if (newIndex >= minIndex && newIndex <= maxIndex) {
                    return new ReorderBandCommandByIndex((MBandGroupFooter)child, newIndex - minIndex);
                }
            }
            if (child instanceof MBandGroupHeader) {
                g = ((MBandGroupHeader)child).getJrGroup();
                i = 0;
                while (i < p.size()) {
                    n = (ANode)p.get(i);
                    if (n instanceof MBandGroupHeader && ((MBandGroupHeader)n).getJrGroup().equals(g)) {
                        if (minIndex == 0) {
                            minIndex = i;
                        }
                        maxIndex = i;
                    }
                    ++i;
                }
                if (newIndex >= minIndex && newIndex <= maxIndex) {
                    return new ReorderBandCommandByIndex((MBandGroupHeader)child, newIndex - minIndex);
                }
            }
            if (!(child instanceof MBand) || !((MBand)child).getBandType().equals((Object)BandTypeEnum.DETAIL)) return null;
            int i2 = 0;
            while (i2 < p.size()) {
                ANode n2 = (ANode)p.get(i2);
                if (n2 instanceof MBand && ((MBand)n2).getBandType().equals((Object)BandTypeEnum.DETAIL)) {
                    if (minIndex == 0) {
                        minIndex = i2;
                    }
                    maxIndex = i2;
                }
                ++i2;
            }
            if (newIndex < minIndex || newIndex > maxIndex) return null;
            return new ReorderBandCommandByIndex((MBand)child, (MReport)parent, newIndex - minIndex);
        }
        if (child instanceof MGraphicElement && !(parent instanceof MPage)) {
            return new ReorderElementCommand((MGraphicElement)child, parent, newIndex);
        }
        if (child instanceof MElementGroup) {
            return new ReorderElementGroupCommand((MElementGroup)child, parent, newIndex);
        }
        if (child instanceof MConditionalStyle) {
            if (!(parent instanceof MStyle)) return null;
            return new ReorderConditionalStyleCommand((MConditionalStyle)child, (MStyle)parent, newIndex);
        }
        if (child instanceof MStyle) {
            if (!(parent instanceof MStyles)) return null;
            JRReportTemplate[] templates = child.getJasperDesign().getTemplates();
            if (templates == null || templates.length <= 0) return new ReorderStyleCommand((MStyle)child, (MStyles)parent, newIndex);
            if (newIndex <= templates.length - 1) return null;
            return new ReorderStyleCommand((MStyle)child, (MStyles)parent, newIndex -= templates.length);
        }
        if (child instanceof MStyleTemplate) {
            JRReportTemplate[] templates;
            if (!(parent instanceof MStyles) || (templates = child.getJasperDesign().getTemplates()) == null || templates.length <= 0 || newIndex >= templates.length - 1) return null;
            return new ReorderStyleTemplateCommand((MStyleTemplate)child, (MStyles)parent, newIndex);
        }
        if (child instanceof MParameter) {
            JRDesignParameter p;
            if (!(parent instanceof MParameters) || (p = (JRDesignParameter)child.getValue()).isSystemDefined()) return null;
            return new ReorderParameterCommand((MParameter)child, (MParameters)parent, newIndex);
        }
        if (child instanceof MFieldsContainer) {
            if (parent instanceof MField) {
                parent = parent.getParent();
            }
            if (!(parent instanceof MFields) || parent == child.getParent()) return null;
            return new DoNothingCommand();
        }
        if (child instanceof MField) {
            if (ShowFieldsTreeAction.isFieldsTree(parent.getJasperConfiguration())) {
                if (parent instanceof MField) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof MFields) || parent == child.getParent()) return null;
                return new DoNothingCommand();
            }
            if (!(parent instanceof MFields)) return null;
            return new ReorderFieldCommand((MField)child, (MFields)parent, newIndex);
        }
        if (child instanceof MSortField) {
            if (!(parent instanceof MSortFields)) return null;
            return new ReorderSortFieldCommand((MSortField)child, (MSortFields)parent, newIndex);
        }
        if (child instanceof MGroup) {
            if (!(parent instanceof MGroups)) return null;
            return new ReorderGroupCommand((MGroup)child, (MGroups)parent, newIndex);
        }
        if (child instanceof MVariable) {
            JRDesignVariable p;
            if (!(parent instanceof MVariables) || (p = (JRDesignVariable)child.getValue()).isSystemDefined()) return null;
            return new ReorderVariableCommand((MVariable)child, (MVariables)parent, newIndex);
        }
        if (!(child instanceof MScriptlet) || !(parent instanceof MScriptlets)) return null;
        int system = -1;
        for (INode n : parent.getChildren()) {
            if (!(n instanceof MSystemScriptlet)) return new ReorderScriptletCommand((MScriptlet)child, (MScriptlets)parent, newIndex -= system + 1);
            ++system;
        }
        return new ReorderScriptletCommand((MScriptlet)child, (MScriptlets)parent, newIndex -= system + 1);
    }

    public static Command getCreateCommand(ANode parent, ANode child, Rectangle location, int newIndex) {
        return OutlineTreeEditPartFactory.getCreateCommand(parent, child, location, newIndex, null, false);
    }

    public static Command getCreateCommand(ANode parent, ANode child, Rectangle location, int newIndex, Request request, boolean typeAdd) {
        JRDesignParameter p;
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        Command c = m.getCreateCommand(parent, child, location, newIndex);
        if (c != null) {
            return c;
        }
        if (child instanceof MCallout) {
            return new CreateCalloutCommand(parent, (MCallout)child, location, newIndex);
        }
        if (child instanceof MFieldsContainer) {
            if (typeAdd && ShowFieldsTreeAction.isFieldsTree(parent.getJasperConfiguration())) {
                if (parent instanceof MField) {
                    parent = parent.getParent();
                }
                if (parent instanceof MFields) {
                    ArrayList<ANode> lst = new ArrayList<ANode>();
                    lst.add((MFields)child);
                    return new CreateFieldsContainerCommand((MFields)parent, lst, typeAdd);
                }
            } else {
                if (parent instanceof MField) {
                    ArrayList<ANode> lst = new ArrayList<ANode>();
                    lst.add((MField)parent);
                    return new CreateFieldsContainerCommand(lst);
                }
                if (parent instanceof MFieldsContainer) {
                    ArrayList<ANode> lst = new ArrayList<ANode>();
                    lst.add((MFieldsContainer)parent);
                    return new CreateFieldsContainerCommand(lst);
                }
            }
            if (child.getValue() != null && (parent instanceof MGraphicElement || parent instanceof MReport || parent instanceof MBand || parent instanceof MFrame)) {
                return new CreateE4ObjectCommand(child, parent, location, newIndex);
            }
            return null;
        }
        if (child instanceof MField) {
            if (typeAdd && ShowFieldsTreeAction.isFieldsTree(parent.getJasperConfiguration())) {
                if (parent instanceof MField) {
                    parent = parent.getParent();
                }
                if (parent instanceof MFields) {
                    ArrayList<ANode> lst = new ArrayList<ANode>();
                    lst.add((MField)child);
                    return new CreateFieldsContainerCommand((MFields)parent, lst, typeAdd);
                }
            }
            if (parent instanceof MFields) {
                if (SortFieldsAction.areFieldsSorted(parent.getJasperConfiguration()) || ShowFieldsTreeAction.isFieldsTree(parent.getJasperConfiguration())) {
                    return null;
                }
                return new CreateFieldCommand((MFields)parent, (MField)child, newIndex);
            }
            if (parent instanceof MField) {
                if (SortFieldsAction.areFieldsSorted(parent.getJasperConfiguration()) || ShowFieldsTreeAction.isFieldsTree(parent.getJasperConfiguration())) {
                    return null;
                }
                if (parent.getParent() != null) {
                    newIndex = parent.getParent().getChildren().indexOf(parent);
                    return new CreateFieldCommand((MFields)parent.getParent(), (MField)child, newIndex);
                }
            } else if (child.getValue() != null) {
                ANode targetNode = null;
                if (parent instanceof MReport || parent instanceof MBand || parent instanceof MFrame) {
                    targetNode = parent;
                } else if (parent instanceof MGraphicElement) {
                    targetNode = parent.getParent();
                }
                if (targetNode != null) {
                    int index = newIndex;
                    int createdElements = 1;
                    if (request instanceof CreateRequest) {
                        EditPart targetEditPart;
                        CreateRequest cRequest = (CreateRequest)request;
                        Object newObject = cRequest.getNewObject();
                        createdElements = 0;
                        if (newObject instanceof Collection) {
                            for (Object createdElement : (Collection)newObject) {
                                if (!(createdElement instanceof MField)) continue;
                                ++createdElements;
                            }
                        }
                        if ((targetEditPart = targetNode.getFigureEditPart()) instanceof FigureEditPart) {
                            IFigure hostFigure2 = ((FigureEditPart)targetEditPart).getFigure();
                            Point location2 = cRequest.getLocation().getCopy();
                            hostFigure2.translateToRelative((Translatable)location2);
                            Dimension newLocation = location2.getDifference(hostFigure2.getBounds().getTopLeft());
                            index = ModelUtils.getBetweenIndex(targetNode, new Point(newLocation.width, newLocation.height));
                        }
                    }
                    CreateFieldInEditorCommand cmd = new CreateFieldInEditorCommand((MField)child, targetNode, location, index);
                    cmd.setCreatedFields(createdElements);
                    return cmd;
                }
            }
        } else if (child instanceof MParameterSystem) {
            if (child instanceof MParameter) {
                MParameters paramterParent;
                if (parent instanceof MParameters) {
                    p = (JRDesignParameter)child.getValue();
                    if (p == null || !p.isSystemDefined()) {
                        return new CreateParameterCommand((MParameters)parent, (MParameter)child, newIndex);
                    }
                } else if (parent instanceof MParameter && ((p = (JRDesignParameter)child.getValue()) == null || !p.isSystemDefined()) && parent.getParent() != null && (paramterParent = (MParameters)parent.getParent()).getValue() instanceof JRDesignDataset) {
                    newIndex = parent.getParent().getChildren().indexOf(parent);
                    return new CreateParameterCommand((MParameters)parent.getParent(), (MParameter)child, newIndex);
                }
            }
            if (child.getValue() != null && (parent instanceof MGraphicElement || parent instanceof MReport || parent instanceof MBand || parent instanceof MFrame)) {
                return new CreateE4ObjectCommand(child, parent, location, newIndex);
            }
        } else if (child instanceof MVariableSystem) {
            if (parent instanceof MVariables) {
                p = (JRDesignVariable)child.getValue();
                if (p == null || !p.isSystemDefined()) {
                    return new CreateVariableCommand((MVariables)parent, (MVariable)child, newIndex);
                }
            } else if (parent instanceof MVariable && ((p = (JRDesignVariable)child.getValue()) == null || !p.isSystemDefined()) && parent.getParent() != null) {
                newIndex = parent.getParent().getChildren().indexOf(parent);
                return new CreateVariableCommand((MVariables)parent.getParent(), (MVariable)child, newIndex);
            }
            if (child.getValue() != null && (parent instanceof MGraphicElement || parent instanceof MReport || parent instanceof MBand || parent instanceof MFrame)) {
                return new CreateE4ObjectCommand(child, parent, location, newIndex);
            }
        } else {
            if (child instanceof MConditionalStyle) {
                if (parent instanceof MStyle && parent.getValue() instanceof JRDesignStyle) {
                    return new CreateConditionalStyleCommand((MStyle)parent, (MConditionalStyle)child, newIndex);
                }
                return null;
            }
            if (child instanceof MStyle) {
                MGraphicElement element;
                if (parent instanceof MStyles) {
                    return new com.jaspersoft.studio.model.style.command.CreateStyleCommand((MStyles)parent, (MStyle)child, newIndex);
                }
                if (parent instanceof MGraphicElement && child.getValue() != null && !(parent instanceof IContainer)) {
                    SetValueCommand cmd = new SetValueCommand();
                    cmd.setTarget((IPropertySource)parent);
                    cmd.setPropertyId("parentStyle");
                    JRStyle style = (JRStyle)child.getValue();
                    cmd.setPropertyValue(style.getName());
                    return cmd;
                }
                if (parent instanceof MStylesTemplate && ((MStylesTemplate)parent).isEditable()) {
                    return new CreateStyleCommand((MStylesTemplate)parent, (MStyle)child, -1);
                }
                if (parent instanceof MReport && location != null && (element = ModelUtils.getElement4Point(parent, new Point(location.x, location.y))) != null) {
                    SetValueCommand cmd = new SetValueCommand();
                    cmd.setTarget(element);
                    cmd.setPropertyId("parentStyle");
                    JRStyle style = (JRStyle)child.getValue();
                    cmd.setPropertyValue(style.getName());
                    return cmd;
                }
            }
        }
        if (child instanceof MCompositeElement) {
            return CompositeElementManager.INSTANCE.getCommand(parent, (MCompositeElement)child, location, newIndex);
        }
        if (child instanceof MPageXofY) {
            if (parent instanceof MElementGroup) {
                return new CreatePageXofYCommand((ANode)((MElementGroup)parent), (MPageXofY)child, location, newIndex);
            }
            if (parent instanceof MBand) {
                return new CreatePageXofYCommand((ANode)((MBand)parent), (MPageXofY)child, location, newIndex);
            }
            if (parent instanceof MFrame) {
                return new CreatePageXofYCommand((ANode)((MFrame)parent), (MPageXofY)child, location, newIndex);
            }
            if (parent instanceof MReport) {
                return new CreatePageXofYCommand(parent, (MPageXofY)child, location, newIndex);
            }
        } else if (child instanceof MPercentage) {
            if (parent instanceof MElementGroup) {
                return new CreatePercentageCommand((ANode)((MElementGroup)parent), (MPercentage)child, location, newIndex);
            }
            if (parent instanceof MBand) {
                return new CreatePercentageCommand((ANode)((MBand)parent), (MPercentage)child, location, newIndex);
            }
            if (parent instanceof MFrame) {
                return new CreatePercentageCommand((ANode)((MFrame)parent), (MPercentage)child, location, newIndex);
            }
            if (parent instanceof MReport) {
                return new CreatePercentageCommand(parent, (MPercentage)child, location, newIndex);
            }
        } else if (child instanceof MSubreport) {
            if (parent instanceof MElementGroup) {
                return new CreateSubreportCommand((MElementGroup)parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MBand) {
                return new CreateSubreportCommand((MBand)parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MFrame) {
                return new CreateSubreportCommand((ANode)((MFrame)parent), (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MReport) {
                return new CreateSubreportCommand(parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof IGroupElement) {
                return new CreateSubreportCommand(parent, (MGraphicElement)child, location, newIndex);
            }
        } else if (child instanceof MImage) {
            if (parent instanceof MElementGroup) {
                return new CreateImageCommand((MElementGroup)parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MBand) {
                return new CreateImageCommand((MBand)parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MFrame) {
                return new CreateImageCommand((ANode)((MFrame)parent), (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MReport) {
                return new CreateImageCommand(parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof IGroupElement) {
                return new CreateElementCommand(parent, (MGraphicElement)child, location, newIndex);
            }
        } else if (child instanceof MGraphicElement) {
            if (parent instanceof MElementGroup) {
                return new CreateElementCommand((MElementGroup)parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MBand) {
                return new CreateElementCommand((MBand)parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MFrame) {
                return new CreateElementCommand((MFrame)parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof MReport) {
                return new CreateElementCommand(parent, (MGraphicElement)child, location, newIndex);
            }
            if (parent instanceof IGroupElement) {
                return new CreateElementCommand(parent, (MGraphicElement)child, location, newIndex);
            }
        } else if (child instanceof MElementGroup) {
            if (parent instanceof MElementGroup) {
                return new CreateElementGroupCommand(parent, (MElementGroup)child, newIndex);
            }
            if (parent instanceof MBand) {
                return new CreateElementGroupCommand(parent, (MElementGroup)child, newIndex);
            }
            if (parent instanceof MFrame) {
                return new CreateElementGroupCommand(parent, (MElementGroup)child, newIndex);
            }
        } else if (child instanceof MConditionalStyle && ((APropertyNode)child).isEditable()) {
            if (parent instanceof MStyle && !(parent instanceof MConditionalStyle)) {
                return new CreateConditionalStyleCommand((MStyle)parent, (MConditionalStyle)child, newIndex);
            }
        } else if (child instanceof MStyleTemplate && ((APropertyNode)child).isEditable()) {
            if (parent instanceof MStyles) {
                return new CreateStyleTemplateCommand((MStyles)parent, (MStyleTemplate)child, 0);
            }
        } else if (child instanceof MSortField) {
            JRDesignDataset ds;
            if (parent instanceof MSortFields && (ds = (JRDesignDataset)parent.getValue()).getVariablesList().size() + ds.getFieldsList().size() >= parent.getChildren().size()) {
                return new CreateSortFieldCommand((MSortFields)parent, (MSortField)child, newIndex);
            }
        } else if (child instanceof MGroup) {
            if (parent instanceof MGroups) {
                return new CreateGroupCommand((MGroups)parent, (MGroup)child, newIndex);
            }
            if (parent instanceof MReport) {
                return new CreateMainGroupCommand((MReport)parent, (MGroup)child, newIndex);
            }
        } else if (child instanceof MScriptlet) {
            if (parent instanceof MScriptlets) {
                return new CreateScriptletCommand((MScriptlets)parent, (MScriptlet)child, newIndex);
            }
        } else if (child instanceof MDataset) {
            if (parent instanceof MReport) {
                return new CreateDatasetCommand((MReport)parent, (MDataset)child, newIndex);
            }
        } else if (child instanceof MBand) {
            if (parent instanceof MBandGroupHeader) {
                return new CreateBandGroupHeaderCommand((MBandGroupHeader)parent);
            }
            if (parent instanceof MBandGroupFooter) {
                return new CreateBandGroupFooterCommand((MBandGroupFooter)parent);
            }
            if (parent instanceof MBand && parent.getValue() == null) {
                return new CreateBandCommand((MBand)parent, (MBand)child);
            }
        }
        return null;
    }

    public static Command getOrphanCommand(ANode parent, ANode child) {
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        Command c = m.getOrphanCommand(parent, child);
        if (c != null) {
            return c;
        }
        if (child instanceof MField) {
            if (ShowFieldsTreeAction.isFieldsTree(parent.getJasperConfiguration())) {
                if (parent instanceof MField) {
                    parent = parent.getParent();
                }
                if (parent instanceof MFields) {
                    return new DoNothingCommand();
                }
                return null;
            }
            return new NoActionCommand();
        }
        if (child instanceof MFieldsContainer) {
            return new DoNothingCommand();
        }
        if (child instanceof MParameterSystem) {
            return new NoActionCommand();
        }
        if (child instanceof MVariableSystem) {
            return new NoActionCommand();
        }
        if (child instanceof MConditionalStyle && parent instanceof MStyle) {
            return new OrphanConditionalStyleCommand((MStyle)parent, (MConditionalStyle)child);
        }
        if (child instanceof MStyle) {
            return new NoActionCommand();
        }
        if (child instanceof MGraphicElement) {
            return new OrphanElementCommand(parent, (MGraphicElement)child);
        }
        if (child instanceof MElementGroup) {
            return new OrphanElementGroupCommand(parent, (MElementGroup)child);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

