/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractFilePropertyAction
extends ACachedSelectionAction {
    public AbstractFilePropertyAction(IWorkbenchPart part) {
        super(part, 2);
    }

    protected Command generateCommand(final ANode selectedNode) {
        Command cmd = new Command(){
            private boolean oldValue;

            public void execute() {
                IFile reportFile = selectedNode.getJasperConfiguration().getAssociatedReportFile();
                try {
                    String property = reportFile.getPersistentProperty(new QualifiedName(JaspersoftStudioPlugin.getUniqueIdentifier(), AbstractFilePropertyAction.this.getPersistentPropertyName()));
                    this.oldValue = Boolean.parseBoolean(property);
                    reportFile.setPersistentProperty(new QualifiedName(JaspersoftStudioPlugin.getUniqueIdentifier(), AbstractFilePropertyAction.this.getPersistentPropertyName()), Boolean.toString(!this.oldValue));
                    selectedNode.propertyChange(new PropertyChangeEvent(selectedNode, MGraphicElement.FORCE_GRAPHICAL_REFRESH, this.oldValue, !this.oldValue));
                    AbstractFilePropertyAction.this.update();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.oldValue = false;
                }
            }

            public void undo() {
                IFile reportFile = selectedNode.getJasperConfiguration().getAssociatedReportFile();
                try {
                    reportFile.setPersistentProperty(new QualifiedName(JaspersoftStudioPlugin.getUniqueIdentifier(), AbstractFilePropertyAction.this.getPersistentPropertyName()), Boolean.toString(this.oldValue));
                    selectedNode.propertyChange(new PropertyChangeEvent(selectedNode, MGraphicElement.FORCE_GRAPHICAL_REFRESH, !this.oldValue, this.oldValue));
                    AbstractFilePropertyAction.this.update();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return cmd;
    }

    @Override
    public boolean isDirty() {
        return this.fresh;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    protected static boolean isPropertySet(JasperReportsConfiguration jConfig, String propertyName) {
        if (jConfig != null) {
            IFile reportFile = jConfig.getAssociatedReportFile();
            try {
                String property = reportFile.getPersistentProperty(new QualifiedName(JaspersoftStudioPlugin.getUniqueIdentifier(), propertyName));
                return Boolean.parseBoolean(property);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected abstract String getPersistentPropertyName();
}

