/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.editor.outline.actions.ACreateAndSelectAction;
import com.jaspersoft.studio.editor.palette.JDPaletteCreationFactory;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.band.MBand;
import java.util.List;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateBandAction
extends ACreateAndSelectAction {
    public static final String ID = "create_band";

    public CreateBandAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
        this.setCreationFactory(new JDPaletteCreationFactory(MBand.class));
    }

    @Override
    protected boolean calculateEnabled() {
        if (!this.checkAllSelectedObjects(MBand.class)) {
            return false;
        }
        List<Object> elements = this.editor.getSelectionCache().getSelectionModelForType(MBand.class);
        for (Object obj : elements) {
            if (!(obj instanceof MBand)) {
                return false;
            }
            if (((MBand)obj).getValue() != null) {
                return false;
            }
            if (((MBand)obj).getBandType() == BandTypeEnum.DETAIL) {
                return false;
            }
            if (((MBand)obj).getBandType() == BandTypeEnum.GROUP_HEADER) {
                return false;
            }
            if (((MBand)obj).getBandType() != BandTypeEnum.GROUP_FOOTER) continue;
            return false;
        }
        this.command = this.createCommand();
        return this.command != null && this.command.canExecute();
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateBandAction_create_band);
        this.setToolTipText(Messages.CreateBandAction_create_band_tool_tip);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        Object obj;
        super.run();
        ISelection s = this.getSelection();
        if (s instanceof StructuredSelection && (obj = ((StructuredSelection)s).getFirstElement()) instanceof EditPart) {
            EditPart editPart = (EditPart)obj;
            StructuredSelection newselection = new StructuredSelection((Object)editPart.getParent());
            this.setSelection((ISelection)newselection);
            this.getWorkbenchPart().getSite().getSelectionProvider().setSelection((ISelection)newselection);
            this.setSelection(s);
            this.getWorkbenchPart().getSite().getSelectionProvider().setSelection(s);
        }
    }
}

