/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.parameter.command.CreateParameterCommand;
import com.jaspersoft.studio.prm.ParameterSet;
import com.jaspersoft.studio.prm.wizard.ParameterSetWizard;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateParameterSetAction
extends ACachedSelectionAction {
    public static final String ID = "create_parameter_set";

    public CreateParameterSetAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        CommonSelectionCacheProvider cache = this.editor.getSelectionCache();
        List<Object> selection = cache.getSelectionModelForType(MParameters.class);
        return !selection.isEmpty() && ((ANode)selection.get(0)).getParent() instanceof MReport;
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateParameterSetAction_0);
        this.setToolTipText(Messages.CreateParameterSetAction_1);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        List<Object> mGraphElements = this.editor.getSelectionCache().getSelectionModelForType(MParameters.class);
        for (Object obj : mGraphElements) {
            JSSCompoundCommand cmd;
            if (!(obj instanceof MParameters)) continue;
            MParameters mPrm = (MParameters)obj;
            JasperReportsConfiguration jConfig = mPrm.getJasperConfiguration();
            ParameterSetWizard wizard = new ParameterSetWizard(jConfig);
            WizardDialog dialog = new WizardDialog(UIUtils.getShellForWizardDialog(), (IWizard)wizard);
            dialog.create();
            if (dialog.open() == 0) {
                ParameterSet prmSet = wizard.getValue();
                if (prmSet == null) {
                    return;
                }
                boolean override = wizard.isOverride();
                cmd = new JSSCompoundCommand(null);
                JRDesignDataset ds = (JRDesignDataset)mPrm.getValue();
                for (JRDesignParameter p : prmSet.getParameters()) {
                    if (ds.getParametersMap().containsKey(p.getName())) {
                        if (!override) continue;
                        MParameter target = null;
                        for (INode n : mPrm.getChildren()) {
                            MParameter parm;
                            if (!(n instanceof MParameter) || !(parm = (MParameter)n).getValue().getName().equals(p.getName())) continue;
                            target = parm;
                            break;
                        }
                        SetValueCommand c = new SetValueCommand();
                        c.setTarget(target);
                        c.setPropertyId("description");
                        c.setPropertyValue(p.getDescription());
                        cmd.add(c);
                        c = new SetValueCommand();
                        c.setTarget(target);
                        c.setPropertyId("valueClassName");
                        c.setPropertyValue(p.getValueClassName());
                        cmd.add(c);
                        c = new SetValueCommand();
                        c.setTarget(target);
                        c.setPropertyId("nestedType");
                        c.setPropertyValue(p.getNestedTypeName());
                        cmd.add(c);
                        c = new SetValueCommand();
                        c.setTarget(target);
                        c.setPropertyId("defaultValueExpression");
                        c.setPropertyValue(p.getDefaultValueExpression());
                        cmd.add(c);
                        c = new SetValueCommand();
                        c.setTarget(target);
                        c.setPropertyId("isForPrompting");
                        c.setPropertyValue(p.isForPrompting());
                        cmd.add(c);
                        continue;
                    }
                    cmd.add(new CreateParameterCommand(ds, (JRParameter)p, jConfig, -1));
                }
            } else {
                return;
            }
            this.command = cmd;
            this.fresh = true;
            super.run();
            break;
        }
    }
}

