/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.jface.dialogs.StyleTemplateSelectionDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.model.style.MStyles;
import com.jaspersoft.studio.model.style.command.CreateStyleTemplateCommand;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CreateStyleTemplateAction
extends ACachedSelectionAction {
    public static final String ID = "create_style_template";

    public CreateStyleTemplateAction(IWorkbenchPart part) {
        super(part);
    }

    @Override
    protected boolean calculateEnabled() {
        return this.checkSingleSelectedObject(MStyles.class);
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateStyleTemplateAction_create_style_template);
        this.setToolTipText(Messages.CreateStyleTemplateAction_create_style_template_tool_tip);
        this.setId(ID);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_NEW_WIZARD_DISABLED"));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        EditPart editPart;
        List children;
        Object obj;
        ISelection s;
        MStyles node = (MStyles)this.editor.getSelectionCache().getSelectionModelForType(MStyles.class).get(0);
        JasperReportsConfiguration jConfig = node.getJasperConfiguration();
        StyleTemplateSelectionDialog fsd = new StyleTemplateSelectionDialog(UIUtils.getShell());
        fsd.configureDialog(jConfig);
        if (fsd.open() == 0) {
            JRDesignReportTemplate jrTemplate = MStyleTemplate.createJRTemplate();
            jrTemplate.setSourceExpression((JRExpression)fsd.getFileExpression());
            IFile project = (IFile)jConfig.get("ifile");
            String location = ExternalStylesManager.evaluateStyleExpression((JRReportTemplate)jrTemplate, project, jConfig);
            if (location != null && (!fsd.isValidationAllowed() || ExternalStylesManager.validateTemplate(jConfig, location))) {
                CreateStyleTemplateCommand command = new CreateStyleTemplateCommand(node, jrTemplate, 0);
                this.execute(command);
                jConfig.refreshCachedStyles();
            } else {
                UIUtils.showWarning((String)"The selected resource is not a valid template style");
            }
        }
        if ((s = this.getSelection()) instanceof StructuredSelection && (obj = ((StructuredSelection)s).getFirstElement()) instanceof EditPart && (children = (editPart = (EditPart)obj).getParent().getChildren()) != null && !children.isEmpty()) {
            int last = 0;
            StructuredSelection newselection = new StructuredSelection(children.get(last));
            this.setSelection((ISelection)newselection);
            this.getWorkbenchPart().getSite().getSelectionProvider().setSelection((ISelection)newselection);
        }
    }
}

