/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.editor.outline.actions.AbstractFilePropertyAction;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class HideDefaultsParametersAction
extends AbstractFilePropertyAction {
    public static final String ID = "hide_default_parameters";
    private static final String HIDE_PROPERTY_NAME = "com.jaspersoft.studio.hideParameters";

    public HideDefaultsParametersAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText("Hide Default Parameters");
        this.setToolTipText("Hide the default parameters");
        this.setId(ID);
        this.setEnabled(false);
    }

    public static boolean areDefaultParametersHidden(JasperReportsConfiguration jConfig) {
        return HideDefaultsParametersAction.isPropertySet(jConfig, HIDE_PROPERTY_NAME);
    }

    @Override
    protected String getPersistentPropertyName() {
        return HIDE_PROPERTY_NAME;
    }

    @Override
    protected Command createCommand() {
        List<Object> selection = this.editor.getSelectionCache().getSelectionModelForType(MParameters.class);
        if (selection.size() == 1 && selection.get(0).getClass().equals(MParameters.class)) {
            MParameters selectedVariables = (MParameters)selection.get(0);
            return this.generateCommand(selectedVariables);
        }
        return null;
    }

    public boolean isChecked() {
        List<Object> selection = this.editor.getSelectionCache().getSelectionModelForType(MParameters.class);
        if (selection.size() == 1) {
            MParameters selectedVariables = (MParameters)selection.get(0);
            return HideDefaultsParametersAction.isPropertySet(selectedVariables.getJasperConfiguration(), this.getPersistentPropertyName());
        }
        return false;
    }
}

