/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.actions;

import com.jaspersoft.studio.ExternalStylesManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IWorkbenchPart;

public class RefreshTemplateStyleExpression
extends ACachedSelectionAction {
    public static final String ID = "refresh_template_style_expression";

    public RefreshTemplateStyleExpression(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.RefreshTemplateStyleExpression_title);
        this.setToolTipText(Messages.RefreshTemplateStyleExpression_tooltip);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/refresh_style_action.png"));
        this.setEnabled(false);
    }

    @Override
    protected boolean calculateEnabled() {
        return !this.getSelectedStyles().isEmpty();
    }

    @Override
    public void run() {
        List<MStyleTemplate> templates = this.getSelectedStyles();
        for (MStyleTemplate template : templates) {
            ExternalStylesManager.refreshStyle(template);
            template.refreshChildren();
        }
    }

    private List<MStyleTemplate> getSelectedStyles() {
        List<Object> templates = this.editor.getSelectionCache().getSelectionModelForType(MStyleTemplate.class);
        ArrayList<MStyleTemplate> result = new ArrayList<MStyleTemplate>();
        for (Object template : templates) {
            result.add((MStyleTemplate)template);
        }
        return result;
    }
}

