/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.outline.part;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.background.MBackgrounImage;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.outline.actions.HideDefaultVariablesAction;
import com.jaspersoft.studio.editor.outline.actions.HideDefaultsParametersAction;
import com.jaspersoft.studio.editor.outline.actions.SortParametersAction;
import com.jaspersoft.studio.editor.outline.actions.SortVariablesAction;
import com.jaspersoft.studio.editor.outline.actions.field.ShowFieldsTreeAction;
import com.jaspersoft.studio.editor.outline.actions.field.SortFieldsAction;
import com.jaspersoft.studio.editor.outline.editpolicy.ElementEditPolicy;
import com.jaspersoft.studio.editor.outline.editpolicy.ElementTreeEditPolicy;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.ReportContainer;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MLockableRefresh;
import com.jaspersoft.studio.model.field.FieldUtils;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.sortfield.MSortField;
import com.jaspersoft.studio.model.variable.MVariableSystem;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class TreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    private IResource associatedFile;
    protected EditPart lastEditorFeedback = null;
    private static HashSet<EditPart> nodeToRefresh = new HashSet();
    private MLockableRefresh refreshReferenceNode = null;

    protected void removeChildVisual(EditPart childEditPart) {
        TreeEditPart treeEditPart = (TreeEditPart)childEditPart;
        if (treeEditPart.getWidget() != null) {
            treeEditPart.getWidget().dispose();
        }
        treeEditPart.setWidget(null);
    }

    protected void showTargetFeedbackOnEditor(Request request) {
        if ("add children".equals(request.getType())) {
            EditPart targetPart = this.getTargetEditPart(request);
            IEditorPart currentEditor = SelectionHelper.getActiveJRXMLEditor();
            if (currentEditor instanceof JrxmlEditor) {
                AbstractVisualEditor reportEditor;
                EditPart editorPart;
                JrxmlEditor jrxmlEditor = (JrxmlEditor)currentEditor;
                ReportContainer reportContainer = jrxmlEditor.getReportContainer();
                IEditorPart activeEditor = reportContainer.getActiveEditor();
                if (targetPart != null && activeEditor instanceof AbstractVisualEditor && (editorPart = (EditPart)(reportEditor = (AbstractVisualEditor)activeEditor).getGraphicalViewer().getEditPartRegistry().get(targetPart.getModel())) != null) {
                    this.eraseTargetFeedback(request);
                    editorPart.showTargetFeedback(request);
                    this.lastEditorFeedback = editorPart;
                }
            }
        }
    }

    protected void eraseTargetFeedbackOnEditor(Request request) {
        if (this.lastEditorFeedback != null) {
            this.lastEditorFeedback.eraseTargetFeedback(request);
            this.lastEditorFeedback = null;
        }
    }

    protected void addChild(EditPart child, int index) {
        if (child != null) {
            super.addChild(child, index);
        }
    }

    public void activate() {
        super.activate();
        if (this.getModel() != null) {
            ((ANode)this.getModel()).getPropertyChangeSupport().addPropertyChangeListener(this);
        }
    }

    public void deactivate() {
        if (this.getModel() != null) {
            ((ANode)this.getModel()).getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ElementEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new ElementTreeEditPolicy(){

            @Override
            protected Command getMoveCommand(ChangeBoundsRequest req) {
                EditPart parent = this.getHost().getParent();
                if (parent != null && req.getEditParts() != null) {
                    ANode variables;
                    Object model = parent.getModel();
                    if (model != null && (model.getClass().equals(MVariables.class) ? SortVariablesAction.areVariablesSorted((variables = (MVariables)model).getJasperConfiguration()) : (model.getClass().equals(MParameters.class) ? SortParametersAction.areParametersSorted((variables = (MParameters)model).getJasperConfiguration()) : model instanceof MFields && !ShowFieldsTreeAction.isFieldsTree((variables = (MFields)model).getJasperConfiguration()) && SortFieldsAction.areFieldsSorted(variables.getJasperConfiguration())))) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move children");
                    if (req.getEditParts().size() > 1) {
                        request.setEditParts(req.getEditParts());
                    } else {
                        request.setEditParts(this.getHost());
                    }
                    request.setLocation(req.getLocation());
                    return parent.getCommand((Request)request);
                }
                return UnexecutableCommand.INSTANCE;
            }
        });
    }

    protected void refreshVisuals() {
        if (this.getWidget() instanceof Tree) {
            return;
        }
        UIUtils.getDisplay().asyncExec(() -> {
            TreeItem item = (TreeItem)this.getWidget();
            ANode node = (ANode)this.getModel();
            this.refreshItem(item, node);
        });
    }

    private void refreshItem(TreeItem item, ANode node) {
        if (node != null && this.checkTreeItem(item)) {
            String displayText;
            Image image;
            if (node.getImagePath() != null && (image = JaspersoftStudioPlugin.getInstance().getImage(node.getImagePath())) != null) {
                if (node.getBackground() != null) {
                    image.setBackground(node.getBackground());
                } else if (item != null && item.getParent() != null && item.getParent().getBackground() != null) {
                    image.setBackground(item.getParent().getBackground());
                }
                this.setWidgetImage(item, image);
            }
            if (item != null) {
                Color foreGround;
                Color backGround = node.getBackground();
                if (backGround != null) {
                    item.setBackground(backGround);
                }
                if ((foreGround = node.getForeground()) != null) {
                    item.setForeground(foreGround);
                }
            }
            if ((displayText = node.getDisplayText()) != null) {
                if ((displayText = displayText.replaceAll("(\\r|\\n)+", " ")).length() > 30 && !(node instanceof MField) && !(node instanceof MSortField)) {
                    displayText = String.valueOf(displayText.substring(0, 30)) + " ...";
                }
                this.setWidgetText(item, displayText);
            } else {
                this.setWidgetText(item, "Unknown");
            }
        }
    }

    protected final boolean checkTreeItem(TreeItem widget) {
        return widget != null && !widget.isDisposed();
    }

    protected void setWidgetText(TreeItem item, String text) {
        if (this.checkTreeItem(item)) {
            item.setText(text);
        }
    }

    protected void setWidgetImage(TreeItem item, Image image) {
        if (this.checkTreeItem(item)) {
            item.setImage(image);
        }
    }

    protected List<?> getModelChildren() {
        ArrayList<INode> list = new ArrayList<INode>();
        ANode modelNode = (ANode)this.getModel();
        if (modelNode != null && modelNode.showChildren()) {
            boolean showDefaults;
            JasperReportsConfiguration jConfig = modelNode.getJasperConfiguration();
            boolean bl = showDefaults = jConfig != null ? jConfig.getPropertyBoolean("showVariablesDefault", Boolean.TRUE) : true;
            if (modelNode.getClass().equals(MVariables.class)) {
                boolean showVariables = !HideDefaultVariablesAction.areDefaultVariablesHidden(jConfig);
                list.addAll(this.getVariables(jConfig, (MVariables)modelNode, showDefaults && showVariables));
            } else if (modelNode.getClass().equals(MParameters.class)) {
                boolean showParameters = !HideDefaultsParametersAction.areDefaultParametersHidden(jConfig);
                list.addAll(this.getParameters(jConfig, (MParameters)modelNode, showDefaults && showParameters));
            } else if (modelNode.getClass().equals(MFields.class)) {
                list.addAll(this.getFields(jConfig, (MFields)modelNode));
            } else {
                for (INode node : modelNode.getChildren()) {
                    if (node.getClass().equals(MBackgrounImage.class)) continue;
                    list.add(node);
                }
            }
        }
        return list;
    }

    protected List<INode> getFields(JasperReportsConfiguration jConfig, MFields parentNode) {
        ArrayList<INode> result = new ArrayList<INode>();
        ArrayList<INode> children = null;
        if (ShowFieldsTreeAction.isFieldsTree(jConfig)) {
            FieldUtils.buildFieldsTree(parentNode, this);
            children = new ArrayList<INode>(parentNode.getChildren());
        } else {
            FieldUtils.flatTree(parentNode);
            children = new ArrayList<INode>(parentNode.getChildren());
            if (SortFieldsAction.areFieldsSorted(jConfig)) {
                Collections.sort(children, new Comparator<INode>(){

                    @Override
                    public int compare(INode o1, INode o2) {
                        MField var1 = (MField)o1;
                        MField var2 = (MField)o2;
                        String nameVar1 = (String)var1.getPropertyActualValue("name");
                        String nameVar2 = (String)var2.getPropertyActualValue("name");
                        return nameVar1.toLowerCase().compareTo(nameVar2.toLowerCase());
                    }
                });
            }
        }
        for (INode node : children) {
            result.add(node);
        }
        return result;
    }

    protected List<INode> getVariables(JasperReportsConfiguration jConfig, MVariables parentNode, boolean showDefaults) {
        ArrayList<INode> result = new ArrayList<INode>();
        ArrayList<INode> children = new ArrayList<INode>(parentNode.getChildren());
        if (SortVariablesAction.areVariablesSorted(jConfig)) {
            Collections.sort(children, new Comparator<INode>(){

                @Override
                public int compare(INode o1, INode o2) {
                    MVariableSystem var1 = (MVariableSystem)o1;
                    MVariableSystem var2 = (MVariableSystem)o2;
                    String nameVar1 = (String)var1.getPropertyActualValue("name");
                    String nameVar2 = (String)var2.getPropertyActualValue("name");
                    return nameVar1.toLowerCase().compareTo(nameVar2.toLowerCase());
                }
            });
        }
        for (INode node : children) {
            if (showDefaults) {
                result.add(node);
                continue;
            }
            if (node.getClass().equals(MVariableSystem.class)) continue;
            result.add(node);
        }
        return result;
    }

    protected List<INode> getParameters(JasperReportsConfiguration jConfig, MParameters<?> parentNode, boolean showDefaults) {
        ArrayList<INode> result = new ArrayList<INode>();
        ArrayList<INode> children = new ArrayList<INode>(parentNode.getChildren());
        if (SortParametersAction.areParametersSorted(jConfig)) {
            Collections.sort(children, new Comparator<INode>(){

                @Override
                public int compare(INode o1, INode o2) {
                    MParameterSystem var1 = (MParameterSystem)o1;
                    MParameterSystem var2 = (MParameterSystem)o2;
                    String nameVar1 = (String)var1.getPropertyActualValue("name");
                    String nameVar2 = (String)var2.getPropertyActualValue("name");
                    return nameVar1.toLowerCase().compareTo(nameVar2.toLowerCase());
                }
            });
        }
        for (INode node : children) {
            if (showDefaults) {
                result.add(node);
                continue;
            }
            if (node.getClass().equals(MParameterSystem.class)) continue;
            result.add(node);
        }
        return result;
    }

    private MLockableRefresh getLockReferenceNode() {
        if (this.refreshReferenceNode == null) {
            EditPart root = (EditPart)this.getRoot().getChildren().get(0);
            ANode modelNode = (ANode)root.getModel();
            this.refreshReferenceNode = (MLockableRefresh)JSSCompoundCommand.getMainNode(modelNode);
        }
        return this.refreshReferenceNode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("refreshUIEvent")) {
            this.refreshCached();
            this.refresh();
            return;
        }
        if (this.getRoot() != null) {
            MLockableRefresh refrenceNode = this.getLockReferenceNode();
            if (refrenceNode != null && refrenceNode.isRefreshEventIgnored()) {
                nodeToRefresh.add((EditPart)this);
                return;
            }
            this.refresh();
        }
    }

    private void refreshCached() {
        UIUtils.getDisplay().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MLockableRefresh mLockableRefresh = TreeEditPart.this.getLockReferenceNode();
                synchronized (mLockableRefresh) {
                    try {
                        for (EditPart part : nodeToRefresh) {
                            if (((ANode)part.getModel()).getParent() == null || part.getViewer() == null) continue;
                            part.refresh();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    nodeToRefresh.clear();
                }
            }
        });
    }

    public Object getAdapter(Class key) {
        if (key == IResource.class || key == IFile.class) {
            if (this.associatedFile == null) {
                this.associatedFile = this.getAssociatedFile();
            }
            return this.associatedFile;
        }
        return super.getAdapter(key);
    }

    public IResource getAssociatedFile() {
        IEditorInput edinput = null;
        if (this.getViewer() != null && this.getViewer().getEditDomain() instanceof DefaultEditDomain) {
            IEditorPart ip = ((DefaultEditDomain)this.getViewer().getEditDomain()).getEditorPart();
            edinput = ip.getEditorInput();
        } else {
            IEditorPart ep = SelectionHelper.getActiveJRXMLEditor();
            if (ep != null) {
                edinput = ep.getEditorInput();
            }
        }
        if (edinput instanceof IFileEditorInput) {
            return ((IFileEditorInput)edinput).getFile();
        }
        return null;
    }
}

