/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.palette;

import com.jaspersoft.studio.editor.palette.JDCreationTool;
import com.jaspersoft.studio.editor.palette.JDPaletteCreationFactory;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.editor.tools.CompositeElementTemplateCreationEntry;
import com.jaspersoft.studio.editor.tools.ICompositeElementModifyListener;
import com.jaspersoft.studio.editor.tools.MCompositeElement;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;

public class CompositeElementHandler
implements ICompositeElementModifyListener {
    private Map<String, PaletteDrawer> drawersMap = new HashMap<String, PaletteDrawer>();
    protected PaletteRoot root;

    public CompositeElementHandler(PaletteRoot root) {
        this.root = root;
    }

    public void addPaletteGroup(String paletteId, PaletteDrawer paletteDrawer) {
        this.drawersMap.put(paletteId, paletteDrawer);
    }

    protected PaletteDrawer getDrawer(MCompositeElement compositeElement) {
        PaletteDrawer result = this.drawersMap.get(compositeElement.getGroupId());
        if (result == null) {
            result = this.drawersMap.get("com.jaspersoft.studio.COMMON_TOOLS");
        }
        return result;
    }

    @Override
    public void elementChanged(final MCompositeElement oldElement, final MCompositeElement newElement, final ICompositeElementModifyListener.OPERATION_TYPE operation) {
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (operation == ICompositeElementModifyListener.OPERATION_TYPE.ADD) {
                    CompositeElementHandler.this.createElementEntry(newElement, CompositeElementHandler.this.getDrawer(newElement));
                } else if (operation == ICompositeElementModifyListener.OPERATION_TYPE.DELETE) {
                    PaletteDrawer drawer = CompositeElementHandler.this.getDrawer(oldElement);
                    for (Object entry : drawer.getChildren()) {
                        CompositeElementTemplateCreationEntry factory;
                        if (!(entry instanceof CompositeElementTemplateCreationEntry) || (factory = (CompositeElementTemplateCreationEntry)((Object)entry)).getTemplate() != oldElement) continue;
                        drawer.remove((PaletteEntry)factory);
                        break;
                    }
                } else if (operation == ICompositeElementModifyListener.OPERATION_TYPE.EDIT) {
                    if (oldElement.getGroupId().equals(newElement.getGroupId())) {
                        PaletteDrawer drawer = CompositeElementHandler.this.getDrawer(oldElement);
                        int index = 0;
                        for (Object entry : drawer.getChildren()) {
                            CompositeElementTemplateCreationEntry factory;
                            if (entry instanceof CompositeElementTemplateCreationEntry && (factory = (CompositeElementTemplateCreationEntry)((Object)entry)).getTemplate() == oldElement) {
                                drawer.remove((PaletteEntry)factory);
                                CompositeElementHandler.createElementEntry(newElement, CompositeElementHandler.this.getDrawer(newElement), index);
                                break;
                            }
                            ++index;
                        }
                    } else {
                        PaletteDrawer drawer = CompositeElementHandler.this.getDrawer(oldElement);
                        for (Object entry : drawer.getChildren()) {
                            CompositeElementTemplateCreationEntry factory;
                            if (!(entry instanceof CompositeElementTemplateCreationEntry) || (factory = (CompositeElementTemplateCreationEntry)((Object)entry)).getTemplate() != oldElement) continue;
                            drawer.remove((PaletteEntry)factory);
                            break;
                        }
                        CompositeElementHandler.this.createElementEntry(newElement, CompositeElementHandler.this.getDrawer(newElement));
                    }
                }
            }
        });
    }

    public void createAllCompositeElements() {
        for (MCompositeElement element : CompositeElementManager.INSTANCE.getAvailableElements()) {
            PaletteDrawer drawer = this.getDrawer(element);
            this.createElementEntry(element, drawer);
        }
    }

    protected void createElementEntry(MCompositeElement compositeElement, PaletteDrawer container) {
        CompositeElementTemplateCreationEntry paletteEntry = new CompositeElementTemplateCreationEntry(compositeElement.getName(), compositeElement.getDescription(), compositeElement, new JDPaletteCreationFactory(compositeElement), compositeElement.getIconSmall(), compositeElement.getIconBig(), container);
        paletteEntry.setToolClass(JDCreationTool.class);
    }

    protected static void createElementEntry(MCompositeElement compositeElement, PaletteDrawer container, int index) {
        CompositeElementTemplateCreationEntry paletteEntry = new CompositeElementTemplateCreationEntry(compositeElement.getName(), compositeElement.getDescription(), compositeElement, new JDPaletteCreationFactory(compositeElement), compositeElement.getIconSmall(), compositeElement.getIconBig(), container, index);
        paletteEntry.setToolClass(JDCreationTool.class);
    }
}

