/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.palette;

import com.jaspersoft.studio.editor.gef.parts.band.NotMovablePartDragTracker;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.compatibility.SharedImages;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.resource.ImageDescriptor;

public class JDMarqueeToolEntry
extends ToolEntry {
    public JDMarqueeToolEntry() {
        this(null, null);
    }

    public JDMarqueeToolEntry(String label, String description) {
        super(label, description, null, null, NotMovablePartDragTracker.class);
        if (label == null || label.length() == 0) {
            this.setLabel(Messages.JDMarqueeToolEntry_Marquee);
        }
        this.setUserModificationPermission(1);
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description != null) {
            return description;
        }
        int marqueeBehavior = this.getMarqueeBehavior();
        if (marqueeBehavior == NotMovablePartDragTracker.BEHAVIOR_NODES_TOUCHED) {
            return Messages.JDMarqueeToolEntry_Behavior_Nodes_Touched;
        }
        if (marqueeBehavior == NotMovablePartDragTracker.BEHAVIOR_NODES_CONTAINED) {
            return Messages.JDMarqueeToolEntry_Behavior_Nodes_Contained;
        }
        throw new IllegalArgumentException("Unknown marquee behavior");
    }

    public ImageDescriptor getLargeIcon() {
        ImageDescriptor imageDescriptor = super.getLargeIcon();
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return SharedImages.DESC_MARQUEE_TOOL_NODES_24;
    }

    private int getMarqueeBehavior() {
        Object value = this.getToolProperty(NotMovablePartDragTracker.PROPERTY_MARQUEE_BEHAVIOR);
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return NotMovablePartDragTracker.DEFAULT_MARQUEE_BEHAVIOR;
    }

    public ImageDescriptor getSmallIcon() {
        ImageDescriptor imageDescriptor = super.getSmallIcon();
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        return SharedImages.DESC_MARQUEE_TOOL_NODES_16;
    }
}

