/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.palette;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.callout.MCallout;
import com.jaspersoft.studio.editor.palette.CompositeElementHandler;
import com.jaspersoft.studio.editor.palette.JDCreationTool;
import com.jaspersoft.studio.editor.palette.JDPaletteCreationFactory;
import com.jaspersoft.studio.editor.palette.PalettePrenferencesListener;
import com.jaspersoft.studio.editor.tools.CompositeElementManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MBreak;
import com.jaspersoft.studio.model.MEllipse;
import com.jaspersoft.studio.model.MLine;
import com.jaspersoft.studio.model.MRectangle;
import com.jaspersoft.studio.model.frame.MFrame;
import com.jaspersoft.studio.model.genericElement.MGenericElement;
import com.jaspersoft.studio.model.image.MImage;
import com.jaspersoft.studio.model.subreport.MSubreport;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.model.textfield.MDate;
import com.jaspersoft.studio.model.textfield.MPageNumber;
import com.jaspersoft.studio.model.textfield.MPageXofY;
import com.jaspersoft.studio.model.textfield.MPercentage;
import com.jaspersoft.studio.model.textfield.MTime;
import com.jaspersoft.studio.model.textfield.MTotalPages;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.plugin.PaletteGroup;
import com.jaspersoft.studio.preferences.PalettePreferencePage;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;

public class JDPaletteFactory {
    public static PaletteGroup getBaseElementsGroup() {
        PaletteGroup pgc = new PaletteGroup();
        pgc.setId("com.jaspersoft.studio.COMMON_ELEMENTS");
        pgc.setName(Messages.common_elements);
        pgc.setImage("icons/resources/elementgroup-16.png");
        return pgc;
    }

    public static PaletteGroup getOtherElementsGroup() {
        PaletteGroup pgc = new PaletteGroup();
        pgc.setId("com.jaspersoft.studio.COMMON_TOOLS");
        pgc.setName(Messages.common_tools);
        pgc.setImage("icons/resources/fields-16.png");
        return pgc;
    }

    public static PaletteRoot createPalette(List<String> ignore, JasperReportsConfiguration jrConfig) {
        if (ignore == null) {
            ignore = new ArrayList<String>();
        }
        PaletteRoot paletteRoot = new PaletteRoot();
        ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
        List<PaletteGroup> pgroups = m.getPaletteGroups();
        TreeMap<String, PaletteGroup> map = new TreeMap<String, PaletteGroup>();
        PaletteGroup baseElementsGroup = JDPaletteFactory.getBaseElementsGroup();
        map.put(baseElementsGroup.getId(), baseElementsGroup);
        PaletteGroup otherElementsGroup = JDPaletteFactory.getOtherElementsGroup();
        map.put(otherElementsGroup.getId(), otherElementsGroup);
        for (PaletteGroup p : pgroups) {
            map.put(p.getId(), p);
        }
        Map<String, List<PaletteEntry>> mapEntry = m.getPaletteEntries();
        for (String key : mapEntry.keySet()) {
            if (!key.isEmpty() && map.get(key) == null) {
                PaletteGroup pgc = new PaletteGroup();
                pgc.setId(key);
                pgc.setName(Messages.JDPaletteFactory_unknown_group);
                pgc.setImage("");
                map.put(pgc.getId(), pgc);
            }
            for (PaletteEntry pe : mapEntry.get(key)) {
                String id = PalettePreferencePage.getId(pe);
                if (ignore.contains(pe.getId()) || !jrConfig.getPropertyBooleanDef(id, false).booleanValue() || !(pe instanceof CombinedTemplateCreationEntry)) continue;
                ignore.add(((CombinedTemplateCreationEntry)pe).getTemplate().toString());
            }
        }
        pgroups = new ArrayList(map.values());
        ArrayList<PaletteGroup> ordpgrps = new ArrayList<PaletteGroup>(pgroups);
        for (PaletteGroup p : pgroups) {
            if (p.getAfterGroup() == null || p.getAfterGroup().trim().isEmpty() || p.getId().equals(p.getAfterGroup())) continue;
            PaletteGroup opbefore = null;
            for (PaletteGroup op : ordpgrps) {
                if (!op.getId().equals(p.getAfterGroup())) continue;
                opbefore = op;
                break;
            }
            ordpgrps.remove(p);
            int ind = -1;
            if (opbefore != null) {
                ind = ordpgrps.indexOf(opbefore) + 1;
            }
            if (ind >= 0 && ind < ordpgrps.size()) {
                ordpgrps.add(ind, p);
                continue;
            }
            ordpgrps.add(p);
        }
        CompositeElementHandler handler = new CompositeElementHandler(paletteRoot);
        PalettePrenferencesListener hiddenElementsHandler = new PalettePrenferencesListener();
        for (PaletteGroup p : ordpgrps) {
            PaletteDrawer drawer;
            if (p.getId().equals("com.jaspersoft.studio.COMMON_ELEMENTS")) {
                drawer = JDPaletteFactory.createElements(paletteRoot, ignore, p, mapEntry);
                JDPaletteFactory.getEntries4Key(drawer, ignore, "", mapEntry);
                handler.addPaletteGroup(p.getId(), drawer);
                hiddenElementsHandler.addDrawer(drawer);
                continue;
            }
            if (p.getId().equals("com.jaspersoft.studio.COMMON_CONTAINER")) {
                drawer = JDPaletteFactory.createGroup(paletteRoot, ignore, p.getName(), p.getImage());
                JDPaletteFactory.createContainers(drawer, ignore, p, mapEntry);
                handler.addPaletteGroup(p.getId(), drawer);
                hiddenElementsHandler.addDrawer(drawer);
                continue;
            }
            if (p.getId().equals("com.jaspersoft.studio.COMMON_TOOLS")) {
                drawer = JDPaletteFactory.createGroup(paletteRoot, ignore, p.getName(), p.getImage());
                JDPaletteFactory.createOtherElements(drawer, ignore, p, mapEntry);
                handler.addPaletteGroup(p.getId(), drawer);
                hiddenElementsHandler.addDrawer(drawer);
                continue;
            }
            drawer = JDPaletteFactory.createGroup(paletteRoot, ignore, p.getName(), p.getImage());
            JDPaletteFactory.getEntries4Key(drawer, ignore, p.getId(), mapEntry);
            handler.addPaletteGroup(p.getId(), drawer);
            hiddenElementsHandler.addDrawer(drawer);
        }
        handler.createAllCompositeElements();
        CompositeElementManager.INSTANCE.addModifyListener(handler);
        JaspersoftStudioPlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)hiddenElementsHandler);
        return paletteRoot;
    }

    public static PaletteRoot createSimplePalette(List<String> ignore, JasperReportsConfiguration jrConfig) {
        if (ignore == null) {
            ignore = new ArrayList<String>();
        }
        PaletteRoot paletteRoot = new PaletteRoot();
        CompositeElementHandler handler = new CompositeElementHandler(paletteRoot);
        PaletteGroup baseGroup = JDPaletteFactory.getBaseElementsGroup();
        PaletteDrawer drawer = JDPaletteFactory.createGroup(paletteRoot, ignore, baseGroup.getName(), baseGroup.getImage());
        drawer.add(JDPaletteFactory.createJDEntry(MCallout.getIconDescriptor(), MCallout.class));
        drawer.add(JDPaletteFactory.createJDEntry(MTextField.getIconDescriptor(), MTextField.class));
        drawer.add(JDPaletteFactory.createJDEntry(MStaticText.getIconDescriptor(), MStaticText.class));
        drawer.add(JDPaletteFactory.createJDEntry(MImage.getIconDescriptor(), MImage.class));
        drawer.add(JDPaletteFactory.createJDEntry(MBreak.getIconDescriptor(), MBreak.class));
        drawer.add(JDPaletteFactory.createJDEntry(MRectangle.getIconDescriptor(), MRectangle.class));
        drawer.add(JDPaletteFactory.createJDEntry(MEllipse.getIconDescriptor(), MEllipse.class));
        drawer.add(JDPaletteFactory.createJDEntry(MLine.getIconDescriptor(), MLine.class));
        drawer.add(JDPaletteFactory.createJDEntry(MGenericElement.getIconDescriptor(), MGenericElement.class));
        drawer.add(JDPaletteFactory.createJDEntry(MFrame.getIconDescriptor(), MFrame.class));
        handler.addPaletteGroup(baseGroup.getId(), drawer);
        PaletteGroup otherGroup = JDPaletteFactory.getOtherElementsGroup();
        drawer = JDPaletteFactory.createGroup(paletteRoot, ignore, otherGroup.getName(), otherGroup.getImage());
        drawer.add(JDPaletteFactory.createJDEntry(MPageNumber.getIconDescriptor(), MPageNumber.class));
        drawer.add(JDPaletteFactory.createJDEntry(MTotalPages.getIconDescriptor(), MTotalPages.class));
        drawer.add(JDPaletteFactory.createJDEntry(MDate.getIconDescriptor(), MDate.class));
        drawer.add(JDPaletteFactory.createJDEntry(MTime.getIconDescriptor(), MTime.class));
        drawer.add(JDPaletteFactory.createJDEntry(MPercentage.getIconDescriptor(), MPercentage.class));
        drawer.add(JDPaletteFactory.createJDEntry(MPageXofY.getIconDescriptor(), MPageXofY.class));
        handler.addPaletteGroup(otherGroup.getId(), drawer);
        handler.createAllCompositeElements();
        CompositeElementManager.INSTANCE.addModifyListener(handler);
        return paletteRoot;
    }

    public static PaletteEntry createJDEntry(IIconDescriptor iconDescriptor, Class<?> aclass) {
        CombinedTemplateCreationEntry paletteEntry = new CombinedTemplateCreationEntry(iconDescriptor.getTitle(), iconDescriptor.getDescription(), aclass, (CreationFactory)new JDPaletteCreationFactory(aclass), iconDescriptor.getIcon16(), iconDescriptor.getIcon32());
        paletteEntry.setToolClass(JDCreationTool.class);
        return paletteEntry;
    }

    public static PaletteDrawer createElements(PaletteRoot paletteRoot, List<String> ignore, PaletteGroup p, Map<String, List<PaletteEntry>> map) {
        PaletteDrawer drawer = JDPaletteFactory.createGroup(paletteRoot, ignore, p.getName(), p.getImage());
        drawer.add(JDPaletteFactory.createJDEntry(MCallout.getIconDescriptor(), MCallout.class));
        drawer.add(JDPaletteFactory.createJDEntry(MTextField.getIconDescriptor(), MTextField.class));
        drawer.add(JDPaletteFactory.createJDEntry(MStaticText.getIconDescriptor(), MStaticText.class));
        drawer.add(JDPaletteFactory.createJDEntry(MImage.getIconDescriptor(), MImage.class));
        drawer.add(JDPaletteFactory.createJDEntry(MBreak.getIconDescriptor(), MBreak.class));
        drawer.add(JDPaletteFactory.createJDEntry(MRectangle.getIconDescriptor(), MRectangle.class));
        drawer.add(JDPaletteFactory.createJDEntry(MEllipse.getIconDescriptor(), MEllipse.class));
        drawer.add(JDPaletteFactory.createJDEntry(MLine.getIconDescriptor(), MLine.class));
        drawer.add(JDPaletteFactory.createJDEntry(MGenericElement.getIconDescriptor(), MGenericElement.class));
        drawer.add(JDPaletteFactory.createJDEntry(MFrame.getIconDescriptor(), MFrame.class));
        drawer.add(JDPaletteFactory.createJDEntry(MSubreport.getIconDescriptor(), MSubreport.class));
        JDPaletteFactory.getEntries4Key(drawer, ignore, p.getId(), map);
        return drawer;
    }

    public static PaletteDrawer createContainers(PaletteDrawer drawer, List<String> ignore, PaletteGroup p, Map<String, List<PaletteEntry>> map) {
        drawer.add(JDPaletteFactory.createJDEntry(MFrame.getIconDescriptor(), MFrame.class));
        drawer.add(JDPaletteFactory.createJDEntry(MSubreport.getIconDescriptor(), MSubreport.class));
        JDPaletteFactory.getEntries4Key(drawer, ignore, p.getId(), map);
        return drawer;
    }

    public static void createOtherElements(PaletteDrawer drawer, List<String> ignore, PaletteGroup p, Map<String, List<PaletteEntry>> map) {
        drawer.add(JDPaletteFactory.createJDEntry(MPageNumber.getIconDescriptor(), MPageNumber.class));
        drawer.add(JDPaletteFactory.createJDEntry(MTotalPages.getIconDescriptor(), MTotalPages.class));
        drawer.add(JDPaletteFactory.createJDEntry(MDate.getIconDescriptor(), MDate.class));
        drawer.add(JDPaletteFactory.createJDEntry(MTime.getIconDescriptor(), MTime.class));
        drawer.add(JDPaletteFactory.createJDEntry(MPercentage.getIconDescriptor(), MPercentage.class));
        drawer.add(JDPaletteFactory.createJDEntry(MPageXofY.getIconDescriptor(), MPageXofY.class));
        JDPaletteFactory.getEntries4Key(drawer, ignore, p.getId(), map);
    }

    public static PaletteDrawer createGroup(PaletteRoot paletteRoot, List<String> ignore, String name, ImageDescriptor imageDescriptor) {
        PaletteDrawer drawer = new PaletteDrawer(name, imageDescriptor);
        paletteRoot.add((PaletteEntry)drawer);
        return drawer;
    }

    private static void getEntries4Key(PaletteDrawer drawer, List<String> ignore, String id, Map<String, List<PaletteEntry>> map) {
        List<PaletteEntry> plist = map.get(id);
        if (plist != null) {
            for (PaletteEntry entry : plist) {
                if (ignore != null && entry instanceof CombinedTemplateCreationEntry && ignore.contains(((CombinedTemplateCreationEntry)entry).getTemplate().toString())) {
                    entry.setVisible(false);
                }
                drawer.add(entry);
            }
        }
    }
}

