/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.JRDefaultDataAdapterStorage;
import com.jaspersoft.studio.data.widget.DataAdapterAction;
import com.jaspersoft.studio.data.widget.IDataAdapterRunnable;
import com.jaspersoft.studio.editor.preview.IParametrable;
import com.jaspersoft.studio.editor.preview.IRunReport;
import com.jaspersoft.studio.editor.preview.MultiPageContainer;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.PreviewModeDetails;
import com.jaspersoft.studio.editor.preview.actions.RunStopAction;
import com.jaspersoft.studio.editor.preview.actions.SwitchViewsAction;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.toolbar.LeftToolBarManager;
import com.jaspersoft.studio.editor.preview.toolbar.PreviewTopToolBarManager;
import com.jaspersoft.studio.editor.preview.toolbar.TopToolBarManagerJRPrint;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.control.IReportRunner;
import com.jaspersoft.studio.editor.preview.view.control.ReportController;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.messages.MessagesByKeys;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import com.jaspersoft.studio.swt.widgets.CSashForm;
import com.jaspersoft.studio.utils.JRXMLUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.viewer.action.AReportAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomInAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomOutAction;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import net.sf.jasperreports.engine.design.events.CollectionElementRemovedEvent;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PreviewContainer
extends PreviewJRPrint
implements IDataAdapterRunnable,
IParametrable,
IRunReport {
    private AReportAction zoomInAction = null;
    private AReportAction zoomOutAction = null;
    private AReportAction zoomActualAction = null;
    private DataAdapterDescriptor dataAdapterDesc;
    protected boolean runWhenInitilizing = true;
    private ReportController reportControler;
    protected boolean isParameterDirty = true;
    protected boolean isRunDirty = true;
    private MultiPageContainer leftContainer;
    private CSashForm sashform;
    private LeftToolBarManager leftToolbar;
    private PropertyChangeListener propChangeListener;
    private String runMode;
    private Map<IReportRunner, APreview> runPreview = new HashMap<IReportRunner, APreview>();

    public PreviewContainer() {
        super(true);
    }

    public PreviewContainer(boolean listenResource, JasperReportsConfiguration jrContext) {
        super(listenResource);
        this.jrContext = jrContext;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    private void setActions() {
        IContributionItem[] iContributionItemArray = this.actionToolBarManager.getContributions();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (this.zoomInAction != null && this.zoomOutAction != null && this.zoomActualAction != null) {
                return;
            }
            if (ZoomInAction.ID.equals(item.getId()) && item instanceof ActionContributionItem) {
                this.zoomInAction = (AReportAction)((ActionContributionItem)item).getAction();
            } else if (ZoomOutAction.ID.equals(item.getId()) && item instanceof ActionContributionItem) {
                this.zoomOutAction = (AReportAction)((ActionContributionItem)item).getAction();
            } else if ("PreviewZoomActualAction".equals(item.getId()) && item instanceof ActionContributionItem) {
                this.zoomActualAction = (AReportAction)((ActionContributionItem)item).getAction();
            }
            ++n2;
        }
    }

    public AReportAction getZoomInAction() {
        this.setActions();
        return this.zoomInAction;
    }

    public AReportAction getZoomOutAction() {
        this.setActions();
        return this.zoomOutAction;
    }

    public AReportAction getZoomActualAction() {
        this.setActions();
        return this.zoomActualAction;
    }

    @Override
    protected void loadJRPrint(IEditorInput input) throws PartInitException {
        this.setJasperPrint(null, null);
        if (this.listenResource) {
            InputStream in = null;
            IFile file = null;
            try {
                try {
                    if (!(input instanceof IFileEditorInput)) {
                        throw new PartInitException("Invalid Input: Must be IFileEditorInput or FileStoreEditorInput");
                    }
                    file = ((IFileEditorInput)input).getFile();
                    in = file.getContents();
                    in = JRXMLUtils.getXML(this.jrContext, input, file.getCharset(true), in, null);
                    this.initJRContext(file);
                    this.jrContext.setJasperDesign(JRXmlLoader.load((JasperReportsContext)this.jrContext, (InputStream)in));
                    this.setJasperDesign(this.jrContext);
                }
                catch (Exception e) {
                    throw new PartInitException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new PartInitException("error closing input stream", (Throwable)e);
                    }
                }
            }
        }
    }

    public void refreshLeftContainer() {
        this.leftToolbar.refresh();
    }

    @Override
    public MultiPageContainer getLeftContainer() {
        if (this.leftContainer == null) {
            this.leftContainer = new MultiPageContainer(){

                @Override
                public void switchView(Statistics stats, APreview view) {
                    super.switchView(stats, view);
                    for (Map.Entry entry : this.pmap.entrySet()) {
                        if (entry.getValue() != view) continue;
                        PreviewContainer.this.leftToolbar.setLabelText(MessagesByKeys.getString((String)entry.getKey()));
                        break;
                    }
                }
            };
        }
        return this.leftContainer;
    }

    @Override
    public void dispose() {
        if (this.dataDapterToolBarManager instanceof PreviewTopToolBarManager) {
            ((PreviewTopToolBarManager)this.dataDapterToolBarManager).dispose();
        }
        super.dispose();
    }

    @Override
    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.jaspersoft.studio.doc.editor_preview");
        Composite toolbarContainer = new Composite(container, 0);
        toolbarContainer.setLayout((Layout)new GridLayout(3, false));
        GridData additionalToolbarGD = new GridData(4, 128, true, false);
        toolbarContainer.setLayoutData((Object)additionalToolbarGD);
        this.getDataAdapterToolBarManager(toolbarContainer);
        this.dataDapterToolBarManager.getTopToolBar().setLayoutData((Object)new GridData(4, 4, false, false));
        this.getActionToolBarManager(toolbarContainer);
        this.actionToolBarManager.getTopToolBar().setLayoutData((Object)new GridData(4, 4, true, false));
        Button lbutton = new Button(toolbarContainer, 8);
        lbutton.setLayoutData((Object)new GridData(131072, 128, false, false));
        lbutton.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/application-sidebar-expand.png"));
        lbutton.setToolTipText(Messages.PreviewContainer_buttonText);
        lbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewContainer.this.sashform.upRestore();
            }
        });
        this.sashform = new CSashForm(container, 256);
        GridData gd = new GridData(4, 4, true, true);
        this.sashform.setLayoutData(gd);
        this.createLeft(parent, this.sashform);
        this.createRight((Composite)this.sashform);
        this.sashform.setWeights(new int[]{40, 60});
    }

    @Override
    protected PreviewTopToolBarManager getDataAdapterToolBarManager(Composite container) {
        if (this.dataDapterToolBarManager == null) {
            IFile file = null;
            IProject project = null;
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                file = ((IFileEditorInput)editorInput).getFile();
            }
            if (this.jrContext != null) {
                project = (IProject)this.jrContext.get("iproject");
            }
            this.dataDapterToolBarManager = new PreviewTopToolBarManager(this, container, DataAdapterManager.getDataAdapter(file, project, this.jrContext));
        }
        return (PreviewTopToolBarManager)this.dataDapterToolBarManager;
    }

    @Override
    protected TopToolBarManagerJRPrint getActionToolBarManager(Composite container) {
        if (this.actionToolBarManager == null) {
            this.actionToolBarManager = new TopToolBarManagerJRPrint(this, container){

                @Override
                protected void fillToolbar(IToolBarManager tbManager) {
                    if (PreviewContainer.this.getMode().equals("RUNLOCAL")) {
                        if (this.pvModeAction == null) {
                            this.pvModeAction = new SwitchViewsAction(this.container.getRightContainer(), Messages.PreviewContainer_javatitle, true, PreviewContainer.this.getViewFactory());
                        }
                        tbManager.add((IAction)this.pvModeAction);
                    }
                    tbManager.add((IContributionItem)new Separator());
                }
            };
        }
        return this.actionToolBarManager;
    }

    @Override
    public void setCurrentViewer(String viewerKey, boolean refresh) {
        super.setCurrentViewer(viewerKey, refresh);
        this.actionToolBarManager.setActionText(viewerKey);
    }

    protected void createLeft(Composite parent, SashForm sf) {
        Composite leftComposite = new Composite((Composite)sf, 2048);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        leftComposite.setLayout((Layout)layout);
        this.leftToolbar = new LeftToolBarManager(this, leftComposite);
        this.setupDataAdapter();
        Composite cleftcompo = new Composite(leftComposite, 0);
        cleftcompo.setBackground(parent.getDisplay().getSystemColor(1));
        cleftcompo.setLayoutData((Object)new GridData(4, 4, true, true));
        cleftcompo.setLayout((Layout)new StackLayout());
        Composite bottom = new Composite(leftComposite, 0);
        bottom.setLayoutData((Object)new GridData(4, 4, true, false));
        bottom.setLayout((Layout)new GridLayout(1, false));
        ToolBar tb = new ToolBar(bottom, 8519936);
        tb.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        ActionContributionItem runStopToolItem = new ActionContributionItem((IAction)new RunStopAction(this));
        runStopToolItem.fill(tb, 0);
        ToolItem toolItem = new ToolItem(tb, 8);
        toolItem.setText(Messages.PreviewContainer_resetactiontitle);
        toolItem.setToolTipText(Messages.PreviewContainer_resetactiontooltip);
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewContainer.this.reportControler.resetParametersToDefault();
            }
        });
        tb.pack();
        this.getLeftContainer().populate(cleftcompo, this.getReportControler().createControls(cleftcompo));
        this.getLeftContainer().switchView(null, "report_configuration_inputParameters");
    }

    @Override
    protected Composite createRight(Composite parent) {
        super.createRight(parent);
        return this.rightComposite;
    }

    protected void auditPreview() {
        if (this.currentViewer != null) {
            String reportLanguage;
            JaspersoftStudioPlugin.getInstance().getUsageManager().audit(this.currentViewer, "PreviewFormat");
            if (this.jrContext != null && this.jrContext.getJasperDesign() != null && (reportLanguage = this.jrContext.getJasperDesign().getLanguage()) != null) {
                JaspersoftStudioPlugin.getInstance().getUsageManager().audit(reportLanguage, "Language");
            }
        }
    }

    @Override
    public boolean switchRightView(APreview view, Statistics stats, MultiPageContainer container) {
        this.reportControler.viewerChanged(view);
        return super.switchRightView(view, stats, container);
    }

    @Override
    public boolean runReport(DataAdapterDescriptor myDataAdapter, boolean daAction) {
        return this.runReport(myDataAdapter, this.isParameterDirty, daAction);
    }

    @Override
    public boolean runReport(DataAdapterDescriptor myDataAdapter, boolean prmDirty, boolean daAction) {
        if (this.isNotRunning()) {
            this.actionToolBarManager.setEnabled(false);
            this.dataDapterToolBarManager.setEnabled(false);
            this.leftToolbar.setEnabled(false);
            this.getLeftContainer().setEnabled(false);
            this.getLeftContainer().switchView(null, "report_configuration_inputParameters");
            if (myDataAdapter != null) {
                this.dataAdapterDesc = myDataAdapter;
                this.setParameterDirty(prmDirty);
            } else {
                DataAdapterAction daWidget = ((PreviewTopToolBarManager)this.dataDapterToolBarManager).getDataSourceWidget();
                this.dataAdapterDesc = daWidget.isDefaultDASelected() ? null : daWidget.getSelected();
            }
            this.addPreviewModeContributeProperties();
            this.reportControler.runReport();
            if ("Java".equals(this.currentViewer)) {
                this.auditPreview();
            }
        }
        return true;
    }

    private void addPreviewModeContributeProperties() {
        List<PreviewModeDetails> previewDetails = JaspersoftStudioPlugin.getExtensionManager().getAllPreviewModeDetails(Misc.nvl((String)this.getMode()));
        for (PreviewModeDetails d : previewDetails) {
            Map<String, String> previewModeProperties = d.getPreviewModeProperties();
            for (String pKey : previewModeProperties.keySet()) {
                String pValue = previewModeProperties.get(pKey);
                PreferencesUtils.storeJasperReportsProperty(pKey, pValue);
                DefaultJasperReportsContext.getInstance().setProperty(pKey, pValue);
            }
        }
        APreview view = null;
        if (ReportController.getRunners().containsKey(this.getMode())) {
            view = this.getRunnerViewer(ReportController.getRunners().get(this.getMode()));
            this.getRightContainer().switchView(null, view);
        } else if ("RUNLOCAL".equals(this.getMode())) {
            this.getRightContainer().switchView(null, this.getDefaultViewerKey());
            view = this.getDefaultViewer();
        }
        this.refreshToolbars(view);
    }

    protected void refreshToolbars(APreview view) {
        Display.getDefault().syncExec(() -> {
            if (this.actionToolBarManager != null) {
                this.actionToolBarManager.contributeItems(view);
            }
            this.actionToolBarManager.getTopToolBar().getParent().layout(true, true);
        });
    }

    @Override
    public void setNotRunning(boolean stoprun) {
        super.setNotRunning(stoprun);
        if (stoprun) {
            this.getLeftContainer().setEnabled(true);
            this.leftToolbar.setEnabled(true);
        }
    }

    @Override
    public void showParameters(boolean showprm) {
        if (this.sashform.isDisposed()) {
            return;
        }
        if (showprm) {
            this.sashform.upRestore();
        } else {
            this.sashform.upHide();
        }
    }

    public ReportController getReportControler() {
        if (this.reportControler == null) {
            this.reportControler = new ReportController(this, this.jrContext);
        }
        return this.reportControler;
    }

    public boolean isRunDirty() {
        return this.isParameterDirty;
    }

    public void setParameterDirty(boolean isParameterDirty) {
        this.isParameterDirty = isParameterDirty;
    }

    public void setRunDirty(boolean isRunDirty) {
        this.isRunDirty = isRunDirty;
        this.isParameterDirty = isRunDirty;
    }

    public void setJasperDesign(JasperReportsConfiguration jConfig) {
        UIUtils.getDisplay().asyncExec(() -> {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.jrContext.getClassLoader());
                this.getReportControler().setJrContext(jConfig);
                this.setupDataAdapter();
                if ((this.isRunDirty || this.getJasperPrint() == null) && this.runWhenInitilizing) {
                    this.runReport(this.dataAdapterDesc, false);
                }
                if (this.propChangeListener == null) {
                    this.propChangeListener = evt -> {
                        String pname = evt.getPropertyName();
                        if (pname.equals("parameters")) {
                            if (evt instanceof CollectionElementAddedEvent) {
                                ((JRDesignParameter)((CollectionElementAddedEvent)evt).getAddedValue()).getEventSupport().addPropertyChangeListener(this.propChangeListener);
                            } else if (evt instanceof CollectionElementRemovedEvent) {
                                ((JRDesignParameter)((CollectionElementRemovedEvent)evt).getRemovedValue()).getEventSupport().removePropertyChangeListener(this.propChangeListener);
                            }
                        }
                        if (evt.getSource() instanceof JRParameter) {
                            jConfig.getJRParameters().remove(((JRParameter)evt.getSource()).getName());
                        }
                        if (this.isParameterDirty) {
                            return;
                        }
                        if (evt.getSource() instanceof JRParameter || pname.equals("parameters") || pname.equals("scriptlets")) {
                            this.isParameterDirty = true;
                        }
                    };
                }
                JRDesignDataset mds = this.jrContext.getJasperDesign().getMainDesignDataset();
                mds.getEventSupport().removePropertyChangeListener(this.propChangeListener);
                mds.getEventSupport().addPropertyChangeListener(this.propChangeListener);
                for (JRParameter p : mds.getParametersList()) {
                    ((JRDesignParameter)p).getEventSupport().removePropertyChangeListener(this.propChangeListener);
                    ((JRDesignParameter)p).getEventSupport().addPropertyChangeListener(this.propChangeListener);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        });
    }

    private void setupDataAdapter() {
        JasperDesign jd = this.jrContext.getJasperDesign();
        PreviewTopToolBarManager pt = (PreviewTopToolBarManager)this.dataDapterToolBarManager;
        if (pt != null && jd != null) {
            String strda = jd.getProperty(this.jrContext.getEditorContext().getDataAdapterProperty());
            DataAdapterAction daWidget = ((PreviewTopToolBarManager)this.dataDapterToolBarManager).getDataSourceWidget();
            pt.refreshDataAdapters();
            if (strda != null) {
                pt.setDataAdapters(strda);
                this.dataAdapterDesc = daWidget.isDefaultDASelected() ? null : daWidget.getSelected();
            } else {
                JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(this.getConfiguration());
                DataAdapterDescriptor defaultDA = defaultStorage.getDefaultJRDataAdapter(jd.getMainDesignDataset());
                if (defaultDA != null) {
                    pt.setDataAdapters(defaultDA.getName());
                } else {
                    pt.setDataAdapters("One Empty Record");
                }
            }
        }
    }

    public DataAdapterDescriptor getDataAdapterDesc() {
        return this.dataAdapterDesc;
    }

    @Override
    public void setMode(String mode) {
        this.runMode = mode;
        if (ReportController.getRunners().containsKey(mode)) {
            this.getRightContainer().switchView(null, this.getRunnerViewer(ReportController.getRunners().get(mode)));
        } else if (mode.equals("RUNLOCAL")) {
            this.getRightContainer().switchView(null, this.getDefaultViewerKey());
        }
        this.refreshLeftContainer();
    }

    public String getMode() {
        if (this.runMode == null) {
            this.runMode = this.getJrContext().getEditorContext().getDefaultRunMode();
        }
        return this.runMode;
    }

    @Override
    public APreview getDefaultViewer() {
        String m = this.getMode();
        if (ReportController.getRunners().containsKey(m)) {
            return this.getRunnerViewer(ReportController.getRunners().get(m));
        }
        return super.getDefaultViewer();
    }

    public APreview getRunnerViewer(IReportRunner runner) {
        return this.runPreview.computeIfAbsent(runner, k -> runner.getPreview(this.rightComposite, this.jrContext));
    }

    @Override
    public void runReport() {
        DataAdapterAction daWidget = ((PreviewTopToolBarManager)this.dataDapterToolBarManager).getDataSourceWidget();
        daWidget.refreshDA();
        this.dataAdapterDesc = daWidget.isDefaultDASelected() ? null : daWidget.getSelected();
        this.runReport(this.dataAdapterDesc, false);
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
        if (dirty) {
            this.setRunDirty(true);
        }
    }

    @Override
    public JasperReportsConfiguration getConfiguration() {
        return this.jrContext;
    }

    public void setRunWhenInitilizing(boolean value) {
        this.runWhenInitilizing = value;
    }
}

