/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.element;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.empty.EmptyDataAdapterDescriptor;
import com.jaspersoft.studio.data.reader.DatasetReader;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.JRDefaultDataAdapterStorage;
import com.jaspersoft.studio.editor.preview.datasnapshot.DataSnapshotManager;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import net.sf.jasperreports.data.cache.DataSnapshotException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.viewer.BrowserUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ElementPreviewer {
    private Composite cmp;
    private Browser browser;
    private String previewTitle;
    private String previewMessage;
    private JasperDesign jd;
    private DatasetReader dr;

    public ElementPreviewer(Composite parent, String previewTitle, String previewMessage) {
        this.cmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.cmp.setLayout((Layout)layout);
        this.browser = BrowserUtils.getSWTBrowserWidget((Composite)this.cmp, (int)0);
        this.browser.setJavascriptEnabled(true);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.browser.setLayoutData((Object)gd);
        this.previewTitle = previewTitle;
        this.previewMessage = previewMessage;
    }

    public Composite getControl() {
        return this.cmp;
    }

    public String runReport(JasperReportsConfiguration jConf, JRElement element, boolean fromCache, IProgressMonitor monitor) {
        if (this.jd == null) {
            UIUtils.getDisplay().asyncExec(() -> {
                StringBuffer sb = new StringBuffer();
                sb.append("<!DOCTYPE html>").append("<html >").append("<head>").append("    <title>").append(this.previewTitle).append("</title>  ").append("    <style>").append("        .container{").append("            display: flex;").append("            align-items: center;").append("            justify-content: center;").append("            height:95%;").append("        }").append("        body, html{").append("            height:95%;").append("        }        ").append("        .loading { ").append("          font-size: 1.2em; ").append("          font-family: Georgia;").append("        }        ").append("    </style>").append("    <script>").append("        i = 0;").append("        setInterval(function() {").append("            i = ++i % 4;").append("            document.querySelector('.loading').innerHTML = \"").append(this.previewMessage).append("\" + Array(i+1).join(\".\");").append("        }, 800);").append("    </script>").append("</head>").append("<body>").append("    <div class=\"container\">").append("        <div class=\"loading\">").append(this.previewMessage).append("</div>").append("    </div>  ").append("</body>").append("</html>");
                this.browser.setText(sb.toString());
            });
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(jConf.getClassLoader());
        Map<String, Object> hm = null;
        JasperDesign jDesign = jConf.getJasperDesign();
        JasperReport jrobj = null;
        DataAdapterDescriptor da = null;
        try {
            if (this.jd == null) {
                JRStyle s;
                this.jd = this.getJasperDesign(jConf);
                this.jd.setUUID(jDesign.getUUID());
                JRStyle[] jRStyleArray = jDesign.getStyles();
                int n = jRStyleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    s = jRStyleArray[n2];
                    this.jd.addStyle(s);
                    ++n2;
                }
                jRStyleArray = jDesign.getTemplates();
                n = jRStyleArray.length;
                n2 = 0;
                while (n2 < n) {
                    s = jRStyleArray[n2];
                    this.jd.addTemplate((JRReportTemplate)s);
                    ++n2;
                }
            }
            this.setupDatasets(jConf, jDesign);
            this.replaceElement((JRDesignElement)element.clone(), this.jd);
            jrobj = DatasetReader.compile(jConf, this.jd, monitor);
            if (jrobj == null) {
                return null;
            }
            hm = DatasetReader.prepareParameters(jConf, 100);
            da = this.prepareDataAdapter(jConf, jDesign, hm);
            DataSnapshotManager.setDataSnapshot(hm, !fromCache);
            if (monitor.isCanceled()) {
                return null;
            }
            String string = this.doRunReport(jConf, hm, jDesign, jrobj, da);
            return string;
        }
        catch (DataSnapshotException e) {
            DataSnapshotManager.setDataSnapshot(hm, true);
            try {
                String string = this.doRunReport(jConf, hm, jDesign, jrobj, da);
                return string;
            }
            catch (Exception exception) {
                this.handleException((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return null;
    }

    protected void handleException(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String message = sw.getBuffer().toString();
        UIUtils.getDisplay().asyncExec(() -> {
            boolean bl = this.browser.setText("<HTML><BODY><pre>" + message + "</pre></body></html>");
        });
    }

    public void cancel() {
        if (this.dr != null) {
            this.dr.stop();
        }
    }

    protected String doRunReport(JasperReportsConfiguration jConf, Map<String, Object> hm, JasperDesign jDesign, JasperReport jrobj, DataAdapterDescriptor da) throws JRException, IOException {
        if (this.dr != null) {
            this.dr.stop();
        }
        this.dr = new DatasetReader();
        JasperPrint jrPrint = this.dr.fillReport(jConf, jDesign.getMainDesignDataset(), da, jrobj, hm);
        File destDir = FileUtils.createTempDir();
        String dest = new File(destDir, "index.html").getAbsolutePath();
        JasperExportManager.getInstance((JasperReportsContext)jConf).exportToHtmlFile(jrPrint, dest);
        System.out.println(dest);
        UIUtils.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            this.browser.setToolTipText(dest);
            String url = dest;
            if (UIUtils.isWindows()) {
                url = "file:///" + dest.replace("\\", "/");
            }
            this.browser.setUrl(url);
        });
        return dest;
    }

    protected void setupDatasets(JasperReportsConfiguration jConf, JasperDesign jDesign) throws JRException {
        JRDataset[] jRDatasetArray = this.jd.getDatasets();
        int n = jRDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRDataset ds = jRDatasetArray[n2];
            this.jd.removeDataset(ds);
            ++n2;
        }
        ArrayList<String> columns = new ArrayList<String>();
        JRField[] jRFieldArray = jDesign.getMainDataset().getFields();
        int n3 = jRFieldArray.length;
        n = 0;
        while (n < n3) {
            JRField f = jRFieldArray[n];
            columns.add(f.getName());
            ++n;
        }
        DatasetReader.setupDataset(this.jd, jDesign.getMainDesignDataset(), jConf, columns);
        jRFieldArray = jDesign.getDatasets();
        n3 = jRFieldArray.length;
        n = 0;
        while (n < n3) {
            JRField ds = jRFieldArray[n];
            this.jd.addDataset((JRDesignDataset)ds.clone());
            ++n;
        }
    }

    protected JasperDesign getJasperDesign(JasperReportsConfiguration jConfig) throws IOException, JRException {
        JasperDesign jasperDesign;
        FileInputStream is = null;
        try {
            String reportLocation = JaspersoftStudioPlugin.getInstance().getFileLocation("/resources/data.jrxml");
            is = new FileInputStream(reportLocation);
            JasperDesign tjd = JRXmlLoader.load((JasperReportsContext)jConfig, (InputStream)is);
            tjd.setLeftMargin(0);
            tjd.setRightMargin(0);
            tjd.setTopMargin(0);
            tjd.setBottomMargin(0);
            tjd.setTitle(null);
            tjd.setPageHeader(null);
            tjd.setColumnHeader(null);
            ((JRDesignSection)tjd.getDetailSection()).removeBand(0);
            tjd.setColumnFooter(null);
            tjd.setPageFooter(null);
            tjd.setLastPageFooter(null);
            tjd.setNoData(null);
            tjd.setBackground(null);
            tjd.setScriptletClass(null);
            tjd.setWhenNoDataType(WhenNoDataTypeEnum.ALL_SECTIONS_NO_DETAIL);
            JRScriptlet[] jRScriptletArray = tjd.getScriptlets();
            int n = jRScriptletArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRScriptlet s = jRScriptletArray[n2];
                tjd.removeScriptlet(s);
                ++n2;
            }
            jasperDesign = tjd;
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(is);
            throw throwable;
        }
        FileUtils.closeStream((Closeable)is);
        return jasperDesign;
    }

    public DataAdapterDescriptor prepareDataAdapter(JasperReportsConfiguration jConf, JasperDesign jDesign, Map<String, Object> hm) {
        return this.prepareDataAdapter(jConf, jDesign.getMainDesignDataset(), hm);
    }

    public DataAdapterDescriptor prepareDataAdapter(JasperReportsConfiguration jConf, JRDesignDataset jDataset, Map<String, Object> hm) {
        JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(jConf);
        DataAdapterDescriptor da = null;
        String defAdapter = jDataset.getPropertiesMap().getProperty("com.jaspersoft.studio.data.defaultdataadapter");
        if (defAdapter != null) {
            ADataAdapterStorage st;
            IFile f;
            da = defaultStorage.getDefaultJRDataAdapter(defAdapter);
            if (da == null) {
                da = DataAdapterManager.getPreferencesStorage().findDataAdapter(defAdapter);
            }
            if (da == null && (f = (IFile)jConf.get("ifile")) != null && (st = DataAdapterManager.getProjectStorage(f.getProject())) != null) {
                da = st.findDataAdapter(defAdapter);
            }
        }
        if (da == null) {
            da = defaultStorage.getDefaultJRDataAdapter(jDataset);
        }
        if (da == null) {
            da = new EmptyDataAdapterDescriptor();
        }
        return da;
    }

    protected void replaceElement(JRDesignElement element, JasperDesign jd) {
        JRDesignBand bs = (JRDesignBand)jd.getSummary();
        JRElement[] jRElementArray = bs.getElements();
        int n = jRElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRElement jrel = jRElementArray[n2];
            bs.removeElement((JRDesignElement)jrel);
            ++n2;
        }
        bs.addElement(element);
        element.setX(0);
        element.setY(0);
        UIUtils.getDisplay().syncExec(() -> {
            element.setWidth(Math.max(20, this.browser.getBounds().width - 20));
            element.setHeight(Math.max(20, this.browser.getBounds().height - 20));
        });
        jd.setPageHeight(element.getHeight());
        jd.setPageWidth(element.getWidth());
        jd.setColumnWidth(jd.getPageWidth());
        bs.setHeight(element.getHeight());
    }
}

