/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.ByteValidator;
import org.apache.commons.validator.routines.DoubleValidator;
import org.apache.commons.validator.routines.FloatValidator;
import org.apache.commons.validator.routines.IntegerValidator;
import org.apache.commons.validator.routines.ShortValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class BigNumericInput
extends ADataInput {
    private Text num;
    private Number min;
    private Number max;
    private boolean refresh = false;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return Number.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, final IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (Number.class.isAssignableFrom(param.getValueClass())) {
            this.num = new Text(parent, 133120);
            BigNumericInput.setMandatory(param, (Control)this.num);
            this.num.setToolTipText(VParameters.createToolTip(param));
            this.num.addFocusListener(this.focusListener);
            this.num.addTraverseListener(this.keyListener);
            this.updateInput();
            this.num.addListener(25, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        BigNumericInput.hideError((Control)BigNumericInput.this.num);
                        String number = e.text;
                        String oldText = ((Text)e.widget).getText();
                        if (e.start != e.end) {
                            oldText = String.valueOf(oldText.substring(0, e.start)) + oldText.substring(e.end);
                        }
                        number = String.valueOf(oldText.substring(0, e.start)) + e.text;
                        if (oldText.length() - 1 > e.start) {
                            number = String.valueOf(number) + oldText.substring(e.start);
                        }
                        if (number.equals("-")) {
                            number = "-0";
                        }
                        if (number.equals(".")) {
                            number = "0.";
                        }
                        if (number.isEmpty()) {
                            e.doit = true;
                            return;
                        }
                        if (param.getValueClass().equals(Long.class)) {
                            Long.parseLong(number);
                        } else if (param.getValueClass().equals(BigInteger.class)) {
                            new BigInteger(number);
                        } else if (param.getValueClass().equals(Float.class)) {
                            e.doit = FloatValidator.getInstance().isValid(number, Locale.US);
                        } else if (param.getValueClass().equals(Double.class)) {
                            e.doit = DoubleValidator.getInstance().isValid(number, Locale.US);
                        } else if (param.getValueClass().equals(Integer.class)) {
                            e.doit = IntegerValidator.getInstance().isValid(number, Locale.US);
                        } else if (param.getValueClass().equals(Short.class)) {
                            e.doit = ShortValidator.getInstance().isValid(number, Locale.US);
                        } else if (param.getValueClass().equals(Byte.class)) {
                            e.doit = ByteValidator.getInstance().isValid(number, Locale.US);
                        } else if (param.getValueClass().equals(BigDecimal.class)) {
                            e.doit = BigDecimalValidator.getInstance().isValid(number, Locale.US);
                        }
                        if (e.doit) {
                            if (BigNumericInput.this.min != null) {
                                if (param.isStrictMin()) {
                                    if (BigNumericInput.this.compareTo(BigNumericInput.this.getNumber(number), BigNumericInput.this.min) <= 0) {
                                        BigNumericInput.setError((Control)BigNumericInput.this.num, "Value can not be smaller than: " + BigNumericInput.this.min);
                                    }
                                } else if (BigNumericInput.this.compareTo(BigNumericInput.this.getNumber(number), BigNumericInput.this.min) < 0) {
                                    BigNumericInput.setError((Control)BigNumericInput.this.num, "Value can not be smaller than: " + BigNumericInput.this.min);
                                }
                            }
                            if (BigNumericInput.this.max != null) {
                                if (param.isStrictMax()) {
                                    if (BigNumericInput.this.compareTo(BigNumericInput.this.getNumber(number), BigNumericInput.this.max) >= 0) {
                                        BigNumericInput.setError((Control)BigNumericInput.this.num, "Value can not be greater than: " + BigNumericInput.this.max);
                                    }
                                } else if (BigNumericInput.this.compareTo(BigNumericInput.this.getNumber(number), BigNumericInput.this.max) > 0) {
                                    BigNumericInput.setError((Control)BigNumericInput.this.num, "Value can not be greater than: " + BigNumericInput.this.max);
                                }
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        e.doit = false;
                    }
                }
            });
            if (param.getMinValue() != null) {
                this.min = this.getNumber(param.getMinValue());
            }
            if (param.getMaxValue() != null) {
                this.max = this.getNumber(param.getMaxValue());
            }
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        if (BigNumericInput.this.refresh) {
                            return;
                        }
                        BigNumericInput.this.updateModel(BigNumericInput.this.getNumber(BigNumericInput.this.num.getText()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            };
            this.num.addModifyListener(listener);
            GridData gd = new GridData();
            gd.horizontalIndent = 8;
            gd.widthHint = 25 * BigNumericInput.getCharWidth((Control)this.num) - 22;
            this.num.setLayoutData((Object)gd);
            this.setNullable(param, (Control)this.num);
        }
    }

    protected int compareTo(Number n1, Number n2) {
        if (this.param.getValueClass().equals(Long.class)) {
            return ((Long)n1).compareTo((Long)n2);
        }
        if (this.param.getValueClass().equals(BigInteger.class)) {
            return ((BigInteger)n1).compareTo((BigInteger)n2);
        }
        if (this.param.getValueClass().equals(Float.class)) {
            return ((Float)n1).compareTo((Float)n2);
        }
        if (this.param.getValueClass().equals(Double.class)) {
            return ((Double)n1).compareTo((Double)n2);
        }
        if (this.param.getValueClass().equals(Integer.class)) {
            return ((Integer)n1).compareTo((Integer)n2);
        }
        if (this.param.getValueClass().equals(Short.class)) {
            return ((Short)n1).compareTo((Short)n2);
        }
        if (this.param.getValueClass().equals(Byte.class)) {
            return ((Byte)n1).compareTo((Byte)n2);
        }
        if (this.param.getValueClass().equals(BigDecimal.class)) {
            return ((BigDecimal)n1).compareTo((BigDecimal)n2);
        }
        return 0;
    }

    protected Number getNumber(String number) throws NumberFormatException {
        if (this.param.getValueClass().equals(Long.class)) {
            return new Long(number);
        }
        if (this.param.getValueClass().equals(BigInteger.class)) {
            return new BigInteger(number);
        }
        if (this.param.getValueClass().equals(Float.class)) {
            return new Float(number);
        }
        if (this.param.getValueClass().equals(Double.class)) {
            return new Double(number);
        }
        if (this.param.getValueClass().equals(Integer.class)) {
            return new Integer(number);
        }
        if (this.param.getValueClass().equals(Short.class)) {
            return new Short(number);
        }
        if (this.param.getValueClass().equals(Byte.class)) {
            return new Byte(number);
        }
        if (this.param.getValueClass().equals(BigDecimal.class)) {
            return new BigDecimal(number);
        }
        return null;
    }

    @Override
    public void updateInput() {
        if (this.num.isDisposed()) {
            return;
        }
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            value = this.getNumber((String)value);
        }
        try {
            this.refresh = true;
            if (value != null && value instanceof Number) {
                this.num.setText(BigNumericInput.getNumber((Number)value));
            } else {
                this.num.setText("");
            }
        }
        finally {
            this.refresh = false;
        }
        this.setDecoratorNullable(this.param);
    }

    public static String getNumber(Number value) {
        if (value == null) {
            return "";
        }
        String t = value.toString();
        if (value instanceof BigDecimal) {
            NumberFormat nformat = NumberFormat.getInstance(Locale.US);
            nformat.setGroupingUsed(false);
            nformat.setMaximumFractionDigits(Integer.MAX_VALUE);
            t = nformat.format(value);
        }
        return t;
    }

    public static Number getNumber(String number, String type) {
        try {
            Class<Number> clazz = Class.forName(type);
            if (clazz.isAssignableFrom(Integer.class)) {
                return new Integer(number);
            }
            if (clazz.isAssignableFrom(Short.class)) {
                return new Short(number);
            }
            if (clazz.isAssignableFrom(Byte.class)) {
                return new Byte(number);
            }
            if (clazz.isAssignableFrom(Long.class)) {
                return new Long(number);
            }
            if (clazz.isAssignableFrom(BigDecimal.class)) {
                return new BigDecimal(number);
            }
            if (clazz.isAssignableFrom(Double.class)) {
                return new Double(number);
            }
            if (clazz.isAssignableFrom(Float.class)) {
                return new Float(number);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

