/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.swt.widgets.WLocale;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.LocaleUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LocaleInput
extends ADataInput {
    private WLocale wlocal;
    private String tooltip;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return Locale.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (Locale.class.isAssignableFrom(param.getValueClass())) {
            this.wlocal = new WLocale(parent, 2052);
            this.tooltip = param.getDescription() != null ? String.valueOf(param.getDescription()) + "\n" : "";
            this.wlocal.setToolTipText(this.tooltip);
            this.wlocal.addFocusListener(this.focusListener);
            this.wlocal.addTraverseListener(this.keyListener);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            this.wlocal.setLayoutData(gd);
            this.updateInput();
            this.wlocal.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocaleInput.this.updateModel(LocaleInput.this.wlocal.getLocale());
                    LocaleInput.this.updateInput();
                }
            });
            Control[] controlArray = this.wlocal.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setNullable(param, c);
                ++n2;
            }
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            value = LocaleUtils.toLocale((String)((String)value));
        }
        if (value != null && value instanceof Locale) {
            Locale locale = (Locale)value;
            this.wlocal.setSelection(locale);
            this.wlocal.setToolTipText(String.valueOf(this.tooltip) + locale.toString());
        }
        this.setDecoratorNullable(this.param);
    }
}

