/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.IDataInput;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class PropertyChangeNotifier {
    private List<IDataInput> registeredInput = new ArrayList<IDataInput>();
    private boolean refreshing = false;
    private PropertyChangeListener inputListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!PropertyChangeNotifier.this.refreshing) {
                PropertyChangeNotifier.this.refreshing = true;
                for (IDataInput input : PropertyChangeNotifier.this.registeredInput) {
                    if (evt.getPropertyName().equals(input.getParameter().getName())) continue;
                    input.parameterChanged(evt);
                }
                PropertyChangeNotifier.this.refreshing = false;
            }
        }
    };

    public void addDataInput(IDataInput input) {
        input.addChangeListener(this.inputListener);
        this.registeredInput.add(input);
    }

    public void removeDataInput(IDataInput input) {
        input.removeChangeListener(this.inputListener);
        this.registeredInput.add(input);
    }
}

