/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input;

import com.jaspersoft.studio.editor.preview.input.ADataInput;
import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import java.util.Map;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextInput
extends ADataInput {
    private Text txt;
    private boolean isRefresh = false;

    @Override
    public boolean isForType(Class<?> valueClass) {
        return String.class.isAssignableFrom(valueClass);
    }

    @Override
    public void createInput(Composite parent, IParameter param, Map<String, Object> params) {
        super.createInput(parent, param, params);
        if (this.isForType(param.getValueClass())) {
            this.txt = new Text(parent, 2048);
            this.txt.setToolTipText(VParameters.createToolTip(param));
            this.txt.addFocusListener(this.focusListener);
            this.txt.addTraverseListener(this.keyListener);
            GridData gd = new GridData(768);
            gd.horizontalIndent = 8;
            this.txt.setLayoutData((Object)gd);
            TextInput.setMandatory(param, (Control)this.txt);
            ModifyListener listener = e -> {
                if (!this.isRefresh) {
                    this.updateModel(this.txt.getText());
                }
            };
            this.txt.addModifyListener(listener);
            this.updateInput();
            this.setNullable(param, (Control)this.txt);
        }
    }

    @Override
    public void updateInput() {
        Object value = this.params.get(this.param.getName());
        if (value != null && value instanceof String) {
            this.txt.setText((String)value);
        } else {
            this.isRefresh = true;
            this.txt.setText("");
            this.isRefresh = false;
        }
        this.setDecoratorNullable(this.param);
    }
}

