/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input.array;

import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.input.ParameterJasper;
import com.jaspersoft.studio.editor.preview.input.array.AWElement;
import com.jaspersoft.studio.editor.preview.input.array.BooleanElement;
import com.jaspersoft.studio.editor.preview.input.array.FileElement;
import com.jaspersoft.studio.editor.preview.input.array.ImageElement;
import com.jaspersoft.studio.editor.preview.input.array.StringElement;
import com.jaspersoft.studio.editor.preview.input.array.date.DateElement;
import com.jaspersoft.studio.editor.preview.input.array.date.SqlDateElement;
import com.jaspersoft.studio.editor.preview.input.array.date.TimeElement;
import com.jaspersoft.studio.editor.preview.input.array.date.TimestampElement;
import com.jaspersoft.studio.editor.preview.input.array.number.BigDecimalElement;
import com.jaspersoft.studio.editor.preview.input.array.number.BigIntegerElement;
import com.jaspersoft.studio.editor.preview.input.array.number.ByteElement;
import com.jaspersoft.studio.editor.preview.input.array.number.DoubleElement;
import com.jaspersoft.studio.editor.preview.input.array.number.FloatElement;
import com.jaspersoft.studio.editor.preview.input.array.number.IntegerElement;
import com.jaspersoft.studio.editor.preview.input.array.number.LongElement;
import com.jaspersoft.studio.editor.preview.input.array.number.ShortElement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementDialog
extends PersistentLocationDialog {
    private IParameter prm;
    private Map<String, AWElement> map = new LinkedHashMap<String, AWElement>();
    private String[] cvalues = null;
    private StackLayout stack;
    private Combo cmb;
    private AWElement current;
    private Composite cstack;

    public Object getValue() {
        if (this.current != null) {
            return this.current.getValue();
        }
        return null;
    }

    public void setValue(Object v) {
        for (AWElement key : this.map.values()) {
            if (!key.getSupportedType().isAssignableFrom(v.getClass())) continue;
            this.current = key;
            this.current.setValue(v);
            break;
        }
    }

    public void setType(Object v) {
        for (AWElement key : this.map.values()) {
            if (!key.getSupportedType().isAssignableFrom(v.getClass())) continue;
            this.current = key;
            break;
        }
    }

    public ElementDialog(Shell parentShell, IParameter prm) {
        super(parentShell);
        this.prm = prm;
        this.putMap(new StringElement());
        this.putMap(new ByteElement());
        this.putMap(new ShortElement());
        this.putMap(new IntegerElement());
        this.putMap(new LongElement());
        this.putMap(new BigIntegerElement());
        this.putMap(new FloatElement());
        this.putMap(new DoubleElement());
        this.putMap(new BigDecimalElement());
        this.putMap(new SqlDateElement());
        this.putMap(new TimestampElement());
        this.putMap(new TimeElement());
        this.putMap(new DateElement());
        this.putMap(new BooleanElement());
        this.putMap(new FileElement());
        this.putMap(new ImageElement());
    }

    private void putMap(AWElement widget) {
        Class<?> c = widget.getSupportedType();
        this.map.put(c.getCanonicalName(), widget);
    }

    private String[] getTypes() {
        if (this.cvalues == null) {
            Set<String> keySet = this.map.keySet();
            this.cvalues = keySet.toArray(new String[keySet.size()]);
        }
        return this.cvalues;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Parameter: " + this.prm.getName());
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        ((GridLayout)cmp.getLayout()).numColumns = 2;
        ((GridLayout)cmp.getLayout()).makeColumnsEqualWidth = false;
        Class c = ((ParameterJasper)this.prm).getParam().getNestedType();
        if (c != null) {
            for (AWElement key : this.map.values()) {
                if (!key.getSupportedType().isAssignableFrom(c)) continue;
                this.current = key;
                break;
            }
        }
        if (c == null || this.current == null) {
            new Label(cmp, 64).setText("Type");
            this.cmb = new Combo(cmp, 12);
            this.cmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementDialog.this.handleTypeChanged();
                }
            });
            String[] types = this.getTypes();
            this.cmb.setItems(types);
            if (this.current != null) {
                int i = 0;
                while (i < types.length) {
                    if (types[i].equals(this.current.getSupportedType().getCanonicalName())) {
                        this.cmb.select(i);
                        break;
                    }
                    ++i;
                }
            } else {
                this.cmb.select(0);
            }
        }
        this.cstack = new Composite(cmp, 0);
        this.stack = new StackLayout();
        this.stack.marginWidth = 0;
        this.stack.marginHeight = 0;
        this.cstack.setLayout((Layout)this.stack);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.cstack.setLayoutData((Object)gd);
        if (c != null && this.current != null) {
            this.current.create(this.cstack);
        } else {
            for (AWElement awe : this.map.values()) {
                awe.create(this.cstack);
            }
        }
        this.handleTypeChanged();
        return cmp;
    }

    private void handleTypeChanged() {
        AWElement awe = this.current;
        if (this.cmb != null) {
            awe = this.map.get(this.cmb.getText());
        }
        if (awe != null) {
            this.current = awe;
            this.stack.topControl = awe.getControl();
            this.cstack.layout();
            this.cstack.update();
        }
    }
}

