/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.input.map;

import com.jaspersoft.studio.editor.preview.input.IParameter;
import com.jaspersoft.studio.editor.preview.input.map.MapElementDialog;
import com.jaspersoft.studio.editor.preview.input.map.MapItem;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.EditButton;
import com.jaspersoft.studio.swt.widgets.table.IEditElement;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MapDialog
extends PersistentLocationDialog {
    private IParameter prm;
    private Table table;
    private TableViewer tableViewer;
    private Map<Object, Object> value;
    private Map<Object, Object> oldValue;
    private EditElement editElement;

    protected void setReturnCode(int code) {
        super.setReturnCode(code);
        if (code == 0) {
            List lst = (List)this.tableViewer.getInput();
            this.oldValue.clear();
            for (MapItem it : lst) {
                this.oldValue.put(it.key, it.value);
            }
        }
    }

    public Object getValue() {
        return this.oldValue;
    }

    public MapDialog(Shell parentShell, Map<Object, Object> value, IParameter prm) {
        super(parentShell);
        this.oldValue = value;
        if (value instanceof Map) {
            this.value = new HashMap<Object, Object>(value);
        }
        this.prm = prm;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Parameter: " + this.prm.getName());
    }

    protected Control createDialogArea(final Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        ((GridLayout)cmp.getLayout()).numColumns = 2;
        ((GridLayout)cmp.getLayout()).makeColumnsEqualWidth = false;
        Label lbl = new Label(cmp, 64);
        String prmDescription = this.prm.getDescription();
        lbl.setText(prmDescription != null ? prmDescription : "");
        lbl.setToolTipText(this.prm.getDescription());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        this.buildTable(cmp);
        Composite bGroup = new Composite(cmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            @Override
            public Object newElement(List<?> input, int pos) {
                int indx;
                MapElementDialog d = new MapElementDialog(parent.getShell(), MapDialog.this.prm);
                if (input != null && !input.isEmpty() && (indx = MapDialog.this.table.getSelectionIndex()) >= 0 && indx < input.size()) {
                    d.setType(input.get(indx));
                }
                if (d.open() == 0) {
                    return d.getValue();
                }
                return null;
            }
        });
        this.editElement = new EditElement();
        new EditButton<MapItem>().createEditButtons(bGroup, this.tableViewer, this.editElement);
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        return cmp;
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.heightHint = 350;
        gd.widthHint = 300;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        TableColumn[] column = new TableColumn[2];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText("Key");
        column[1] = new TableColumn(this.table, 0);
        column[1].setText("Value");
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.table.setLayout((Layout)tlayout);
        ArrayList<MapItem> lst = new ArrayList<MapItem>();
        for (Object key : this.value.keySet()) {
            lst.add(new MapItem(key, this.value.get(key)));
        }
        this.tableViewer.setInput(lst);
        this.table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                StructuredSelection s = (StructuredSelection)MapDialog.this.tableViewer.getSelection();
                ArrayList<MapItem> inlist = (ArrayList<MapItem>)MapDialog.this.tableViewer.getInput();
                if (inlist == null) {
                    inlist = new ArrayList<MapItem>();
                    MapDialog.this.tableViewer.setInput(inlist);
                }
                int index = -1;
                if (s.isEmpty()) {
                    return;
                }
                index = inlist.indexOf(s.getFirstElement());
                MapDialog.this.editElement.editElement((List<MapItem>)inlist, index);
                MapDialog.this.tableViewer.refresh();
                MapDialog.this.tableViewer.setSelection((ISelection)s);
                MapDialog.this.tableViewer.reveal(s.getFirstElement());
            }
        });
    }

    private final class EditElement
    implements IEditElement<MapItem> {
        private EditElement() {
        }

        @Override
        public void editElement(List<MapItem> input, int pos) {
            MapItem v = input.get(pos);
            if (v == null) {
                return;
            }
            MapElementDialog dialog = new MapElementDialog(MapDialog.this.table.getShell(), MapDialog.this.prm);
            dialog.setValue(v);
            if (dialog.open() == 0) {
                input.set(pos, dialog.getValue());
            }
        }
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            MapItem mi = (MapItem)element;
            switch (columnIndex) {
                case 0: {
                    return this.convert(mi.key);
                }
                case 1: {
                    return this.convert(mi.value);
                }
            }
            return "";
        }

        private String convert(Object obj) {
            if (obj != null) {
                if (obj instanceof Date) {
                    return new SimpleDateFormat().format(obj);
                }
                return obj.toString();
            }
            return "";
        }
    }
}

