/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.inputs.dialog;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.MoveT2TButtons;
import com.jaspersoft.studio.utils.EnumHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SortFieldSection {
    private List<JRSortField> inFields;
    private List<JRSortField> outFields;
    private List<JRParameter> prompts;
    private Table rightTable;
    private Table leftTable;
    private TableViewer rightTView;
    private TableViewer leftTView;
    private static final String[] orderEnumNames = EnumHelper.getEnumNames((NamedEnum[])SortOrderEnum.values(), NullEnum.NOTNULL);

    public Control createSortField(Composite tabFolder) {
        if (this.prompts != null) {
            for (JRParameter p : this.prompts) {
                if (!p.getName().equals("SORT_FIELDS")) continue;
                Composite composite = new Composite(tabFolder, 0);
                composite.setLayout((Layout)new GridLayout(4, false));
                composite.setBackground(tabFolder.getBackground());
                composite.setLayoutData((Object)new GridData(1808));
                this.leftTable = new Table(composite, 68098);
                this.leftTable.setBackground(tabFolder.getBackground());
                GridData gd = new GridData(1040);
                gd.widthHint = 150;
                this.leftTable.setLayoutData((Object)gd);
                this.leftTable.setHeaderVisible(true);
                TableColumn[] col = new TableColumn[]{new TableColumn(this.leftTable, 0)};
                col[0].setText(Messages.common_report_objects);
                col[0].pack();
                TableLayout tlayout = new TableLayout();
                tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
                this.leftTable.setLayout((Layout)tlayout);
                this.leftTView = new TableViewer(this.leftTable);
                this.leftTView.setContentProvider((IContentProvider)new ListContentProvider());
                this.leftTView.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
                Composite bGroup = new Composite(composite, 0);
                bGroup.setBackground(tabFolder.getBackground());
                bGroup.setLayout((Layout)new GridLayout(1, false));
                bGroup.setLayoutData((Object)new GridData(1040));
                this.rightTable = new Table(composite, 68098);
                this.rightTable.setBackground(tabFolder.getBackground());
                this.rightTable.setLayoutData((Object)new GridData(1808));
                this.rightTable.setHeaderVisible(true);
                col = new TableColumn[2];
                col[0] = new TableColumn(this.rightTable, 0);
                col[0].setText(Messages.SortFieldSection_sort_field);
                col[0].pack();
                col[0] = new TableColumn(this.rightTable, 0);
                col[0].setText(Messages.SortFieldSection_sort_order);
                col[0].pack();
                tlayout = new TableLayout();
                tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(65, true));
                tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35, true));
                this.rightTable.setLayout((Layout)tlayout);
                this.rightTView = new TableViewer(this.rightTable);
                this.rightTView.setContentProvider((IContentProvider)new ListContentProvider());
                this.rightTView.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
                this.attachCellEditors(this.rightTView, (Composite)this.rightTable);
                this.createOrderButtons(tabFolder, composite);
                new MoveT2TButtons().createButtons(bGroup, (ColumnViewer)this.leftTView, this.rightTView);
                return composite;
            }
        }
        return null;
    }

    private void attachCellEditors(final TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals("NAME")) {
                    return false;
                }
                return property.equals("ORDER");
            }

            public Object getValue(Object element, String property) {
                JRDesignSortField prop = (JRDesignSortField)element;
                if ("NAME".equals(property)) {
                    return prop.getName();
                }
                if ("ORDER".equals(property)) {
                    return EnumHelper.getEnumIndexByTranslatedName(orderEnumNames, (NamedEnum)prop.getOrderValue());
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                JRDesignSortField field = (JRDesignSortField)tableItem.getData();
                if ("NAME".equals(property)) {
                    field.setName((String)value);
                } else if ("ORDER".equals(property)) {
                    field.setOrder((SortOrderEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])SortOrderEnum.values(), (Object)value));
                }
                viewer.update(element, new String[]{property});
                viewer.refresh();
            }
        });
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), new ComboBoxCellEditor(parent, EnumHelper.getEnumNames((NamedEnum[])SortOrderEnum.values(), NullEnum.NOTNULL))});
        viewer.setColumnProperties(new String[]{"NAME", "ORDER"});
    }

    private void createOrderButtons(Composite tabFolder, Composite composite) {
        Composite bGroup = new Composite(composite, 0);
        bGroup.setBackground(tabFolder.getBackground());
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        new ListOrderButtons().createOrderButtons(bGroup, this.rightTView);
    }

    public void fillTable(final Composite tabFolder, final JasperDesign jDesign, List<JRParameter> prompts, final Map<String, Object> params) {
        this.prompts = prompts;
        if (prompts != null) {
            UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SortFieldSection.this.createSortField(tabFolder);
                    SortFieldSection.this.inFields = new ArrayList<JRSortField>();
                    List flist = jDesign.getFieldsList();
                    for (JRField f : flist) {
                        SortFieldSection.this.inFields.add((JRSortField)new JRDesignSortField(f.getName(), SortFieldTypeEnum.FIELD, SortOrderEnum.ASCENDING));
                    }
                    List vlist = jDesign.getVariablesList();
                    for (JRVariable f : vlist) {
                        SortFieldSection.this.inFields.add((JRSortField)new JRDesignSortField(f.getName(), SortFieldTypeEnum.VARIABLE, SortOrderEnum.ASCENDING));
                    }
                    SortFieldSection.this.leftTView.setInput(SortFieldSection.this.inFields);
                    Object obj = params.get("SORT_FIELDS");
                    if (obj == null || !(obj instanceof List)) {
                        SortFieldSection.this.outFields = new ArrayList<JRSortField>();
                        params.put("SORT_FIELDS", SortFieldSection.this.outFields);
                    } else {
                        SortFieldSection.this.outFields = (List)obj;
                    }
                    ArrayList<JRSortField> dlist = new ArrayList<JRSortField>();
                    for (JRSortField f : SortFieldSection.this.outFields) {
                        if (f.getType().equals((Object)SortFieldTypeEnum.FIELD) && jDesign.getFieldsMap().get(f.getName()) == null) {
                            dlist.add(f);
                        }
                        if (!f.getType().equals((Object)SortFieldTypeEnum.VARIABLE) || jDesign.getVariablesMap().get(f.getName()) != null) continue;
                        dlist.add(f);
                    }
                    SortFieldSection.this.outFields.removeAll(dlist);
                    SortFieldSection.this.rightTView.setInput(SortFieldSection.this.outFields);
                }
            });
        }
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (((JRSortField)element).getType().equals((Object)SortFieldTypeEnum.FIELD)) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MField.getIconDescriptor().getIcon16());
                    }
                    return JaspersoftStudioPlugin.getInstance().getImage(MVariable.getIconDescriptor().getIcon16());
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((JRSortField)element).getName();
                }
                case 1: {
                    return ((JRSortField)element).getOrderValue().getName();
                }
            }
            return "";
        }
    }
}

