/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.control;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.editor.preview.IParametrable;
import com.jaspersoft.studio.editor.preview.PreviewContainer;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.preview.datasnapshot.DataSnapshotManager;
import com.jaspersoft.studio.editor.preview.datasnapshot.JSSColumnDataCacheHandler;
import com.jaspersoft.studio.editor.preview.input.BigNumericInput;
import com.jaspersoft.studio.editor.preview.input.BooleanInput;
import com.jaspersoft.studio.editor.preview.input.DateInput;
import com.jaspersoft.studio.editor.preview.input.EnumInput;
import com.jaspersoft.studio.editor.preview.input.FileInput;
import com.jaspersoft.studio.editor.preview.input.IDataInput;
import com.jaspersoft.studio.editor.preview.input.ImageInput;
import com.jaspersoft.studio.editor.preview.input.LocaleInput;
import com.jaspersoft.studio.editor.preview.input.PatternInput;
import com.jaspersoft.studio.editor.preview.input.PropertyChangeNotifier;
import com.jaspersoft.studio.editor.preview.input.TextInput;
import com.jaspersoft.studio.editor.preview.input.TimeZoneInput;
import com.jaspersoft.studio.editor.preview.input.URLInput;
import com.jaspersoft.studio.editor.preview.input.array.CollectionInput;
import com.jaspersoft.studio.editor.preview.input.map.MapInput;
import com.jaspersoft.studio.editor.preview.stats.RecordCountScriptletFactory;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.control.AVParameters;
import com.jaspersoft.studio.editor.preview.view.control.IReportRunner;
import com.jaspersoft.studio.editor.preview.view.control.JRErrorHandler;
import com.jaspersoft.studio.editor.preview.view.control.JRMarkerErrorHandler;
import com.jaspersoft.studio.editor.preview.view.control.VBookmarks;
import com.jaspersoft.studio.editor.preview.view.control.VExporter;
import com.jaspersoft.studio.editor.preview.view.control.VParameters;
import com.jaspersoft.studio.editor.preview.view.control.VReportParameters;
import com.jaspersoft.studio.editor.preview.view.control.VSimpleErrorPreview;
import com.jaspersoft.studio.editor.preview.view.control.VSorting;
import com.jaspersoft.studio.editor.preview.view.report.IJRPrintable;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.execution.VirtualizerHelper;
import com.jaspersoft.studio.utils.Console;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.eclipse.builder.JasperReportCompiler;
import net.sf.jasperreports.eclipse.builder.JasperReportErrorHandler;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.SimpleReportContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.AsynchronousFillHandle;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.SimpleJasperReportSource;
import net.sf.jasperreports.engine.scriptlets.ScriptletFactory;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public class ReportController {
    public static final String ST_RECORDCOUNTER = "RECORDCOUNTER";
    public static final String ST_PAGECOUNT = "PAGECOUNT";
    public static final String ST_FILLINGTIME = "FILLINGTIME";
    public static final String ST_COMPILATIONTIME = "COMPILATIONTIME";
    public static final String ST_COMPILATIONTIMESUBREPORT = "COMPILATIONTIMESUBREPORT";
    public static final String ST_REPORTEXECUTIONTIME = "REPORTEXECUTIONTIME";
    public static final String ST_RUNTIMESTAMP = "RUNTIMESTAMP";
    public static final String ST_SNAPSHOT = "SNAPSHOT";
    public static final String ST_SNAPSHOT_FILE = "SNAPSHOT_FILE";
    public static final String FORM_SORTING = "report_configuration_sorting";
    public static final String FORM_BOOKMARKS = "report_configuration_bookmarks";
    public static final String FORM_EXPORTER = "report_configuration_exporterParameters";
    public static final String FORM_REPORT_PARAMETERS = "report_configuration_reportParameters";
    public static final String FORM_PARAMETERS = "report_configuration_inputParameters";
    public static final List<IDataInput> inputs = new ArrayList<IDataInput>();
    private static Map<String, IReportRunner> runners;
    private List<JRParameter> prompts;
    private Map<String, Object> jasperParameters;
    private LinkedHashMap<String, APreview> viewmap;
    private PreviewContainer pcontainer;
    private JasperReportsConfiguration jrContext;
    private VReportParameters prmRepInput;
    private Console c;
    private JasperReport jasperReport;
    private RecordCountScriptletFactory scfactory;
    private boolean finished = true;
    private Throwable fillError = null;
    private VParameters prmInput;
    private Statistics stats;
    public static final String ST_REPORTSIZE = "REPORTSIZE";
    public static final String ST_EXPORTTIME = "ST_EXPORTTIME";
    private JasperReportCompiler compiler;
    private IProgressMonitor pmonitor;

    static {
        inputs.add(new BooleanInput());
        inputs.add(new TextInput());
        inputs.add(new BigNumericInput());
        inputs.add(new DateInput());
        inputs.add(new LocaleInput());
        inputs.add(new FileInput());
        inputs.add(new URLInput());
        inputs.add(new PatternInput());
        inputs.add(new TimeZoneInput());
        inputs.add(new ImageInput());
        inputs.add(new CollectionInput());
        inputs.add(new MapInput());
        inputs.add(new EnumInput());
        List<IDataInput> ict = JaspersoftStudioPlugin.getInputControlTypeManager().getInputControlTypes();
        if (ict != null && !ict.isEmpty()) {
            inputs.addAll(ict);
        }
    }

    public static Map<String, IReportRunner> getRunners() {
        if (runners == null) {
            runners = new HashMap<String, IReportRunner>();
            for (IReportRunner r : JaspersoftStudioPlugin.getExtensionManager().getReportRunners()) {
                runners.put(r.getID(), r);
            }
        }
        return runners;
    }

    public ReportController(PreviewContainer pcontainer, JasperReportsConfiguration jrContext) {
        this.pcontainer = pcontainer;
        this.setJrContext(jrContext);
    }

    public JasperReportsConfiguration getJrContext() {
        return this.jrContext;
    }

    public void setJrContext(JasperReportsConfiguration jrContext) {
        this.jrContext = jrContext;
        if (jrContext.getJasperDesign() != null) {
            this.prompts = jrContext.getJasperDesign().getParametersList();
        }
        this.setParameters();
    }

    public void resetParametersToDefault() {
        if (this.prmInput != null && this.prmRepInput != null) {
            try {
                Map<String, Object> prms = this.jrContext.getJRParameters();
                if (prms == null) {
                    prms = new HashMap<String, Object>();
                    this.jrContext.setJRParameters(prms);
                }
                JRParameter[] jRParameterArray = this.jrContext.getJasperDesign().getParameters();
                int n = jRParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JRParameter p = jRParameterArray[n2];
                    if (!p.isSystemDefined()) {
                        prms.remove(p.getName());
                    }
                    ++n2;
                }
                ExpressionUtil.initBuiltInParameters(this.jrContext, this.jasperReport);
            }
            catch (Throwable e) {
                this.c.showConsole();
                this.c.clearConsole();
                this.c.addError(e, this.jrContext.getJasperDesign());
            }
            HashSet<String> toDel = new HashSet<String>();
            for (Map.Entry<String, Object> entry : this.jasperParameters.entrySet()) {
                if (entry.getValue() != null) continue;
                toDel.add(entry.getKey());
            }
            for (String key : toDel) {
                this.jasperParameters.remove(key);
            }
            this.prmInput.update();
            this.prmRepInput.update();
        }
    }

    private void setParameters() {
        this.jasperParameters = ReportController.resetParameters(this.jasperParameters, this.jrContext);
    }

    public static Map<String, Object> resetParameters(Map<String, Object> jrPrms, JasperReportsConfiguration jrContext) {
        Map<String, Object> existing = jrContext.getJRParameters();
        if (jrPrms == null) {
            jrPrms = new HashMap<String, Object>();
            if (existing != null) {
                jrPrms.putAll(jrContext.getJRParameters());
            }
            ReportController.setDefaultParameterValues(jrPrms, jrContext);
        } else {
            if (existing != null) {
                jrPrms.putAll(jrContext.getJRParameters());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (jrContext.getJasperDesign() != null) {
                List prm = jrContext.getJasperDesign().getParametersList();
                for (JRParameter p : prm) {
                    Object obj = jrPrms.get(p.getName());
                    if (ReportController.keepParameter(p.getName())) continue;
                    try {
                        if (obj == null || !p.getValueClass().isAssignableFrom(obj.getClass()) || !p.isForPrompting()) continue;
                        map.put(p.getName(), obj);
                    }
                    catch (Exception exception) {}
                }
            }
            jrPrms.clear();
            jrPrms.putAll(map);
        }
        jrPrms.remove("REPORT_MAX_COUNT");
        jrContext.setJRParameters(jrPrms);
        return jrPrms;
    }

    private static boolean keepParameter(String name) {
        return name.endsWith("_SCRIPTLET") || name.equals("REPORT_DATA_SOURCE") || name.equals("REPORT_CONNECTION") || name.startsWith("XML_") || name.startsWith("MONDRIAN_") || name.startsWith("XLSX_") || name.startsWith("XLS_") || name.startsWith("JSON_") || name.startsWith("HIBERNATE_") || name.startsWith("JPA_") || name.startsWith("CSV_") || name.startsWith("REPORT_CONTEXT") || name.contains("csv.source") || name.startsWith("XMLA_");
    }

    private static void setDefaultParameterValues(Map<String, Object> jasperParameters, JasperReportsConfiguration jrContext) {
        jasperParameters.remove("IS_IGNORE_PAGINATION");
        jasperParameters.remove("REPORT_MAX_COUNT");
        jasperParameters.remove("REPORT_LOCALE");
        jasperParameters.remove("REPORT_TIME_ZONE");
    }

    public LinkedHashMap<String, APreview> createControls(Composite composite) {
        this.viewmap = new LinkedHashMap();
        PropertyChangeNotifier sharedNotifier = new PropertyChangeNotifier();
        VParameters vprm = new VParameters(composite, this.jrContext, sharedNotifier);
        vprm.setPcontainer(this.pcontainer);
        this.viewmap.put(FORM_PARAMETERS, vprm);
        VReportParameters vrprm = new VReportParameters(composite, this.jrContext, sharedNotifier);
        vrprm.setPcontainer(this.pcontainer);
        this.viewmap.put(FORM_REPORT_PARAMETERS, vrprm);
        this.viewmap.put(FORM_SORTING, new VSorting(composite, this.jrContext));
        this.viewmap.put(FORM_BOOKMARKS, new VBookmarks(composite, this.jrContext, this.pcontainer));
        this.viewmap.put(FORM_EXPORTER, new VExporter(composite, this.jrContext));
        return this.viewmap;
    }

    private void fillForms() {
        UIUtils.getDisplay().syncExec(() -> {
            this.prmInput = (VParameters)this.viewmap.get(FORM_PARAMETERS);
            this.prmInput.createInputControls(this.prompts, this.jasperParameters);
        });
        this.prmInput.setDirty(false);
        UIUtils.getDisplay().asyncExec(() -> {
            this.prmRepInput = (VReportParameters)this.viewmap.get(FORM_REPORT_PARAMETERS);
            this.prmRepInput.createInputControls(this.prompts, this.jasperParameters);
            this.prmRepInput.setDirty(false);
            VSorting vs = (VSorting)this.viewmap.get(FORM_SORTING);
            vs.setJasperReports(this.jrContext.getJasperDesign(), this.prompts, this.jasperParameters);
        });
    }

    public void viewerChanged(APreview view) {
        VExporter vs = (VExporter)this.viewmap.get(FORM_EXPORTER);
        vs.setPreferencesPage(view);
    }

    public void runReport() {
        VSimpleErrorPreview errorView = ReportController.showErrorView(this.pcontainer);
        errorView.setMessage(Messages.ReportControler_generating);
        this.c = this.pcontainer.getConsole();
        this.c.showConsole();
        this.c.clearConsole();
        if (this.pcontainer.getMode().equals("RUNLOCAL")) {
            this.pcontainer.setJasperPrint(null, null);
        }
        this.fillError = null;
        this.jasperReport = null;
        this.stats = new Statistics();
        this.stats.startCount(ST_REPORTEXECUTIONTIME);
        this.c.addMessage(Messages.ReportControler_stats_start);
        this.pcontainer.setNotRunning(false);
        this.runJob(this.pcontainer);
    }

    public void finishReport(PreviewContainer pcontainer) {
        if (this.compiler != null && ((JRErrorHandler)this.compiler.getErrorHandler()).hasErrors()) {
            this.finishNotCompiledReport();
        } else {
            ReportController.finishCompiledReport(this.c, this.prmInput, pcontainer);
        }
    }

    private void finishNotCompiledReport() {
        UIUtils.getDisplay().asyncExec(() -> {
            MultiPageEditorPart mpe;
            IEditorPart[] editors;
            this.pcontainer.setNotRunning(true);
            if (this.pcontainer.getSite() instanceof MultiPageEditorSite && (editors = (mpe = ((MultiPageEditorSite)this.pcontainer.getSite()).getMultiPageEditor()).findEditors(mpe.getEditorInput())) != null && editors.length > 0) {
                UIUtils.showInformation((String)Messages.ReportControler_compilationerrors);
                mpe.setActiveEditor(editors[0]);
            }
        });
    }

    public static void finishCompiledReport(Console c, AVParameters prmInput, PreviewJRPrint pcontainer) {
        UIUtils.getDisplay().syncExec(() -> {
            boolean notprmfiled;
            if (!(pcontainer instanceof PreviewContainer) || runners.get(((PreviewContainer)pcontainer).getMode()) == null) {
                c.addMessage(Messages.ReportControler_msg_reportfinished);
            }
            pcontainer.setNotRunning(true);
            boolean bl = notprmfiled = prmInput != null && !prmInput.checkFieldsFilled();
            if (notprmfiled) {
                c.addMessage(Messages.ReportControler_msg_fillparameters);
                VSimpleErrorPreview errorView = ReportController.showErrorView(pcontainer);
                errorView.setMessage(Messages.ReportControler_msg_fillparameters);
                prmInput.setFocus();
                prmInput.setDirty(true);
            }
            if (pcontainer.isHideParameters() && pcontainer instanceof IParametrable) {
                ((IParametrable)((Object)pcontainer)).showParameters(notprmfiled);
            }
        });
        DataSnapshotManager.saveSnapshotIfExists(pcontainer.getJrContext().getJRParameters());
    }

    private void runJob(final PreviewContainer pcontainer) {
        this.fillError = null;
        Job job = new Job(String.valueOf(Messages.PreviewEditor_preview_a) + ": " + this.jrContext.getJasperDesign().getName() + Messages.PreviewEditor_preview_b){

            protected IStatus run(IProgressMonitor monitor) {
                block21: {
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    JasperDesign jd = null;
                    try {
                        Thread.currentThread().setContextClassLoader(ReportController.this.jrContext.getClassLoader());
                        IEditorInput editorInput = pcontainer.getEditorInput();
                        IFile file = null;
                        if (editorInput instanceof IFileEditorInput) {
                            file = ((IFileEditorInput)editorInput).getFile();
                        }
                        monitor.beginTask("Form initialisation", -1);
                        jd = ReportController.this.jrContext.getJasperDesign();
                        if (ReportController.this.jasperReport == null) {
                            ReportController.this.jasperReport = ReportController.this.compileJasperDesign(file, jd, monitor);
                        }
                        if (ReportController.this.jasperReport == null) break block21;
                        if (pcontainer.isRunDirty() || ReportController.this.prmInput == null) {
                            HashMap<String, Object> oldm = new HashMap<String, Object>(ReportController.this.jrContext.getJRParameters());
                            try {
                                ExpressionUtil.initBuiltInParameters(ReportController.this.jrContext, ReportController.this.jasperReport);
                            }
                            catch (Throwable e) {
                                ReportController.this.c.showConsole();
                                ReportController.this.c.clearConsole();
                                ReportController.this.c.addError(e, ReportController.this.jrContext.getJasperDesign());
                            }
                            Map<String, Object> pmap = ReportController.this.jrContext.getJRParameters();
                            for (Map.Entry entry : oldm.entrySet()) {
                                if (!pmap.containsKey(entry.getKey()) && !ReportController.keepParameter((String)entry.getKey())) continue;
                                pmap.put((String)entry.getKey(), entry.getValue());
                            }
                            if (ReportController.this.viewmap != null) {
                                ReportController.this.fillForms();
                            }
                        }
                        pcontainer.setRunDirty(false);
                        ReportController.this.c.startMessage(Messages.PreviewEditor_starting);
                        if (!ReportController.this.prmInput.checkFieldsFilled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        IReportRunner runner = runners.get(pcontainer.getMode());
                        if (runner == null) {
                            ReportController.this.setupDataAdapter(pcontainer);
                        }
                        HashSet<String> toRemove = new HashSet<String>();
                        for (String key : ReportController.this.jasperParameters.keySet()) {
                            JRParameter p = (JRParameter)jd.getParametersMap().get(key);
                            if (p == null || p.isSystemDefined() || p.isForPrompting() || ReportController.keepParameter(p.getName())) continue;
                            toRemove.add(p.getName());
                        }
                        for (String key : toRemove) {
                            ReportController.this.jasperParameters.remove(key);
                        }
                        if (runner != null) {
                            runner.run(pcontainer, file, ReportController.this.jasperReport, ReportController.this.jrContext, ReportController.this.jasperParameters, monitor);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        ReportController.this.setupVirtualizer(jd);
                        ReportController.this.setupRecordCounters();
                        ReportController.this.setupDataSnapshot();
                        ReportController.this.c.startMessage(Messages.ReportControler_msg_fillreports);
                        JaspersoftStudioPlugin.getExtensionManager().onRun(ReportController.this.jrContext, ReportController.this.jasperReport, ReportController.this.jasperParameters);
                        file.getProject().getLocation().toFile().getAbsolutePath();
                        String reportPath = file.getParent().getLocation().toFile().getAbsolutePath();
                        SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)reportPath);
                        SimpleJasperReportSource jrSource = SimpleJasperReportSource.from((JasperReport)ReportController.this.jasperReport, (String)reportPath, (RepositoryResourceContext)context);
                        AsynchronousFillHandle fh = AsynchronousFillHandle.createHandle((JasperReportsContext)ReportController.this.jrContext, (JasperReportSource)jrSource, new HashMap<String, Object>(ReportController.this.jasperParameters));
                        if (ReportController.this.fillReport(fh, monitor, pcontainer) == Status.CANCEL_STATUS) {
                            ReportController.this.cancelMessage();
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            ReportController.this.doneMessage();
                        }
                        catch (Throwable e) {
                            ReportController.this.errorMessage();
                            ReportController.showRunReport(ReportController.this.c, pcontainer, e, jd);
                        }
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                        monitor.done();
                        ReportController.this.finishReport(pcontainer);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    private JasperReport compileJasperDesign(IFile file, JasperDesign jd, IProgressMonitor monitor) throws CoreException {
        this.stats.startCount(ST_COMPILATIONTIME);
        this.c.startMessage(Messages.ReportControler_msg_compiling);
        if (this.compiler == null) {
            this.compiler = new JasperReportCompiler();
            this.compiler.setErrorHandler((JasperReportErrorHandler)new JRMarkerErrorHandler(this.c, file));
            IProject project = (IProject)this.jrContext.get("iproject");
            if (file != null) {
                project = file.getProject();
            }
            this.compiler.setProject(project);
            this.jrContext.getPropertyChangeSupport().addPropertyChangeListener(evt -> this.compiler.clean());
        } else {
            ((JRErrorHandler)this.compiler.getErrorHandler()).reset();
        }
        JasperReport jr = this.compiler.compileReport((JasperReportsContext)this.jrContext, jd, monitor);
        this.stats.endCount(ST_COMPILATIONTIME);
        if (((JRErrorHandler)this.compiler.getErrorHandler()).hasErrors()) {
            UIUtils.getDisplay().syncExec(() -> {
                VSimpleErrorPreview errorView = ReportController.showErrorView(this.pcontainer);
                errorView.setMessage(Messages.ReportControler_compilationerrors);
            });
        }
        this.doneMessage();
        return jr;
    }

    public void cancelMessage() {
        this.c.addMessage(Messages.ReportControler_CANCELED);
    }

    public void doneMessage() {
        this.c.addMessage(Messages.ReportControler_done);
    }

    public void errorMessage() {
        this.c.addMessage(Messages.ReportControler_error);
    }

    private void setupVirtualizer(JasperDesign jd) {
        this.c.startMessage(Messages.ReportControler_msg_setvirtualizer);
        VirtualizerHelper.setVirtualizer(jd, this.jrContext, this.jasperParameters);
        this.doneMessage();
    }

    private void setupDataAdapter(PreviewContainer pcontainer) throws JRException {
        this.c.startMessage(Messages.ReportControler_msg_setdataadapter);
        DataAdapterDescriptor daDesc = pcontainer.getDataAdapterDesc();
        if (daDesc != null) {
            this.jasperParameters.put("PARAMETER_DATA_ADAPTER", daDesc.getDataAdapter());
        }
        this.doneMessage();
    }

    public void stop() {
        if (this.pmonitor != null) {
            this.pmonitor.setCanceled(true);
        }
    }

    private IStatus fillReport(AsynchronousFillHandle fh, IProgressMonitor monitor, PreviewContainer pcontainer) throws Throwable {
        Assert.isTrue((fh != null ? 1 : 0) != 0);
        this.pmonitor = new SubProgressMonitor(monitor, -1, 4);
        IStatus retstatus = Status.OK_STATUS;
        try {
            try {
                this.pmonitor.beginTask(Messages.PreviewEditor_fill_report, -1);
                fh.addFillListener((FillListener)((IJRPrintable)((Object)this.getDefaultViewer())));
                PageGenerationListener pgListener = new PageGenerationListener();
                fh.addFillListener((FillListener)pgListener);
                fh.addListener((AsynchronousFilllListener)pgListener);
                this.stats.startCount(ST_FILLINGTIME);
                fh.startFill();
                this.finished = true;
                while (this.finished && this.fillError == null) {
                    if (this.pmonitor.isCanceled()) {
                        fh.cancellFill();
                        retstatus = Status.CANCEL_STATUS;
                        break;
                    }
                    Thread.sleep(500L);
                    this.pmonitor.worked(10);
                }
                if (this.fillError != null) {
                    throw new JRException(this.fillError);
                }
            }
            catch (OutOfMemoryError e) {
                pcontainer.setJasperPrint(this.stats, null);
                throw e;
            }
            catch (Throwable e) {
                this.handleFillException(e);
                throw e;
            }
        }
        finally {
            this.pmonitor.done();
        }
        return retstatus;
    }

    private void handleFillException(Throwable t) {
        this.fillError = t;
    }

    protected void setupRecordCounters() {
        this.scfactory = new RecordCountScriptletFactory();
        this.jrContext.setExtensions(ScriptletFactory.class, Collections.singletonList(this.scfactory));
    }

    private void finishUpdateViewer(PreviewContainer pcontainer, JasperPrint jPrint) {
        UIUtils.getDisplay().asyncExec(() -> {
            this.stats.endCount(ST_FILLINGTIME);
            if (jPrint != null) {
                this.stats.setValue(ST_PAGECOUNT, jPrint.getPages().size());
            }
            if (this.scfactory != null) {
                this.stats.setValue(ST_RECORDCOUNTER, this.scfactory.getRecordCount());
            }
            this.stats.endCount(ST_REPORTEXECUTIONTIME);
            APreview pv = this.getDefaultViewer();
            if (pv instanceof IJRPrintable) {
                try {
                    ((IJRPrintable)((Object)pv)).setJRPRint(this.stats, jPrint, true);
                    VBookmarks vs = (VBookmarks)this.viewmap.get(FORM_BOOKMARKS);
                    vs.setJasperPrint(jPrint);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            pcontainer.setJasperPrint(this.stats, jPrint);
            this.c.setStatistics(this.stats);
            this.finished = false;
        });
    }

    protected APreview getDefaultViewer() {
        return this.pcontainer.getDefaultViewer();
    }

    protected void setupDataSnapshot() {
        Date creationTimestamp;
        block13: {
            String fname;
            creationTimestamp = new Date();
            ReportContext rc = (ReportContext)this.jasperParameters.get("REPORT_CONTEXT");
            if (rc instanceof SimpleReportContext) {
                DataCacheHandler dch = (DataCacheHandler)rc.getParameterValue("net.sf.jasperreports.data.cache.handler");
                String msg = "No";
                if (dch != null && dch.getDataSnapshot() != null) {
                    msg = "Yes";
                    if (dch instanceof JSSColumnDataCacheHandler) {
                        creationTimestamp = ((JSSColumnDataCacheHandler)dch).getCreationTimestamp();
                    }
                    if (dch.isSnapshotPopulated()) {
                        this.jasperParameters.remove("PARAMETER_DATA_ADAPTER");
                    }
                }
                if (rc.getParameterValue("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT") != null) {
                    this.stats.setValue(ST_SNAPSHOT_FILE, rc.getParameterValue("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT"));
                }
                this.stats.setValue(ST_SNAPSHOT, msg);
            } else if (this.jasperReport.getProperty("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT") != null && !Misc.isNullOrEmpty((String)(fname = this.jasperReport.getProperty("net.sf.jasperreports.datasnapshot.SAVESNAPSHOT")))) {
                InputStream in = null;
                try {
                    try {
                        in = RepositoryUtil.getInstance((JasperReportsContext)this.jrContext).getInputStreamFromLocation(fname);
                        if (in != null) {
                            DataSnapshotManager.setCaching(this.jrContext.getJRParameters(), true);
                            DataSnapshotManager.loadSnapshot(this.jrContext, fname);
                            this.setupDataSnapshot();
                        }
                    }
                    catch (JRException jRException) {
                        FileUtils.closeStream(in);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.closeStream(in);
                    throw throwable;
                }
                FileUtils.closeStream((Closeable)in);
            }
        }
        this.stats.setValue(ST_RUNTIMESTAMP, creationTimestamp.toString());
    }

    public static void showRunReport(Console c, PreviewJRPrint pcontainer, Throwable e) {
        ReportController.showRunReport(c, pcontainer, e, null);
    }

    public static void showRunReport(Console c, PreviewJRPrint pcontainer, Throwable e, JasperDesign design) {
        c.addError(e, design);
        UIUtils.getDisplay().syncExec(() -> {
            VSimpleErrorPreview errorView = ReportController.showErrorView(pcontainer);
            errorView.setMessage(Messages.ReportControler_generatingerror);
        });
    }

    protected static VSimpleErrorPreview showErrorView(PreviewJRPrint pcontainer) {
        VSimpleErrorPreview errorView = pcontainer.getErrorView();
        pcontainer.getRightContainer().switchView(null, errorView);
        return errorView;
    }

    class PageGenerationListener
    implements AsynchronousFilllListener,
    FillListener {
        JasperPrint jrPrint;
        private boolean refresh = false;
        private boolean viewerset = false;

        PageGenerationListener() {
        }

        public void pageUpdated(JasperPrint arg0, int page) {
        }

        public void pageGenerated(JasperPrint arg0, int page) {
            this.jrPrint = arg0;
            if (page == 0) {
                UIUtils.getDisplay().syncExec(() -> {
                    ReportController.this.pcontainer.getRightContainer().switchView(ReportController.this.stats, ReportController.this.pcontainer.getDefaultViewer());
                    this.viewerset = true;
                });
            }
            if (this.refresh) {
                return;
            }
            this.refresh = true;
            UIUtils.getDisplay().asyncExec(() -> {
                ReportController.this.stats.endCount(ReportController.ST_FILLINGTIME);
                ReportController.this.stats.setValue(ReportController.ST_PAGECOUNT, page);
                if (ReportController.this.scfactory != null) {
                    ReportController.this.stats.setValue(ReportController.ST_RECORDCOUNTER, ReportController.this.scfactory.getRecordCount());
                }
                ReportController.this.stats.endCount(ReportController.ST_REPORTEXECUTIONTIME);
                ReportController.this.c.setStatistics(ReportController.this.stats);
                this.refresh = false;
            });
        }

        public void reportFinished(JasperPrint jPrint) {
            if (!this.viewerset) {
                UIUtils.getDisplay().syncExec(() -> ReportController.this.pcontainer.getRightContainer().switchView(ReportController.this.stats, ReportController.this.pcontainer.getDefaultViewer()));
            }
            this.jrPrint = jPrint;
            ReportController.this.finishUpdateViewer(ReportController.this.pcontainer, jPrint);
        }

        public void reportFillError(Throwable t) {
            ReportController.this.handleFillException(t);
        }

        public void reportCancelled() {
            if (this.jrPrint != null) {
                ReportController.this.finishUpdateViewer(ReportController.this.pcontainer, this.jrPrint);
            }
            ReportController.this.c.addMessage(Messages.PreviewEditor_report_fill_canceled);
        }
    }
}

