/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.control;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableLabelProvider;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.property.SetExpressionValueCommand;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.ErrorUtil;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.xml.SourceLocation;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class VErrorPreview
extends APreview {
    private static final String NL = System.getProperty("line.separator");
    private Label compilationTime;
    private Label fillingTime;
    private Label exportTime;
    private Label execTime;
    private Label totalPages;
    private Label fillSize;
    private Label recordCount;
    private Text tmessage;
    private Text terror;
    private StackLayout stackLayout;
    private Composite body;
    private Composite errorsComposite;
    private Composite statComposite;
    private TableViewer errorViewer;
    private ArrayList<String> errorList;
    private Action errAction;
    private Action statAction;
    private Action msgAction;
    private CTabFolder tabFolder;
    private static DecimalFormat df = new DecimalFormat("#.###");
    private List<Object> errors = new ArrayList<Object>();
    private List<Object> auxil = new ArrayList<Object>();
    private Label runTime;
    private Label snapshot;
    private Label snapshotFile;

    static {
        df.setRoundingMode(RoundingMode.HALF_UP);
    }

    public VErrorPreview(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
    }

    public void setReportContext(JasperReportsConfiguration jContext) {
        this.jContext = jContext;
    }

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        ToolBar topToolBar = new ToolBar(container, 8519744);
        topToolBar.setLayoutData((Object)new GridData(768));
        ToolBarManager tbManager = new ToolBarManager(topToolBar);
        this.msgAction = new Action(Messages.VErrorPreview_0){

            public void run() {
                VErrorPreview.this.stackLayout.topControl = VErrorPreview.this.tmessage;
                VErrorPreview.this.body.layout();
            }
        };
        tbManager.add((IAction)this.msgAction);
        this.errAction = new Action(Messages.VErrorPreview_errorsLabel){

            public void run() {
                VErrorPreview.this.stackLayout.topControl = VErrorPreview.this.errorsComposite;
                VErrorPreview.this.body.layout();
            }
        };
        tbManager.add((IAction)this.errAction);
        this.statAction = new Action(Messages.VErrorPreview_statisticsLabel){

            public void run() {
                VErrorPreview.this.stackLayout.topControl = VErrorPreview.this.statComposite;
                VErrorPreview.this.body.layout();
            }
        };
        tbManager.add((IAction)this.statAction);
        tbManager.update(true);
        topToolBar.pack();
        this.body = new Composite(container, 0);
        this.body.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.stackLayout.marginHeight = 0;
        this.body.setLayout((Layout)this.stackLayout);
        this.createMessages(this.body);
        this.createErrors(this.body);
        this.createStatistics(this.body);
        this.stackLayout.topControl = this.tmessage;
        this.body.layout();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.jaspersoft.studio.doc.view_reportstate");
        return container;
    }

    public void setFocus() {
        this.body.setFocus();
    }

    protected void createMessages(Composite composite) {
        this.tmessage = new Text(composite, 2824);
        this.tmessage.setFont(FontUtils.getEditorsFont(this.jContext));
    }

    protected void createErrors(Composite composite) {
        this.errorsComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.errorsComposite.setLayout((Layout)layout);
        this.tabFolder = new CTabFolder(this.errorsComposite, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        CTabItem itemTbl = new CTabItem(this.tabFolder, 0);
        itemTbl.setText(Messages.VErrorPreview_tableLabel);
        final Table wtable = new Table((Composite)this.tabFolder, 68356);
        wtable.setLayoutData((Object)new GridData(1808));
        wtable.setHeaderVisible(false);
        wtable.setLinesVisible(true);
        wtable.addListener(8, event -> {
            int sindex = wtable.getSelectionIndex();
            if (sindex < 0 || sindex > this.errors.size()) {
                return;
            }
            Object aux = this.auxil.get(sindex);
            if (aux instanceof JRExpression) {
                JasperDesign jd = this.jContext.getJasperDesign();
                JRExpressionCollector rc = JRExpressionCollector.collector((JasperReportsContext)this.jContext, (JRReport)jd);
                if (!VErrorPreview.openExpressionEditor(this.jContext, rc, (JRDesignDataset)jd.getMainDataset(), (JRDesignExpression)aux)) {
                    for (JRDataset d : jd.getDatasetsList()) {
                        if (!VErrorPreview.openExpressionEditor(this.jContext, rc, (JRDesignDataset)d, (JRDesignExpression)aux)) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                Object e = this.errors.get(sindex);
                if (e instanceof Throwable) {
                    UIUtils.showError((Throwable)((Throwable)e));
                }
            }
        });
        wtable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int sindex = wtable.getSelectionIndex();
                if (sindex < 0 || sindex > VErrorPreview.this.errors.size()) {
                    return;
                }
                Object aux = VErrorPreview.this.auxil.get(sindex);
                if (aux != null) {
                    if (aux instanceof JRDesignElement) {
                        SelectionHelper.setSelection((JRChild)((JRDesignElement)aux), true);
                    } else if (aux instanceof List) {
                        for (Object item : (List)aux) {
                            if (!(item instanceof JRDesignElement)) continue;
                            SelectionHelper.setSelection((JRChild)((JRDesignElement)item), true);
                        }
                    }
                }
            }
        });
        TableColumn[] col = new TableColumn[]{new TableColumn(wtable, 0)};
        col[0].setText(Messages.VErrorPreview_fieldNameLabel);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        wtable.setLayout((Layout)tlayout);
        this.errorViewer = new TableViewer(wtable);
        this.errorViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.errorViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                return JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/error_tsk.gif");
            }
        });
        CTabItem itemText = new CTabItem(this.tabFolder, 0);
        itemText.setText(Messages.VErrorPreview_textLabel);
        this.terror = new Text((Composite)this.tabFolder, 2824);
        itemText.setControl((Control)this.terror);
        itemTbl.setControl((Control)wtable);
        this.tabFolder.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                VErrorPreview.this.refreshTableCellWidth();
            }
        });
        this.tabFolder.setSelection(itemTbl);
    }

    private void refreshTableCellWidth() {
        Table wtable = this.errorViewer.getTable();
        TableColumn col = wtable.getColumns()[0];
        Rectangle area = this.tabFolder.getClientArea();
        Point preferredSize = wtable.computeSize(-1, -1);
        int width = area.width - 2 * wtable.getBorderWidth();
        if (preferredSize.y > area.height + wtable.getHeaderHeight()) {
            Point vBarSize = wtable.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = wtable.getSize();
        if (oldSize.x > area.width) {
            col.setWidth(width);
            wtable.setSize(area.width, area.height);
        } else {
            wtable.setSize(area.width, area.height);
            col.setWidth(width);
        }
    }

    public static boolean openExpressionEditor(JasperReportsConfiguration jContext, JRExpressionCollector reportCollector, JRDesignDataset dataset, JRDesignExpression exp) {
        SelectionHelper.getActiveJRXMLEditor();
        JRExpressionCollector datasetCollector = reportCollector.getCollector((JRDataset)dataset);
        List datasetExpressions = datasetCollector.getExpressions();
        for (JRExpression expr : datasetExpressions) {
            if (expr.getId() != exp.getId()) continue;
            if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                JRExpressionEditor wizard = new JRExpressionEditor();
                wizard.setExpressionContext(new ExpressionContext(dataset, jContext));
                wizard.setValue((JRDesignExpression)expr);
                WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(Display.getDefault().getActiveShell(), wizard);
                if (dialog.open() == 0) {
                    AbstractJRXMLEditor editor;
                    CommandStack cs;
                    JRDesignExpression e = wizard.getValue();
                    IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
                    if (activeJRXMLEditor instanceof AbstractJRXMLEditor && (cs = (CommandStack)(editor = (AbstractJRXMLEditor)activeJRXMLEditor).getAdapter(CommandStack.class)) != null) {
                        cs.execute((Command)new SetExpressionValueCommand((JRDesignExpression)expr, e.getText(), e.getValueClassName()));
                        jContext.getJasperDesign().getEventSupport().firePropertyChange("name", true, false);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void createStatistics(Composite parent) {
        this.statComposite = new Composite(parent, 2048);
        this.statComposite.setBackground(Display.getDefault().getSystemColor(1));
        this.statComposite.setBackgroundMode(2);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 20;
        layout.horizontalSpacing = 3;
        this.statComposite.setLayout((Layout)layout);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_compilationTimeLabel);
        this.compilationTime = new Label(this.statComposite, 1);
        this.compilationTime.setLayoutData((Object)new GridData(128));
        UIUtil.setBold((Control)this.compilationTime);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_secLabel);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_fillingTimeLabel);
        this.fillingTime = new Label(this.statComposite, 1);
        this.fillingTime.setLayoutData((Object)new GridData(128));
        UIUtil.setBold((Control)this.fillingTime);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_secLabel);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_exectutionTimeLabel);
        this.execTime = new Label(this.statComposite, 1);
        this.execTime.setLayoutData((Object)new GridData(128));
        UIUtil.setBold((Control)this.execTime);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_secLabel);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_exportTimeLabel);
        this.exportTime = new Label(this.statComposite, 1);
        this.exportTime.setLayoutData((Object)new GridData(128));
        UIUtil.setBold((Control)this.exportTime);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_secLabel);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_totalPagesLabel);
        this.totalPages = new Label(this.statComposite, 1);
        this.totalPages.setLayoutData((Object)new GridData(128));
        UIUtil.setBold((Control)this.totalPages);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_pagesLabel);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_processedRecordsLabel);
        this.recordCount = new Label(this.statComposite, 1);
        this.recordCount.setLayoutData((Object)new GridData(128));
        UIUtil.setBold((Control)this.recordCount);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_recordsLabel);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_fillSizeLabel);
        this.fillSize = new Label(this.statComposite, 1);
        this.fillSize.setLayoutData((Object)new GridData(128));
        UIUtil.setBold((Control)this.fillSize);
        new Label(this.statComposite, 0).setText(Messages.VErrorPreview_bytesLabel);
        new Label(this.statComposite, 0).setText("Data Queried At");
        this.runTime = new Label(this.statComposite, 1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.runTime.setLayoutData((Object)gd);
        UIUtil.setBold((Control)this.runTime);
        new Label(this.statComposite, 0).setText("Used Data From Snapshot");
        this.snapshot = new Label(this.statComposite, 1);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.snapshot.setLayoutData((Object)gd);
        new Label(this.statComposite, 0).setText("Data Snapshot File");
        this.snapshotFile = new Label(this.statComposite, 1);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.snapshotFile.setLayoutData((Object)gd);
        this.setStats(null);
    }

    public void setStats(Statistics stats) {
        if (this.compilationTime.isDisposed()) {
            return;
        }
        if (stats != null) {
            this.compilationTime.setText(VErrorPreview.format(stats.getDuration("COMPILATIONTIME")));
            this.fillingTime.setText(VErrorPreview.format(stats.getDuration("FILLINGTIME")));
            this.exportTime.setText(VErrorPreview.format(stats.getDuration("ST_EXPORTTIME")));
            this.execTime.setText(VErrorPreview.format(stats.getDuration("REPORTEXECUTIONTIME")));
            this.totalPages.setText(Misc.nvl((Object)stats.getValue("PAGECOUNT"), (String)"0"));
            this.recordCount.setText(Misc.nvl((Object)stats.getValue("RECORDCOUNTER"), (String)"-"));
            this.fillSize.setText(Misc.nvl((Object)stats.getValue("REPORTSIZE"), (String)"0"));
            this.runTime.setText(Misc.nvl((Object)stats.getValue("RUNTIMESTAMP"), (String)""));
            this.snapshot.setText(Misc.nvl((Object)stats.getValue("SNAPSHOT"), (String)"No"));
            this.snapshotFile.setText(Misc.nvl((Object)stats.getValue("SNAPSHOT_FILE"), (String)""));
            this.statAction.run();
        } else {
            this.compilationTime.setText("-");
            this.fillingTime.setText("-");
            this.exportTime.setText("-");
            this.totalPages.setText("-");
            this.recordCount.setText("-");
            this.fillSize.setText("-");
            this.runTime.setText("");
            this.snapshot.setText("");
            this.snapshotFile.setText("");
        }
        this.statComposite.layout();
    }

    public static String format(long time) {
        return df.format((double)time / 1000.0);
    }

    public void setMessage(String msg) {
        this.tmessage.setText(msg);
    }

    public void addMessage(String msg) {
        this.tmessage.setText(String.valueOf(this.tmessage.getText()) + msg + NL);
    }

    public void startMessage(String msg) {
        this.tmessage.setText(String.valueOf(this.tmessage.getText()) + msg);
    }

    public void addError(Throwable t, JasperDesign design) {
        if (t != null) {
            if (t instanceof InvocationTargetException) {
                t = t.getCause();
            }
            String msg = String.valueOf(this.terror.getText()) + ErrorUtil.getStackTrace(t) + NL;
            this.terror.setText(String.valueOf(this.terror.getText()) + msg + NL);
            String stylesErrorString = Messages.VErrorPreview_1;
            String m = t.getMessage();
            if (m != null && m.contains(stylesErrorString) && design != null) {
                String stylesNotFound = m.substring(m.indexOf(stylesErrorString) + stylesErrorString.length());
                String[] styleNames = stylesNotFound.split(",");
                HashSet<String> styles = new HashSet<String>();
                String[] stringArray = styleNames;
                int n = styleNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    styles.add(name.trim());
                    ++n2;
                }
                List<JRDesignElement> elements = this.getNotReferencedStyles((JRChild[])design.getAllBands(), styles);
                this.addError2List(t, m, elements);
            } else {
                this.addError2List(t, m, null);
            }
        } else {
            this.terror.setText("");
        }
        this.refreshErrorTable();
    }

    private List<JRDesignElement> getNotReferencedStyles(JRChild[] childs, HashSet<String> styles) {
        ArrayList<JRDesignElement> result = new ArrayList<JRDesignElement>();
        JRChild[] jRChildArray = childs;
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            String styleName;
            JRChild child = jRChildArray[n2];
            if (child instanceof JRDesignElement && (styleName = this.getElementStyle((JRDesignElement)child)) != null && styles.contains(styleName)) {
                result.add((JRDesignElement)child);
            }
            if (child instanceof JRElementGroup) {
                JRElementGroup group = (JRElementGroup)child;
                List<JRDesignElement> value = this.getNotReferencedStyles((JRChild[])group.getElements(), styles);
                result.addAll(value);
            }
            ++n2;
        }
        return result;
    }

    private String getElementStyle(JRDesignElement jrElement) {
        if (jrElement.getStyleNameReference() != null) {
            return jrElement.getStyleNameReference();
        }
        JRStyle actualStyle = jrElement.getStyle();
        return actualStyle != null ? actualStyle.getName() : null;
    }

    protected void refreshErrorTable() {
        if (!this.getErrorList().isEmpty()) {
            this.errAction.run();
        }
        this.errAction.setText(String.valueOf(Messages.VErrorPreview_errorsFoundLabel) + this.getErrorList().size() + ")");
        this.errorViewer.refresh();
    }

    public void addProblem(IProblem problem, SourceLocation location) {
        this.addError2List(problem, problem.getMessage(), null);
        this.refreshErrorTable();
    }

    public void addProblem(IProblem problem, SourceLocation location, JRExpression expr) {
        this.addError2List(problem, problem.getMessage(), expr);
        this.refreshErrorTable();
    }

    public void addProblem(String message, SourceLocation location, JRDesignElement element) {
        this.addError2List(message, message, element);
        this.refreshErrorTable();
    }

    public void addProblem(String message, SourceLocation location) {
        this.addError2List(message, message, null);
        this.refreshErrorTable();
    }

    private void addError2List(Object err, String message, Object aux) {
        String[] lines;
        this.errors.add(err);
        this.auxil.add(aux);
        if (message == null) {
            message = Messages.VErrorPreview_noMessageLabel;
        }
        if ((lines = message.split("\\r?\\n")).length > 0) {
            message = lines[0];
        }
        this.getErrorList().add(message);
    }

    private List<String> getErrorList() {
        if (this.errorList == null) {
            this.errorList = new ArrayList();
            this.errorViewer.setInput(this.errorList);
        }
        return this.errorList;
    }

    public void clear() {
        this.auxil.clear();
        this.errors.clear();
        this.msgAction.run();
        this.tmessage.setText("");
        this.errorList = new ArrayList();
        this.errorViewer.setInput(this.errorList);
        this.setStats(null);
        this.addError(null, null);
        this.refreshTableCellWidth();
    }

    @Override
    public void dispose() {
    }
}

