/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.control;

import com.jaspersoft.studio.editor.preview.PreviewContainer;
import com.jaspersoft.studio.editor.preview.input.BooleanNumericInput;
import com.jaspersoft.studio.editor.preview.input.IDataInput;
import com.jaspersoft.studio.editor.preview.input.ParameterJasper;
import com.jaspersoft.studio.editor.preview.input.PropertyChangeNotifier;
import com.jaspersoft.studio.editor.preview.view.control.AVParameters;
import com.jaspersoft.studio.editor.preview.view.control.ReportController;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VParameters
extends AVParameters {
    private PropertyChangeNotifier propertyChangeNotifier;
    protected boolean isSystem = false;
    private Map<String, Object> params;
    private List<JRParameter> prompts;
    private Job defaultNonDirtyJob;
    private Job defaultJob;
    private PreviewContainer pcontainer;

    public VParameters(Composite parent, JasperReportsConfiguration jContext, PropertyChangeNotifier propertyChangeNotifier) {
        super(parent, jContext);
        this.propertyChangeNotifier = propertyChangeNotifier;
    }

    protected void createInputControls(List<JRParameter> prompts, Map<String, Object> params) {
        this.params = params;
        this.prompts = prompts;
        HashMap<String, Boolean> dirtyMap = new HashMap<String, Boolean>();
        for (String key : this.incontrols.keySet()) {
            IDataInput control = (IDataInput)this.incontrols.get(key);
            dirtyMap.put(key, control.isDirty());
            this.propertyChangeNotifier.removeDataInput(control);
        }
        this.incontrols.clear();
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        boolean first = true;
        if (prompts != null) {
            for (JRParameter p : prompts) {
                if (!this.isParameterToShow(p)) continue;
                try {
                    boolean created = this.createInput(this.composite, (JRDesignParameter)p, this.params, first);
                    if (!first || !created) continue;
                    first = false;
                    Boolean b = (Boolean)dirtyMap.get(p.getName());
                    if (b == null) continue;
                    ((IDataInput)this.incontrols.get(p.getName())).setDirty(b);
                }
                catch (Exception e) {
                    if (e instanceof ClassNotFoundException) continue;
                    e.printStackTrace();
                }
            }
        }
        if (this.defaultJob != null) {
            this.defaultJob.cancel();
        }
        if (this.defaultNonDirtyJob != null) {
            this.defaultNonDirtyJob.cancel();
        }
        if (this.showEmptyParametersWarning) {
            this.setDirty(false);
        }
        this.showEmptyParametersWarning = false;
        this.refreshControl();
    }

    public void setupDefaultValuesNonDirty() {
        this.defaultNonDirtyJob = new Job(Messages.VParameters_calculate_default_values){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.VParameters_resetparameters, -1);
                ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(VParameters.this.jContext.getClassLoader());
                    JRDesignDataset mDataset = (JRDesignDataset)VParameters.this.jContext.getJasperDesign().getMainDataset();
                    HashSet<String> keys = new HashSet<String>();
                    for (String pname : new HashSet(VParameters.this.incontrols.keySet())) {
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        JRParameter p = (JRParameter)mDataset.getParametersMap().get(pname);
                        if (p == null || !VParameters.this.isSystem && p.isSystemDefined() || VParameters.this.isSystem && !p.isSystemDefined() || !p.getName().equals(pname) || VParameters.this.params.get(pname) != null) continue;
                        if (p.getDefaultValueExpression() != null) {
                            VParameters.this.params.put(pname, ExpressionUtil.cachedExpressionEvaluation(p.getDefaultValueExpression(), VParameters.this.jContext));
                        } else {
                            VParameters.this.params.remove(pname);
                        }
                        keys.add(pname);
                    }
                    VParameters.this.updateControlInput(keys);
                }
                finally {
                    monitor.done();
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                return Status.OK_STATUS;
            }
        };
        this.defaultNonDirtyJob.setPriority(20);
        this.defaultNonDirtyJob.schedule();
    }

    public void setupDefaultValues() {
        this.defaultJob = new Job(Messages.VParameters_calculate_default_values){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.VParameters_resetparameters, -1);
                ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(VParameters.this.jContext.getClassLoader());
                    JRDesignDataset mDataset = (JRDesignDataset)VParameters.this.jContext.getJasperDesign().getMainDataset();
                    HashSet<String> keys = new HashSet<String>();
                    for (String pname : new HashSet(VParameters.this.incontrols.keySet())) {
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        JRParameter p = (JRParameter)mDataset.getParametersMap().get(pname);
                        if (p == null || !VParameters.this.isSystem && p.isSystemDefined() || VParameters.this.isSystem && !p.isSystemDefined() || !p.getName().equals(pname)) continue;
                        if (p.getDefaultValueExpression() != null) {
                            VParameters.this.params.put(pname, ExpressionUtil.cachedExpressionEvaluation(p.getDefaultValueExpression(), VParameters.this.jContext));
                        } else {
                            VParameters.this.params.remove(pname);
                        }
                        keys.add(pname);
                    }
                    VParameters.this.updateControlInput(keys);
                }
                finally {
                    monitor.done();
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                return Status.OK_STATUS;
            }
        };
        this.defaultJob.setPriority(20);
        this.defaultJob.schedule();
    }

    private void updateControlInput(Set<String> keys) {
        UIUtils.getDisplay().syncExec(() -> {
            for (String pname : keys) {
                IDataInput di = (IDataInput)this.incontrols.get(pname);
                if (di == null) continue;
                di.updateInput();
            }
        });
    }

    public void update() {
        for (IDataInput di : this.incontrols.values()) {
            di.updateInput();
        }
    }

    protected boolean isParameterToShow(JRParameter p) {
        return p.isForPrompting() && !p.isSystemDefined();
    }

    @Override
    public boolean checkFieldsFilled() {
        String show = this.jContext.getProperty("com.jaspersoft.studio.ic.SHOWIC", "always");
        if (show.equals("never")) {
            return true;
        }
        boolean defaultExists = false;
        int count = 0;
        if (this.prompts != null) {
            for (JRParameter p : this.prompts) {
                String pname = p.getName();
                if (!p.isForPrompting() || p.isSystemDefined() || !this.incontrols.containsKey(pname)) continue;
                if (p.getDefaultValueExpression() != null) {
                    defaultExists = true;
                }
                ++count;
                if (!this.params.containsKey(pname) && !((IDataInput)this.incontrols.get(pname)).isRemoved() || !((IDataInput)this.incontrols.get(pname)).isDirty()) continue;
                return true;
            }
        }
        if (count > 0) {
            return defaultExists && show.equals("allEmpty");
        }
        return true;
    }

    private void createControl(Composite sectionClient, ParameterJasper pres, IDataInput in, JRDesignParameter p, boolean first) {
        this.incontrols.put(p.getName(), in);
        this.createVerticalSeprator(first);
        this.createLabel(sectionClient, pres, in);
        in.createInput(sectionClient, pres, this.params);
        this.propertyChangeNotifier.addDataInput(in);
        in.setPcontainer(this.pcontainer);
    }

    protected boolean createInput(Composite sectionClient, JRDesignParameter p, Map<String, Object> params, boolean first) throws ClassNotFoundException {
        ParameterJasper pres = new ParameterJasper(p, this.jContext);
        if (p.getName().equals("REPORT_MAX_COUNT")) {
            this.createControl(sectionClient, pres, new BooleanNumericInput(), p, first);
            return true;
        }
        for (IDataInput in : ReportController.inputs) {
            if (!in.isForType(pres.getValueClass())) continue;
            IDataInput input = in.getInstance();
            this.createControl(sectionClient, pres, input, p, first);
            return true;
        }
        return false;
    }

    public void setPcontainer(PreviewContainer pcontainer) {
        this.pcontainer = pcontainer;
        for (IDataInput in : this.incontrols.values()) {
            in.setPcontainer(pcontainer);
        }
    }
}

