/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.report.file;

import com.jaspersoft.studio.editor.preview.actions.export.AExportAction;
import com.jaspersoft.studio.editor.preview.actions.export.ExportMenuAction;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.IPreferencePage;
import com.jaspersoft.studio.editor.preview.view.report.ExportMenu;
import com.jaspersoft.studio.editor.preview.view.report.IJRPrintable;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.ReportViewer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AFileViewer
extends APreview
implements IJRPrintable,
IPreferencePage {
    private ReportViewer rptviewer;
    private Text txt;
    private AExportAction expAction;
    private JasperPrint jrprint;

    public AFileViewer(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
    }

    protected AExportAction createExporterAction(ReportViewer rptv) {
        if (this.expAction == null) {
            this.expAction = this.createExporter(rptv);
        }
        return this.expAction;
    }

    protected abstract AExportAction createExporter(ReportViewer var1);

    protected abstract String getExtension();

    protected Text getTextControl() {
        return this.txt;
    }

    @Override
    public void contribute2ToolBar(IToolBarManager tmanager) {
        super.contribute2ToolBar(tmanager);
        if (this.jrprint != null) {
            ExportMenuAction exportMenu = ExportMenu.getExportMenu((IReportViewer)this.rptviewer, this.jContext);
            this.setDefaultExporter(exportMenu, this.createExporterAction(this.rptviewer));
            tmanager.add((IAction)exportMenu);
        }
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.txt = new Text(composite, 2826);
        this.txt.setLayoutData((Object)new GridData(1808));
        this.rptviewer = new ReportViewer((JasperReportsContext)this.jContext);
        return composite;
    }

    @Override
    public JasperPrint getJrPrint() {
        return this.jrprint;
    }

    @Override
    public void setJRPRint(Statistics stats, JasperPrint jrprint) throws Exception {
        this.setJRPRint(stats, jrprint, false);
    }

    @Override
    public void setJRPRint(final Statistics stats, final JasperPrint jrprint, boolean refresh) throws Exception {
        if (this.jrprint == null || this.jrprint != jrprint || refresh) {
            this.rptviewer.setReport(jrprint);
            Job job = new Job(Messages.AExportAction_exportreport){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        File tmpFile = File.createTempFile("report", AFileViewer.this.getExtension());
                        AExportAction exp = AFileViewer.this.createExporterAction(AFileViewer.this.rptviewer);
                        stats.startCount("ST_EXPORTTIME");
                        exp.doPreview(tmpFile, jrprint, monitor);
                        stats.endCount("ST_EXPORTTIME");
                        stats.setValue("REPORTSIZE", tmpFile.length());
                        final String content = FileUtils.readFileAsAString((File)tmpFile);
                        UIUtils.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).AFileViewer.this.txt.setText(content);
                            }
                        });
                    }
                    catch (IOException e) {
                        UIUtils.showError((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        this.jrprint = jrprint;
    }
}

