/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.report.swt;

import com.jaspersoft.studio.editor.preview.actions.export.AExportAction;
import com.jaspersoft.studio.editor.preview.actions.export.ExportAsJasperReportsAction;
import com.jaspersoft.studio.editor.preview.actions.export.ExportMenuAction;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.APreview;
import com.jaspersoft.studio.editor.preview.view.IPreferencePage;
import com.jaspersoft.studio.editor.preview.view.report.ExportMenu;
import com.jaspersoft.studio.editor.preview.view.report.IJRPrintable;
import com.jaspersoft.studio.editor.preview.view.report.swt.action.ExportImageAction;
import com.jaspersoft.studio.editor.preview.view.report.swt.action.FirstPageAction;
import com.jaspersoft.studio.editor.preview.view.report.swt.action.LastPageAction;
import com.jaspersoft.studio.editor.preview.view.report.swt.action.NextPageAction;
import com.jaspersoft.studio.editor.preview.view.report.swt.action.PageNumberContributionItem;
import com.jaspersoft.studio.editor.preview.view.report.swt.action.PreviousPageAction;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.ReportViewer;
import net.sf.jasperreports.eclipse.viewer.action.ZoomActualSizeAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomComboContributionItem;
import net.sf.jasperreports.eclipse.viewer.action.ZoomFitPageAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomFitPageWidthAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomInAction;
import net.sf.jasperreports.eclipse.viewer.action.ZoomOutAction;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SWTViewer
extends APreview
implements IJRPrintable,
IPreferencePage {
    protected ReportViewer rptviewer;
    private AExportAction expAction;
    protected JasperPrint jrprint;
    private boolean refresh = false;
    private JasperPrint lastJR;
    private int lastPage;

    public SWTViewer(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
    }

    protected AExportAction createExporterAction(ReportViewer rptv) {
        if (this.expAction == null) {
            this.expAction = this.createExporter(rptv);
        }
        return this.expAction;
    }

    protected AExportAction createExporter(ReportViewer rptv) {
        return new ExportAsJasperReportsAction((IReportViewer)this.rptviewer, this.jContext, null);
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.rptviewer = new ReportViewer((JasperReportsContext)this.jContext);
        Control ctrl = this.rptviewer.createControl(composite);
        ctrl.setLayoutData((Object)new GridData(4, 4, true, true));
        return composite;
    }

    @Override
    public void contribute2ToolBar(IToolBarManager tmanager) {
        super.contribute2ToolBar(tmanager);
        tmanager.add((IAction)new FirstPageAction((IReportViewer)this.rptviewer));
        tmanager.add((IAction)new PreviousPageAction((IReportViewer)this.rptviewer));
        tmanager.add((IContributionItem)new PageNumberContributionItem((IReportViewer)this.rptviewer));
        tmanager.add((IAction)new NextPageAction((IReportViewer)this.rptviewer));
        tmanager.add((IAction)new LastPageAction((IReportViewer)this.rptviewer));
        tmanager.add((IContributionItem)new Separator());
        tmanager.add((IAction)new ZoomInAction((IReportViewer)this.rptviewer));
        tmanager.add((IAction)new ZoomOutAction((IReportViewer)this.rptviewer));
        tmanager.add((IContributionItem)new ZoomComboContributionItem((IReportViewer)this.rptviewer));
        tmanager.add((IAction)new ZoomFitPageWidthAction((IReportViewer)this.rptviewer));
        tmanager.add((IAction)new ZoomFitPageAction((IReportViewer)this.rptviewer));
        tmanager.add((IAction)new ZoomActualSizeAction((IReportViewer)this.rptviewer));
        tmanager.add((IContributionItem)new Separator());
        tmanager.add((IAction)new ExportImageAction((IReportViewer)this.rptviewer));
        tmanager.add((IContributionItem)new Separator());
        ExportMenuAction exportMenu = ExportMenu.getExportMenu((IReportViewer)this.rptviewer, this.jContext);
        this.setDefaultExporter(exportMenu, this.createExporterAction(this.rptviewer));
        tmanager.add((IAction)exportMenu);
    }

    @Override
    public JasperPrint getJrPrint() {
        return this.jrprint;
    }

    @Override
    public void setJRPRint(Statistics stats, JasperPrint jrprint) throws Exception {
        this.setJRPRint(stats, jrprint, false);
    }

    @Override
    public void setJRPRint(Statistics stats, JasperPrint jrprint, boolean refresh) {
        this.rptviewer.setPageIndex(Math.max(0, this.rptviewer.getPageIndex()));
        this.doUpdatePage(jrprint, this.rptviewer.getPageIndex());
    }

    public void pageGenerated(JasperPrint arg0, int page) {
        this.doUpdatePage(arg0, page);
    }

    public void pageUpdated(JasperPrint arg0, int page) {
        if (this.rptviewer.getPageIndex() == page) {
            this.doUpdatePage(arg0, page);
        }
    }

    private void doUpdatePage(JasperPrint arg0, int page) {
        if (this.refresh) {
            this.lastJR = arg0;
            this.lastPage = page;
            return;
        }
        this.lastJR = null;
        this.refresh = true;
        UIUtils.getDisplay().asyncExec(() -> {
            this.rptviewer.setReport(arg0, page);
            this.jrprint = arg0;
            this.refresh = false;
            if (this.lastJR != null) {
                this.doUpdatePage(this.lastJR, this.lastPage);
            }
        });
    }

    public void setPageNumber(int page) {
        UIUtils.getDisplay().asyncExec(() -> this.rptviewer.setPageIndex(page));
    }

    @Override
    public PreferencePage getPreferencePage() {
        return null;
    }
}

