/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.report.swt.action;

import com.jaspersoft.studio.messages.Messages;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.viewer.IReportViewer;
import net.sf.jasperreports.eclipse.viewer.IReportViewerListener;
import net.sf.jasperreports.eclipse.viewer.ReportViewerEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PageNumberContributionItem
extends ContributionItem {
    private IReportViewer viewer;
    private Text text;
    private ToolItem toolitem;
    private IReportViewerListener viewListener = new IReportViewerListener(){

        public void viewerStateChanged(ReportViewerEvent evt) {
            PageNumberContributionItem.this.refresh();
        }
    };
    private SelectionListener selListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (PageNumberContributionItem.this.isRefresh) {
                return;
            }
            if (PageNumberContributionItem.this.viewer.hasReport()) {
                PageNumberContributionItem.this.setPageNumber(PageNumberContributionItem.this.text.getText());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private static int start = Messages.PageNumberContributionItem_page.indexOf("{0}");
    private boolean isRefresh = false;

    public PageNumberContributionItem(IReportViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        viewer.addReportViewerListener(this.viewListener);
    }

    void refresh() {
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        boolean hasDoc = this.viewer.hasReport();
        this.text.setEnabled(hasDoc);
        this.setText(hasDoc ? this.getPageMofNText() : MessageFormat.format(Messages.PageNumberContributionItem_page, "....", "...."));
    }

    private Control createControl(Composite parent) {
        this.text = new Text(parent, 0x1000800);
        this.text.addSelectionListener(this.selListener);
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String t;
                int end;
                if (PageNumberContributionItem.this.isRefresh) {
                    return;
                }
                if (e.start < start) {
                    e.doit = false;
                    PageNumberContributionItem.this.text.setSelection(start);
                }
                if (e.end > (end = (t = PageNumberContributionItem.this.text.getText().substring(start)).indexOf(" ") + start) + 1) {
                    e.doit = false;
                    PageNumberContributionItem.this.text.setSelection(end - 1);
                }
                if (!Character.isDigit(e.character) && e.character != '\b' && e.character != '\u007f' && e.character != '\r') {
                    e.doit = false;
                    return;
                }
                if (e.character == '\u007f' && !Character.isDigit(PageNumberContributionItem.this.text.getText().charAt(e.start))) {
                    e.doit = false;
                }
            }
        });
        this.refresh();
        this.text.pack();
        return this.text;
    }

    private void setText(String txt) {
        this.isRefresh = true;
        Point oldSel = this.text.getSelection();
        this.text.setText(txt);
        this.text.setSelection(oldSel);
        this.isRefresh = false;
    }

    private void setPageNumber(String pageText) {
        pageText = pageText.substring(start);
        pageText = pageText.substring(0, pageText.indexOf(" ")).trim();
        try {
            final int pageIndex = Integer.parseInt(pageText);
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    PageNumberContributionItem.this.viewer.setPageIndex(pageIndex - 1);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {}
        this.setText(this.getPageMofNText());
    }

    private String getPageMofNText() {
        int count = this.viewer.getReport().getPages().size();
        int page = Math.min(count, this.viewer.getPageIndex() + 1);
        return MessageFormat.format(Messages.PageNumberContributionItem_page, new Integer(page), new Integer(count));
    }

    public void dispose() {
        this.viewer.removeReportViewerListener(this.viewListener);
        this.text = null;
        this.viewer = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setWidth(control.getSize().x);
        this.toolitem.setControl(control);
    }
}

