/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.preview.view.report.system;

import com.jaspersoft.studio.editor.preview.actions.export.AExportAction;
import com.jaspersoft.studio.editor.preview.stats.Statistics;
import com.jaspersoft.studio.editor.preview.view.report.swt.SWTViewer;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperPrint;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;

public abstract class ASystemViewer
extends SWTViewer {
    public ASystemViewer(Composite parent, JasperReportsConfiguration jContext) {
        super(parent, jContext);
    }

    protected abstract String getExtension(JasperPrint var1);

    @Override
    public void setJRPRint(Statistics stats, JasperPrint jrprint, boolean refresh) {
        super.setJRPRint(stats, jrprint, refresh);
        if (jrprint != null) {
            try {
                String ext = this.getExtension(jrprint);
                AExportAction exp = this.createExporterAction(this.rptviewer);
                String fname = jrprint.getProperty("com.jaspersoft.studio.exporter.filename");
                if (Misc.isNullOrEmpty((String)fname)) {
                    fname = "report";
                }
                File tmpFile = File.createTempFile(fname, ext);
                stats.startCount("ST_EXPORTTIME");
                UIUtils.getDisplay().asyncExec(() -> {
                    try {
                        exp.preview(tmpFile, jrprint, value -> {
                            stats.endCount("ST_EXPORTTIME");
                            stats.setValue("REPORTSIZE", tmpFile.length());
                            Program p = Program.findProgram((String)ext);
                            if (p != null) {
                                p.execute(tmpFile.getAbsolutePath());
                            } else {
                                UIUtils.showWarning((String)String.format(Messages.ASystemViewer_1, ext, tmpFile.getAbsolutePath()));
                            }
                        });
                    }
                    catch (Exception e) {
                        UIUtils.showError((Throwable)e);
                    }
                });
            }
            catch (Exception e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }
}

