/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.IJROBjectEditor;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.ExpressionEditorSupportUtil;
import com.jaspersoft.studio.editor.name.NamedSubeditor;
import com.jaspersoft.studio.editor.part.MultiPageToolbarEditorPart;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.editor.report.ReportEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.style.StyleTemplateFactory;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.properties.Activator;
import com.jaspersoft.studio.properties.view.ITabbedPropertySheetPageContributor;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.descriptor.expression.dialog.JRExpressionEditor;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

public class ReportContainer
extends MultiPageToolbarEditorPart
implements ITabbedPropertySheetPageContributor,
IJROBjectEditor,
CachedSelectionProvider {
    public static final String SELECTION_CACHE_KEY = "SELECTION_CACHE_PROVIDER";
    public static final String CLOSE_EDITOR_PROPERTY = "closeElementEditor";
    public static final String RENAME_EDITOR_PROPERTY = "renamedElementEditor";
    private boolean editBackgroundImage = false;
    private INode model = null;
    private List<AbstractVisualEditor> editors = new ArrayList<AbstractVisualEditor>();
    private Map<Object, AbstractVisualEditor> ccMap = new HashMap<Object, AbstractVisualEditor>();
    private ExtensionManager m = JaspersoftStudioPlugin.getExtensionManager();
    private CommonSelectionCacheProvider selectionCache;
    private EditorPart parent;
    private PropertyChangeSupport propertyChangeSupport;
    private JasperReportsConfiguration jrContext;
    private PropertyChangeListener modelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractVisualEditor obj;
            String propertyName = evt.getPropertyName();
            if (propertyName.equals(ReportContainer.CLOSE_EDITOR_PROPERTY)) {
                AbstractVisualEditor obj2 = ReportContainer.this.ccMap.get(evt.getSource());
                if (obj2 != null) {
                    ReportContainer.this.removeEditorPage(evt, obj2);
                }
            } else if (propertyName.equals(ReportContainer.RENAME_EDITOR_PROPERTY)) {
                AbstractVisualEditor obj3 = ReportContainer.this.ccMap.get(evt.getSource());
                if (obj3 != null && obj3 instanceof NamedSubeditor) {
                    ((NamedSubeditor)obj3).updateEditorName();
                }
            } else if ((evt.getNewValue() == null || evt.getOldValue() != null) && evt.getNewValue() == null && evt.getOldValue() != null && (obj = ReportContainer.this.ccMap.get(evt.getOldValue())) != null) {
                ReportContainer.this.removeEditorPage(evt, obj);
            }
            ReportContainer.this.getPropertyChangeSupport().firePropertyChange(evt);
            if (!propertyName.equals(MGraphicElement.FORCE_GRAPHICAL_REFRESH) && !propertyName.equals("refreshUIEvent")) {
                ReportContainer.this.firePropertyChange(257);
            }
        }
    };
    private IPropertyListener titleListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                int ind = ReportContainer.this.editors.indexOf((AbstractVisualEditor)source);
                ReportContainer.this.setPageText(ind, ((AbstractVisualEditor)source).getPartName());
            }
        }
    };
    private TabbedPropertySheetPage propertySheetPage;
    private ReportEditor reportEditor;

    public PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public ReportContainer(EditorPart parent, JasperReportsConfiguration jrContext) {
        this.parent = parent;
        this.jrContext = jrContext;
        this.selectionCache = new CommonSelectionCacheProvider();
        this.selectionCache.setAllowingDishomogeneousSelection(true);
        jrContext.put(SELECTION_CACHE_KEY, this.selectionCache);
    }

    @Override
    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    @Override
    protected void createPages() {
        try {
            this.reportEditor = this.createReportEditor(this.jrContext);
            int index = this.addPage((IEditorPart)this.reportEditor, this.getEditorInput());
            this.setPageText(index, Messages.common_main_report);
            this.setPageImage(index, this.reportEditor.getPartImage());
            this.editors.add(this.reportEditor);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.common_error_creating_nested_visual_editor, null, (IStatus)e.getStatus());
        }
        this.getEditorSite().getActionBarContributor();
    }

    protected ReportEditor createReportEditor(JasperReportsConfiguration context) {
        return new ReportEditor(context);
    }

    public void doSave(IProgressMonitor monitor) {
        for (AbstractVisualEditor editor : this.editors) {
            editor.doSave(monitor);
        }
    }

    public void doSaveAs() {
        for (AbstractVisualEditor editor : this.editors) {
            editor.doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setModel(INode model) {
        if (this.model != null && this.model.getChildren() != null && !this.model.getChildren().isEmpty()) {
            this.model.getChildren().get(0).getPropertyChangeSupport().removePropertyChangeListener(this.modelListener);
        }
        if (model != null && model.getChildren() != null && !model.getChildren().isEmpty()) {
            model.getChildren().get(0).getPropertyChangeSupport().addPropertyChangeListener(this.modelListener);
        }
        this.model = model;
        this.updateVisualView();
    }

    private AbstractVisualEditor createEditorPage(Object obj) {
        AbstractVisualEditor ave = this.ccMap.get(obj);
        try {
            if (ave == null) {
                JasperDesign jd = this.getModel().getJasperDesign();
                MRoot root = new MRoot(null, jd);
                root.setJasperConfiguration(this.jrContext);
                MPage rep = new MPage((ANode)root, jd);
                rep.setJasperConfiguration(this.jrContext);
                ANode node = this.m.createNode(rep, obj, -1);
                if (node != null) {
                    node.createSubeditor();
                    ave = this.m.getEditor(obj, this.jrContext);
                    if (ave != null) {
                        ave.getEditDomain().setCommandStack(this.reportEditor.getEditDomain().getCommandStack());
                        ave.getEditDomain().setPaletteViewer(this.reportEditor.getEditDomain().getPaletteViewer());
                        int index = this.addPage((IEditorPart)ave, this.getEditorInput());
                        this.editors.add(ave);
                        this.ccMap.put(node.getValue(), ave);
                        ave.setModel(root);
                        this.setPageText(index, ave.getPartName());
                        this.setPageImage(index, ave.getPartImage());
                        rep.getPropertyChangeSupport().addPropertyChangeListener(this.modelListener);
                        ave.addPropertyListener(this.titleListener);
                    }
                }
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return ave;
    }

    private void removeEditorPage(PropertyChangeEvent evt, AbstractVisualEditor ave) {
        boolean switchToMainPage;
        if (ave.getModel() != null && this.modelListener != null) {
            ave.getModel().getPropertyChangeSupport().addPropertyChangeListener(this.modelListener);
        }
        ave.setModel(null);
        ave.removePropertyListener(this.titleListener);
        int ind = this.editors.indexOf(ave);
        boolean bl = switchToMainPage = ind == this.getActivePage();
        if (switchToMainPage) {
            this.switchEditorPage(0);
        }
        if (ind >= 0 && ind < this.getPageCount()) {
            this.removePage(ind);
        }
        this.editors.remove(ind);
        if (evt != null) {
            this.ccMap.remove(evt.getOldValue());
        } else {
            Object okey = null;
            for (Object key : this.ccMap.keySet()) {
                AbstractVisualEditor value = this.ccMap.get(key);
                if (value == null || value != ave) continue;
                okey = key;
                break;
            }
            this.ccMap.remove(okey);
        }
        ave.dispose();
    }

    public void updateVisualView() {
        if (!this.editors.isEmpty()) {
            this.editors.get(0).setModel(this.model);
            while (this.editors.size() > 1) {
                AbstractVisualEditor ave = this.editors.get(1);
                this.removeEditorPage(null, ave);
            }
            this.setActiveEditor((IEditorPart)this.editors.get(0));
        }
        for (AbstractVisualEditor ave : this.editors) {
            ave.setModel(this.model);
        }
    }

    public AbstractVisualEditor getMainEditor() {
        if (this.editors != null && !this.editors.isEmpty()) {
            return this.editors.get(0);
        }
        return null;
    }

    public boolean hasSubeditorOpened() {
        return this.ccMap != null && !this.ccMap.isEmpty();
    }

    public INode getModel() {
        return this.model;
    }

    @Override
    public Object getAdapter(Class type) {
        if (type == IPropertySource.class) {
            return this.getPropertySheetPage();
        }
        if (type == IPropertySource2.class) {
            return this.getPropertySheetPage();
        }
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(type);
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        this.propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        return this.propertySheetPage;
    }

    @Override
    public CommonSelectionCacheProvider getSelectionCache() {
        return this.selectionCache;
    }

    public String getContributorId() {
        return "com.jaspersoft.studio.editor.report.ReportContainer";
    }

    protected void refreshVisuals(INode report) {
        if (report != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(report.getJasperDesign(), "refreshUIEvent", null, null);
            report.getPropertyChangeSupport().firePropertyChange(event);
        }
    }

    @Override
    protected void postPageChange(int newPageIndex, int oldPageIndex) {
        AbstractVisualEditor activeEditor = this.editors.get(newPageIndex);
        IEditorActionBarContributor contributor = this.parent.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            MultiPageEditorActionBarContributor toolbarContributor = (MultiPageEditorActionBarContributor)contributor;
            toolbarContributor.setActivePage((IEditorPart)activeEditor);
        }
    }

    @Override
    public void openEditor(Object obj, ANode node) {
        if (this.getEditorInput() instanceof FileEditorInput) {
            if (obj instanceof JRDesignReportTemplate || obj instanceof JRSimpleTemplate || obj instanceof JRStyle || obj instanceof JRConditionalStyle || obj instanceof JRTemplateReference) {
                StyleTemplateFactory.openEditor(obj, this.getEditorInput(), node);
                return;
            }
            if (obj instanceof JRDesignSubreport) {
                String path;
                JRDesignSubreport s;
                IFile file = (IFile)this.jrContext.get("ifile");
                String parentPath = file.getParent().getLocation().toFile().getAbsolutePath();
                SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)parentPath);
                SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)this.jrContext, (RepositoryResourceContext)context);
                RepositoryUtil ru = RepositoryUtil.getInstance((RepositoryContext)repoContext);
                if (this.getEditorInput() instanceof FileEditorInput && (s = (JRDesignSubreport)obj).getExpression() != null && (path = ExpressionUtil.cachedExpressionEvaluationString(s.getExpression(), this.jrContext)) != null) {
                    String fpath;
                    block31: {
                        fpath = path.replaceAll("\\.jasper$", ".jrxml");
                        try {
                            ru.getBytesFromLocation(fpath);
                        }
                        catch (JRException e) {
                            if (e.getMessage().startsWith("Byte data not found at:") && s.getExpression().getText().trim().contains("$P{SUBREPORT_DIR}")) {
                                String p = ExpressionUtil.cachedExpressionEvaluationString((JRExpression)new JRDesignExpression("$P{SUBREPORT_DIR}"), this.jrContext);
                                if ((p = StringUtils.remove((String)path, (String)p)) == null) break block31;
                                fpath = p.replaceAll("\\.jasper$", ".jrxml");
                                try {
                                    ru.getBytesFromLocation(fpath);
                                }
                                catch (JRException e1) {
                                    e1.printStackTrace();
                                    try {
                                        ru.getBytesFromLocation(p);
                                        if (!UIUtils.showConfirmation((String)"Subreport File", (String)String.format("File %s does not exists, do you want to open %s?", fpath, path))) {
                                            return;
                                        }
                                        fpath = p;
                                        break block31;
                                    }
                                    catch (JRException e2) {
                                        UIUtils.showError((Throwable)e2);
                                        return;
                                    }
                                }
                            }
                            e.printStackTrace();
                            try {
                                ru.getBytesFromLocation(path);
                                if (!UIUtils.showConfirmation((String)"Subreport File", (String)String.format("File %s does not exists, do you want to open %s?", fpath, path))) {
                                    return;
                                }
                                fpath = path;
                            }
                            catch (JRException e1) {
                                UIUtils.showError((Throwable)e1);
                                return;
                            }
                        }
                    }
                    SelectionHelper.openEditor((FileEditorInput)this.getEditorInput(), fpath);
                }
                return;
            }
            if (obj instanceof JRDesignImage) {
                JRDesignImage s;
                if (this.getEditorInput() instanceof FileEditorInput && (s = (JRDesignImage)obj).getExpression() != null) {
                    SelectionHelper.openEditor((FileEditorInput)this.getEditorInput(), ExpressionUtil.cachedExpressionEvaluationString(s.getExpression(), this.jrContext));
                }
                return;
            }
        }
        if (obj instanceof JRDesignScriptlet) {
            String str = ((JRDesignScriptlet)obj).getValueClassName();
            IProject prj = ((FileEditorInput)this.getEditorInput()).getFile().getProject();
            IJavaProject javaProject = JavaCore.create((IProject)prj);
            if (javaProject != null) {
                try {
                    IType type = javaProject.findType(str);
                    if (type != null) {
                        JavaUI.openInEditor((IJavaElement)type);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        if (obj instanceof JasperDesign) {
            this.setActivePage(0);
        } else {
            int index;
            AbstractVisualEditor ave = this.ccMap.get(obj);
            if (ave == null && (ave = this.createEditorPage(obj)) != null && ave.getModel().getChildren().size() > 0 && ave.getModel().getChildren().get(0) instanceof MPage) {
                MPage pageElement = (MPage)ave.getModel().getChildren().get(0);
                pageElement.setRealParent(node.getParent());
            }
            if (ave != null && this.getActiveEditor() != ave && (index = this.editors.indexOf(ave)) > 0 && index <= this.editors.size() - 1) {
                this.setActivePage(index);
                final Composite prnt = this.getContainer().getParent();
                final Point size = prnt.getSize();
                prnt.getParent().setSize(size.x - 2, size.y - 2);
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        prnt.getParent().setSize(size.x, size.y);
                    }
                });
            }
        }
        if (obj instanceof JRDesignParameter && node instanceof MParameter) {
            MParameter param = (MParameter)node;
            JRDesignExpression defaultValueExpression = (JRDesignExpression)param.getPropertyValue("defaultValueExpression");
            ExpressionContext expContext = param.getExpressionContext();
            if (expContext != null) {
                expContext.setVisibilities(EnumSet.of(ExpressionContext.Visibility.SHOW_PARAMETERS));
            }
            if (!ExpressionEditorSupportUtil.isExpressionEditorDialogOpen()) {
                JRExpressionEditor wizard = new JRExpressionEditor();
                wizard.setValue(defaultValueExpression);
                wizard.setExpressionContext(expContext);
                WizardDialog dialog = ExpressionEditorSupportUtil.getExpressionEditorWizardDialog(UIUtils.getShell(), wizard);
                if (dialog.open() == 0) {
                    JRDesignExpression value = wizard.getValue();
                    param.setPropertyValue("defaultValueExpression", value);
                }
            }
        }
    }

    public boolean isBackgroundImageEditable() {
        return this.editBackgroundImage;
    }

    public void setBackgroundImageEditable(boolean value) {
        this.editBackgroundImage = value;
    }

    public int getDefaultSelectedPageIndex() {
        boolean defaultValue;
        boolean advancedDefault;
        JasperReportsConfiguration jConfig;
        if (this.propertySheetPage != null && this.getModel() instanceof MRoot && this.getModel().getChildren().size() > 0 && (jConfig = ((ANode)this.getModel().getChildren().get(0)).getJasperConfiguration()) != null && (advancedDefault = jConfig.getPropertyBoolean("defaultAdvanced", defaultValue = Activator.getDefault().getPreferenceStore().getBoolean("defaultAdvanced")).booleanValue())) {
            return this.propertySheetPage.getCurrentTabs().size() - 1;
        }
        return 0;
    }

    @Override
    protected void pageChange(int newPageIndex, int oldPageIndex) {
        super.pageChange(newPageIndex, oldPageIndex);
        AbstractVisualEditor activeEditor = (AbstractVisualEditor)this.getActiveEditor();
        JSSCompoundCommand.forceRefreshVisuals(JSSCompoundCommand.getMainNode(activeEditor.getModel()));
    }
}

