/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.editor.gef.parts.ImageFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.text.TextFieldFigureEditPart;
import com.jaspersoft.studio.editor.report.UnitTransfer;
import com.jaspersoft.studio.model.APropertyNode;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlinkParameter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class ReportUnitDropTargetListener
extends AbstractTransferDropTargetListener {
    public ReportUnitDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)UnitTransfer.getInstance());
    }

    protected void updateTargetRequest() {
    }

    protected void updateTargetEditPart() {
        this.setTargetEditPart(this.calculateTargetEditPart());
    }

    public void dragLeave(DropTargetEvent event) {
        this.setCurrentEvent(event);
    }

    private static JRDesignHyperlinkParameter generateParameter(String name, String expressionValue) {
        JRDesignHyperlinkParameter newParam = new JRDesignHyperlinkParameter();
        newParam.setName(name);
        newParam.setValueExpression((JRExpression)new JRDesignExpression("\"" + expressionValue + "\""));
        return newParam;
    }

    protected void handleDrop() {
        APropertyNode textField;
        if ((this.getTargetEditPart() instanceof TextFieldFigureEditPart || this.getTargetEditPart() instanceof ImageFigureEditPart) && (textField = (APropertyNode)this.getTargetEditPart().getModel()) != null) {
            JRHyperlinkParameter[] parameters = (JRHyperlinkParameter[])textField.getPropertyValue("hyperlinkParameters");
            if (parameters == null) {
                parameters = new JRHyperlinkParameter[]{};
            }
            ArrayList<JRDesignHyperlinkParameter> newParams = new ArrayList<JRDesignHyperlinkParameter>();
            String[] dropParameters = (String[])this.getCurrentEvent().data;
            newParams.add(ReportUnitDropTargetListener.generateParameter("_report", dropParameters[0]));
            int i = 1;
            while (i < dropParameters.length) {
                newParams.add(ReportUnitDropTargetListener.generateParameter(dropParameters[i], ""));
                ++i;
            }
            parameters = newParams.toArray(new JRHyperlinkParameter[newParams.size()]);
            textField.setPropertyValue("hyperlinkParameters", parameters);
            textField.setPropertyValue("hyperlinkType", "ReportExecution");
        }
    }

    protected EditPart calculateTargetEditPart() {
        EditPart ep = this.getViewer().findObjectAt(this.getDropLocation());
        if (ep instanceof TextFieldFigureEditPart || ep instanceof ImageFigureEditPart) {
            return ep;
        }
        return null;
    }
}

