/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.java2d.J2DScrollingGraphicalViewer;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.swt.ResourceManager;

public class ScrollEditDomain
extends DefaultEditDomain {
    private static final Cursor CURSOR_CENTER = ResourceManager.getCursor(JaspersoftStudioPlugin.class, (String)"/icons/cursors/center.png");
    private static final Cursor CURSOR_UP = ResourceManager.getCursor(JaspersoftStudioPlugin.class, (String)"/icons/cursors/up.png");
    private static final Cursor CURSOR_DOWN = ResourceManager.getCursor(JaspersoftStudioPlugin.class, (String)"/icons/cursors/down.png");
    private static final Cursor CURSOR_LEFT = ResourceManager.getCursor(JaspersoftStudioPlugin.class, (String)"/icons/cursors/left.png");
    private static final Cursor CURSOR_RIGHT = ResourceManager.getCursor(JaspersoftStudioPlugin.class, (String)"/icons/cursors/right.png");
    private static final int VERTICAL_THRESHOLD = 100;
    private static final int HORIZONTAL_THRESHOLD = 100;
    private boolean easyScrollEnabled = false;
    private Point clickPoint = null;
    private Point currentMouseLocation;
    private Thread scrollThread = null;
    private Runnable scrollRunnbable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Display disp = UIUtils.getDisplay();
            ScrollEditDomain scrollEditDomain = ScrollEditDomain.this;
            synchronized (scrollEditDomain) {
                block17: {
                    try {
                        try {
                            FigureCanvas canvas = ((J2DScrollingGraphicalViewer)ScrollEditDomain.this.getViewer()).getFigureCanvas();
                            Viewport port = canvas.getViewport();
                            while (ScrollEditDomain.this.clickPoint != null) {
                                Point currentPoint;
                                int amount;
                                if (ScrollEditDomain.this.currentMouseLocation.y < ScrollEditDomain.this.clickPoint.y - 100) {
                                    amount = ScrollEditDomain.this.clickPoint.y - 100 - ScrollEditDomain.this.currentMouseLocation.y;
                                    currentPoint = port.getViewLocation();
                                    ScrollEditDomain.this.scrollTo(disp, canvas, currentPoint.x, Math.max(0, currentPoint.y - amount));
                                    ScrollEditDomain.this.setCursor(disp, CURSOR_UP);
                                } else if (ScrollEditDomain.this.currentMouseLocation.y > ScrollEditDomain.this.clickPoint.y + 100) {
                                    amount = ScrollEditDomain.this.currentMouseLocation.y - (ScrollEditDomain.this.clickPoint.y + 100);
                                    currentPoint = port.getViewLocation();
                                    ScrollEditDomain.this.scrollTo(disp, canvas, currentPoint.x, Math.max(0, currentPoint.y + amount));
                                    ScrollEditDomain.this.setCursor(disp, CURSOR_DOWN);
                                } else if (ScrollEditDomain.this.currentMouseLocation.x < ScrollEditDomain.this.clickPoint.x - 100) {
                                    amount = ScrollEditDomain.this.clickPoint.x - 100 - ScrollEditDomain.this.currentMouseLocation.x;
                                    currentPoint = port.getViewLocation();
                                    ScrollEditDomain.this.scrollTo(disp, canvas, Math.max(0, currentPoint.x - amount), currentPoint.y);
                                    ScrollEditDomain.this.setCursor(disp, CURSOR_LEFT);
                                } else if (ScrollEditDomain.this.currentMouseLocation.x > ScrollEditDomain.this.clickPoint.x + 100) {
                                    amount = ScrollEditDomain.this.currentMouseLocation.x - (ScrollEditDomain.this.clickPoint.x + 100);
                                    currentPoint = port.getViewLocation();
                                    ScrollEditDomain.this.scrollTo(disp, canvas, Math.max(0, currentPoint.x + amount), currentPoint.y);
                                    ScrollEditDomain.this.setCursor(disp, CURSOR_RIGHT);
                                } else {
                                    ScrollEditDomain.this.setCursor(disp, CURSOR_CENTER);
                                }
                                Thread.sleep(10L);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            ScrollEditDomain.this.scrollThread = null;
                            ScrollEditDomain.this.setCursor(disp, null);
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        ScrollEditDomain.this.scrollThread = null;
                        ScrollEditDomain.this.setCursor(disp, null);
                        throw throwable;
                    }
                    ScrollEditDomain.this.scrollThread = null;
                    ScrollEditDomain.this.setCursor(disp, null);
                }
            }
        }
    };

    public ScrollEditDomain(AbstractVisualEditor editorPart) {
        super((IEditorPart)editorPart);
        Assert.isNotNull((Object)editorPart);
    }

    protected GraphicalViewer getViewer() {
        return ((AbstractVisualEditor)this.getEditorPart()).getGraphicalViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMouseScroll(boolean value, MouseEvent event) {
        if (value == this.easyScrollEnabled) {
            return;
        }
        this.easyScrollEnabled = value;
        if (this.easyScrollEnabled) {
            this.clickPoint = new Point(event.x, event.y);
            this.currentMouseLocation = new Point(event.x, event.y);
            ScrollEditDomain scrollEditDomain = this;
            synchronized (scrollEditDomain) {
                if (this.scrollThread == null) {
                    this.scrollThread = new Thread(this.scrollRunnbable);
                    this.scrollThread.start();
                }
            }
        } else {
            this.clickPoint = null;
        }
    }

    public void mouseDown(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (mouseEvent.button == 2) {
            this.setMouseScroll(!this.easyScrollEnabled, mouseEvent);
        } else {
            this.setMouseScroll(false, mouseEvent);
            super.mouseDown(mouseEvent, viewer);
        }
    }

    public void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
        if (this.easyScrollEnabled) {
            this.setMouseScroll(false, null);
        }
        super.keyDown(keyEvent, viewer);
    }

    public void mouseMove(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.easyScrollEnabled) {
            this.currentMouseLocation = new Point(mouseEvent.x, mouseEvent.y);
        }
        super.mouseMove(mouseEvent, viewer);
    }

    private void setCursor(Display disp, final Cursor cursor) {
        if (!disp.isDisposed()) {
            disp.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (cursor == null || !cursor.isDisposed()) {
                        ScrollEditDomain.this.getViewer().setCursor(cursor);
                    }
                }
            });
        }
    }

    private void scrollTo(Display disp, final FigureCanvas canvas, final int x, final int y) {
        if (!disp.isDisposed()) {
            disp.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!canvas.isDisposed()) {
                        canvas.scrollSmoothTo(x, y);
                    }
                }
            });
        }
    }
}

