/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class UnitTransfer
extends ByteArrayTransfer {
    private static UnitTransfer instance = new UnitTransfer();
    private static final String TYPE_NAME = "unit-transfer-format";
    private static final int TYPEID = UnitTransfer.registerType((String)"unit-transfer-format");

    public static UnitTransfer getInstance() {
        return instance;
    }

    private UnitTransfer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] fromByteArray(byte[] bytes) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            int n = in.readInt();
            String[] gadgets = new String[n];
            int i = 0;
            while (true) {
                if (i >= n) {
                    return gadgets;
                }
                String gadget = this.readGadget(in);
                if (gadget == null) {
                    return null;
                }
                gadgets[i] = gadget;
                ++i;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] bytes = this.toByteArray((String[])object);
        if (bytes != null) {
            super.javaToNative((Object)bytes, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        super.isSupportedType(transferData);
        if (bytes != null) {
            return this.fromByteArray(bytes);
        }
        return null;
    }

    private String readGadget(ObjectInputStream dataIn) throws IOException {
        try {
            return (String)dataIn.readObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected byte[] toByteArray(String[] nodes) {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeInt(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                this.writeNode(nodes[i], out);
                ++i;
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException iOException) {}
        return bytes;
    }

    private void writeNode(String node, ObjectOutputStream dataOut) throws IOException {
        dataOut.writeObject(node);
    }
}

