/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.style.command;

import com.jaspersoft.studio.model.style.MStyleTemplateReference;
import com.jaspersoft.studio.model.style.MStylesTemplate;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.FilteredHelpDialog;
import java.io.File;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CreateStyleTemplateReferenceCommand
extends Command {
    private JRTemplateReference jrTemplate;
    private JRSimpleTemplate jrDesign;
    private int index;
    private JasperReportsConfiguration jConfig;

    public CreateStyleTemplateReferenceCommand(MStylesTemplate destNode, MStyleTemplateReference srcNode, int index) {
        this.jrDesign = (JRSimpleTemplate)destNode.getValue();
        this.jConfig = destNode.getJasperConfiguration();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrTemplate = (JRTemplateReference)srcNode.getValue();
        }
    }

    public void execute() {
        this.createObject();
        if (this.jrTemplate != null) {
            if (this.index < 0 || this.index > this.jrDesign.getIncludedTemplatesList().size()) {
                this.jrDesign.addIncludedTemplate(this.jrTemplate);
            } else {
                this.jrDesign.addIncludedTemplate(this.index, this.jrTemplate);
            }
        }
    }

    private void createObject() {
        if (this.jrTemplate == null) {
            FilteredHelpDialog fd = new FilteredHelpDialog(Display.getCurrent().getActiveShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1, ContextHelpIDs.WIZARD_STYLE_TEMPLATE_LOAD);
            fd.setInitialPattern("*.jrtx");
            if (fd.open() == 0) {
                IFile file = (IFile)fd.getFirstResult();
                File fileToBeOpened = file.getRawLocation().makeAbsolute().toFile();
                boolean showErrorMessage = false;
                if (fileToBeOpened != null && fileToBeOpened.exists() && fileToBeOpened.isFile()) {
                    try {
                        JRXmlTemplateLoader.load((File)fileToBeOpened);
                        this.jrTemplate = MStyleTemplateReference.createJRTemplate();
                        this.jrTemplate.setLocation(this.getStylePath(file));
                    }
                    catch (Exception exception) {
                        showErrorMessage = true;
                    }
                } else {
                    showErrorMessage = true;
                }
                if (showErrorMessage) {
                    MessageDialog.open((int)1, (Shell)Display.getCurrent().getActiveShell(), (String)Messages.UIUtils_ExceptionTitle, (String)Messages.CreateStyleTemplateCommand_loadStyleError, (int)0);
                }
            }
        }
    }

    private String getStylePath(IFile styleFile) {
        IFile reportFile = (IFile)this.jConfig.get("ifile");
        if (reportFile != null) {
            if (reportFile.getParent().equals((Object)styleFile.getParent())) {
                return styleFile.getName();
            }
            if (reportFile.getProject().equals((Object)styleFile.getProject())) {
                return styleFile.getProjectRelativePath().toPortableString();
            }
        }
        return styleFile.getRawLocation().makeAbsolute().toOSString();
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.jrDesign.removeIncludedTemplate(this.jrTemplate);
    }
}

